/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.filters;

import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ValueRange;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterHelper;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterSupportStatus;
import com.google.cloud.bigtable.hbase.adapters.filters.TypedFilterAdapterBase;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.ValueFilter;

public class ValueFilterAdapter
extends TypedFilterAdapterBase<ValueFilter> {
    @Override
    public RowFilter adapt(FilterAdapterContext context, ValueFilter filter) throws IOException {
        if (filter.getComparator() instanceof BinaryComparator) {
            return this.adaptBinaryComparator(filter.getOperator(), (BinaryComparator)filter.getComparator());
        }
        if (filter.getComparator() instanceof RegexStringComparator) {
            return this.adaptRegexStringComparator(filter.getOperator(), (RegexStringComparator)filter.getComparator());
        }
        throw new IllegalStateException(String.format("Cannot adapt filter with comparator%s", filter.getComparator()));
    }

    @Override
    public FilterSupportStatus isFilterSupported(FilterAdapterContext context, ValueFilter filter) {
        if (filter.getComparator() instanceof BinaryComparator || filter.getComparator() instanceof RegexStringComparator && filter.getOperator() == CompareFilter.CompareOp.EQUAL) {
            return FilterSupportStatus.SUPPORTED;
        }
        return FilterSupportStatus.newNotSupported(String.format("ValueFilter must have either a BinaryComparator with any compareOp or a RegexStringComparator with an EQUAL compareOp. Found (%s, %s)", filter.getComparator().getClass().getSimpleName(), filter.getOperator()));
    }

    private RowFilter adaptBinaryComparator(CompareFilter.CompareOp compareOp, BinaryComparator comparator) {
        ByteString value = ByteString.copyFrom(comparator.getValue());
        switch (compareOp) {
            case LESS: {
                return ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setEndValueOpen(value));
            }
            case LESS_OR_EQUAL: {
                return ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setEndValueClosed(value));
            }
            case EQUAL: {
                if (comparator.getValue().length == 0) {
                    return RowFilter.newBuilder().setValueRegexFilter(value).build();
                }
                return ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setStartValueClosed(value).setEndValueClosed(value));
            }
            case NOT_EQUAL: {
                return RowFilter.newBuilder().setInterleave(RowFilter.Interleave.newBuilder().addFilters(ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setEndValueOpen(value))).addFilters(ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setStartValueOpen(value)))).build();
            }
            case GREATER_OR_EQUAL: {
                return ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setStartValueClosed(value));
            }
            case GREATER: {
                return ValueFilterAdapter.createRowFilter(ValueRange.newBuilder().setStartValueOpen(value));
            }
            case NO_OP: {
                return FilterAdapterHelper.ACCEPT_ALL_FILTER;
            }
        }
        throw new IllegalStateException(String.format("Cannot handle unknown compare op %s", compareOp));
    }

    private static RowFilter createRowFilter(ValueRange.Builder valueRange) {
        return RowFilter.newBuilder().setValueRangeFilter(valueRange).build();
    }

    private RowFilter adaptRegexStringComparator(CompareFilter.CompareOp compareOp, RegexStringComparator comparator) {
        String pattern = FilterAdapterHelper.extractRegexPattern(comparator);
        switch (compareOp) {
            case EQUAL: {
                return RowFilter.newBuilder().setValueRegexFilter(ByteString.copyFromUtf8(pattern)).build();
            }
            case NO_OP: {
                return FilterAdapterHelper.ACCEPT_ALL_FILTER;
            }
        }
        throw new IllegalStateException(String.format("Cannot adapt regex filter with compare op %s", compareOp));
    }
}

