/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import java.io.IOException;
import org.apache.hadoop.hbase.client.AbstractClientScanner;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;

public class BigtableResultScannerAdapter<T> {
    final ResponseAdapter<T, Result> rowAdapter;

    public BigtableResultScannerAdapter(ResponseAdapter<T, Result> rowAdapter) {
        this.rowAdapter = rowAdapter;
    }

    public ResultScanner adapt(final com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner<T> bigtableResultScanner) {
        return new AbstractClientScanner(){

            public Result next() throws IOException {
                Object row = bigtableResultScanner.next();
                if (row == null) {
                    return null;
                }
                return BigtableResultScannerAdapter.this.rowAdapter.adaptResponse(row);
            }

            public void close() {
                try {
                    bigtableResultScanner.close();
                }
                catch (IOException ioe) {
                    throw Throwables.propagate(ioe);
                }
            }

            public boolean renewLease() {
                throw new UnsupportedOperationException("renewLease");
            }
        };
    }
}

