/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.adapters.ResponseAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.RowCell;
import com.google.cloud.bigtable.hbase.util.TimestampConverter;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;

public class FlatRowAdapter
implements ResponseAdapter<FlatRow, Result> {
    static final long TIME_CONVERSION_UNIT = BigtableConstants.BIGTABLE_TIMEUNIT.convert(1L, BigtableConstants.HBASE_TIMEUNIT);

    @Override
    public Result adaptResponse(FlatRow flatRow) {
        if (flatRow == null || flatRow.getRowKey() == null) {
            return Result.EMPTY_RESULT;
        }
        byte[] RowKey = ByteStringer.extract(flatRow.getRowKey());
        List<FlatRow.Cell> cells = flatRow.getCells();
        ArrayList<RowCell> hbaseCells = new ArrayList<RowCell>(cells.size());
        byte[] previousFamilyBytes = null;
        String previousFamily = null;
        for (FlatRow.Cell cell : cells) {
            if (!cell.getLabels().isEmpty()) continue;
            String family = cell.getFamily();
            byte[] familyBytes = !Objects.equal(family, previousFamily) ? Bytes.toBytes((String)family) : previousFamilyBytes;
            hbaseCells.add(FlatRowAdapter.toRowCell(RowKey, cell, familyBytes));
            previousFamily = family;
            previousFamilyBytes = familyBytes;
        }
        return Result.create(hbaseCells);
    }

    private static RowCell toRowCell(byte[] rowKey, FlatRow.Cell cell, byte[] family) {
        return new RowCell(rowKey, family, ByteStringer.extract(cell.getQualifier()), TimestampConverter.bigtable2hbase(cell.getTimestamp()), ByteStringer.extract(cell.getValue()));
    }

    public FlatRow adaptToRow(Result result) {
        if (result.getRow() == null) {
            return null;
        }
        FlatRow.Builder rowBuilder = FlatRow.newBuilder().withRowKey(ByteStringer.wrap(result.getRow()));
        Cell[] rawCells = result.rawCells();
        if (rawCells != null && rawCells.length > 0) {
            for (Cell rawCell : rawCells) {
                rowBuilder.addCell(Bytes.toString((byte[])rawCell.getFamilyArray(), (int)rawCell.getFamilyOffset(), (int)rawCell.getFamilyLength()), ByteStringer.wrap(rawCell.getQualifierArray(), rawCell.getQualifierOffset(), rawCell.getQualifierLength()), TimestampConverter.hbase2bigtable(rawCell.getTimestamp()), ByteStringer.wrap(rawCell.getValueArray(), rawCell.getValueOffset(), rawCell.getValueLength()));
            }
        }
        return rowBuilder.build();
    }
}

