/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.adapters.read;

import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.bigtable.v2.TimestampRange;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.RowKeyWrapper;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.collect.Range;
import com.google.bigtable.repackaged.com.google.common.collect.RangeSet;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.bigtable.hbase.BigtableConstants;
import com.google.cloud.bigtable.hbase.BigtableExtendedScan;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapter;
import com.google.cloud.bigtable.hbase.adapters.filters.FilterAdapterContext;
import com.google.cloud.bigtable.hbase.adapters.read.ReadHooks;
import com.google.cloud.bigtable.hbase.adapters.read.ReadOperationAdapter;
import com.google.cloud.bigtable.hbase.adapters.read.ReaderExpressionHelper;
import com.google.cloud.bigtable.hbase.adapters.read.RowRangeAdapter;
import java.io.IOException;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.TimeRange;

public class ScanAdapter
implements ReadOperationAdapter<Scan> {
    private static final int UNSET_MAX_RESULTS_PER_COLUMN_FAMILY = -1;
    private final FilterAdapter filterAdapter;
    private final RowRangeAdapter rowRangeAdapter;

    public ScanAdapter(FilterAdapter filterAdapter, RowRangeAdapter rowRangeAdapter) {
        this.filterAdapter = filterAdapter;
        this.rowRangeAdapter = rowRangeAdapter;
    }

    public void throwIfUnsupportedScan(Scan scan) {
        if (scan.getFilter() != null) {
            this.filterAdapter.throwIfUnsupportedFilter(scan, scan.getFilter());
        }
        if (scan.getMaxResultsPerColumnFamily() != -1) {
            throw new UnsupportedOperationException("Limiting of max results per column family is not supported.");
        }
    }

    public RowFilter buildFilter(Scan scan, ReadHooks hooks) {
        Optional<RowFilter> userFilter;
        RowFilter.Chain.Builder chainBuilder = RowFilter.Chain.newBuilder();
        chainBuilder.addFilters(this.createColumnFamilyFilter(scan));
        if (scan.getTimeRange() != null && !scan.getTimeRange().isAllTime()) {
            chainBuilder.addFilters(this.createTimeRangeFilter(scan.getTimeRange()));
        }
        chainBuilder.addFilters(this.createColumnLimitFilter(scan.getMaxVersions()));
        if (scan.getFilter() != null && (userFilter = this.createUserFilter(scan, hooks)).isPresent()) {
            chainBuilder.addFilters(userFilter.get());
        }
        if (chainBuilder.getFiltersCount() == 1) {
            return chainBuilder.getFilters(0);
        }
        return RowFilter.newBuilder().setChain(chainBuilder).build();
    }

    @Override
    public ReadRowsRequest.Builder adapt(Scan scan, ReadHooks readHooks) {
        this.throwIfUnsupportedScan(scan);
        RowSet rowSet = this.getRowSet(scan);
        rowSet = this.narrowRowSet(rowSet, scan.getFilter());
        RowFilter rowFilter = this.buildFilter(scan, readHooks);
        return ReadRowsRequest.newBuilder().setRows(rowSet).setFilter(rowFilter);
    }

    private RowSet getRowSet(Scan scan) {
        if (scan instanceof BigtableExtendedScan) {
            return ((BigtableExtendedScan)scan).getRowSet();
        }
        RowSet.Builder rowSetBuilder = RowSet.newBuilder();
        ByteString startRow = ByteString.copyFrom(scan.getStartRow());
        if (scan.isGetScan()) {
            rowSetBuilder.addRowKeys(startRow);
        } else {
            ByteString stopRow;
            RowRange.Builder range = RowRange.newBuilder();
            if (!startRow.isEmpty()) {
                range.setStartKeyClosed(startRow);
            }
            if (!(stopRow = ByteString.copyFrom(scan.getStopRow())).isEmpty()) {
                range.setEndKeyOpen(stopRow);
            }
            rowSetBuilder.addRowRanges(range);
        }
        return rowSetBuilder.build();
    }

    private static byte[] quoteRegex(byte[] unquoted) {
        try {
            return ReaderExpressionHelper.quoteRegularExpression(unquoted);
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when writing to ByteArrayOutputStream", e);
        }
    }

    private Optional<RowFilter> createUserFilter(Scan scan, ReadHooks hooks) {
        try {
            return this.filterAdapter.adaptFilter(new FilterAdapterContext(scan, hooks), scan.getFilter());
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to adapt filter", ioe);
        }
    }

    private RowSet narrowRowSet(RowSet rowSet, Filter filter) {
        if (filter == null) {
            return rowSet;
        }
        RangeSet<RowKeyWrapper> filterRangeSet = this.filterAdapter.getIndexScanHint(filter);
        if (filterRangeSet.encloses(Range.all())) {
            return rowSet;
        }
        RangeSet<RowKeyWrapper> scanRangeSet = this.rowRangeAdapter.rowSetToRangeSet(rowSet);
        scanRangeSet.removeAll(filterRangeSet.complement());
        return this.rowRangeAdapter.rangeSetToRowSet(scanRangeSet);
    }

    private RowFilter createColumnQualifierFilter(byte[] unquotedQualifier) {
        return RowFilter.newBuilder().setColumnQualifierRegexFilter(ByteStringer.wrap(ScanAdapter.quoteRegex(unquotedQualifier))).build();
    }

    private RowFilter createFamilyFilter(byte[] familyName) {
        return RowFilter.newBuilder().setFamilyNameRegexFilterBytes(ByteStringer.wrap(ScanAdapter.quoteRegex(familyName))).build();
    }

    private RowFilter createColumnLimitFilter(int maxVersionsPerColumn) {
        return RowFilter.newBuilder().setCellsPerColumnLimitFilter(maxVersionsPerColumn).build();
    }

    private RowFilter createTimeRangeFilter(TimeRange timeRange) {
        TimestampRange.Builder rangeBuilder = TimestampRange.newBuilder();
        long lowerBound = BigtableConstants.BIGTABLE_TIMEUNIT.convert(timeRange.getMin(), BigtableConstants.HBASE_TIMEUNIT);
        rangeBuilder.setStartTimestampMicros(lowerBound);
        if (timeRange.getMax() != Long.MAX_VALUE) {
            long upperBound = BigtableConstants.BIGTABLE_TIMEUNIT.convert(timeRange.getMax(), BigtableConstants.HBASE_TIMEUNIT);
            rangeBuilder.setEndTimestampMicros(upperBound);
        }
        return RowFilter.newBuilder().setTimestampRangeFilter(rangeBuilder).build();
    }

    private RowFilter createColumnFamilyFilter(Scan scan) {
        RowFilter.Interleave.Builder interleaveBuilder = RowFilter.Interleave.newBuilder();
        Map familyMap = scan.getFamilyMap();
        if (!scan.getFamilyMap().isEmpty()) {
            for (Map.Entry entry : familyMap.entrySet()) {
                RowFilter.Chain.Builder familyBuilder;
                if (entry.getValue() == null) {
                    interleaveBuilder.addFilters(this.createFamilyFilter((byte[])entry.getKey()));
                    continue;
                }
                if (((NavigableSet)entry.getValue()).size() == 1) {
                    familyBuilder = interleaveBuilder.addFiltersBuilder().getChainBuilder();
                    familyBuilder.addFilters(this.createFamilyFilter((byte[])entry.getKey()));
                    familyBuilder.addFilters(this.createColumnQualifierFilter((byte[])((NavigableSet)entry.getValue()).first()));
                    continue;
                }
                familyBuilder = interleaveBuilder.addFiltersBuilder().getChainBuilder();
                familyBuilder.addFilters(this.createFamilyFilter((byte[])entry.getKey()));
                RowFilter.Interleave.Builder columnFilters = familyBuilder.addFiltersBuilder().getInterleaveBuilder();
                for (byte[] qualifier : (NavigableSet)entry.getValue()) {
                    columnFilters.addFilters(this.createColumnQualifierFilter(qualifier));
                }
            }
        } else {
            interleaveBuilder.addFiltersBuilder().setFamilyNameRegexFilter(".*");
        }
        if (interleaveBuilder.getFiltersCount() > 1) {
            return RowFilter.newBuilder().setInterleave(interleaveBuilder).build();
        }
        return interleaveBuilder.getFilters(0);
    }
}

