/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.bigtable.hbase.BigtableBufferedMutator;
import com.google.cloud.bigtable.hbase.BigtableOptionsFactory;
import com.google.cloud.bigtable.hbase.BigtableRegionLocator;
import com.google.cloud.bigtable.hbase.BigtableTable;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;

public abstract class AbstractBigtableConnection
implements Connection,
Closeable {
    private static final AtomicLong SEQUENCE_GENERATOR = new AtomicLong();
    private static final Map<Long, BigtableBufferedMutator> ACTIVE_BUFFERED_MUTATORS = Collections.synchronizedMap(new HashMap());
    private final Logger LOG = new Logger(this.getClass());
    private final Set<RegionLocator> locatorCache = new CopyOnWriteArraySet<RegionLocator>();
    private final Configuration conf;
    private volatile boolean closed = false;
    private volatile boolean aborted;
    private volatile ExecutorService batchPool = null;
    private ExecutorService bufferedMutatorExecutorService;
    private BigtableSession session;
    private volatile boolean cleanupPool = false;
    private final BigtableOptions options;
    private Set<TableName> disabledTables = new HashSet<TableName>();
    private HBaseRequestAdapter.MutationAdapters mutationAdapters;

    public AbstractBigtableConnection(Configuration conf) throws IOException {
        this(conf, false, null, null);
    }

    protected AbstractBigtableConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        BigtableOptions opts;
        if (managed) {
            throw new IllegalArgumentException("Bigtable does not support managed connections.");
        }
        this.conf = conf;
        try {
            opts = BigtableOptionsFactory.fromConfiguration(conf);
        }
        catch (IOException ioe) {
            this.LOG.error("Error loading BigtableOptions from Configuration.", ioe, new Object[0]);
            throw ioe;
        }
        this.batchPool = pool;
        this.closed = false;
        this.session = new BigtableSession(opts);
        this.options = this.session.getOptions();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.batchPool);
    }

    public Table getTable(TableName tableName, ExecutorService pool) throws IOException {
        return new BigtableTable(this, this.createAdapter(tableName));
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        TableName tableName = params.getTableName();
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        final long id = SEQUENCE_GENERATOR.incrementAndGet();
        HBaseRequestAdapter adapter = this.createAdapter(tableName);
        BufferedMutator.ExceptionListener listener = params.getListener();
        BigtableBufferedMutator bigtableBufferedMutator = new BigtableBufferedMutator(adapter, this.conf, this.session, listener){

            @Override
            public void close() throws IOException {
                try {
                    super.close();
                }
                finally {
                    ACTIVE_BUFFERED_MUTATORS.remove(id);
                }
            }
        };
        ACTIVE_BUFFERED_MUTATORS.put(id, bigtableBufferedMutator);
        return bigtableBufferedMutator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseRequestAdapter createAdapter(TableName tableName) {
        if (this.mutationAdapters == null) {
            AbstractBigtableConnection abstractBigtableConnection = this;
            synchronized (abstractBigtableConnection) {
                if (this.mutationAdapters == null) {
                    this.mutationAdapters = new HBaseRequestAdapter.MutationAdapters(this.options, this.conf);
                }
            }
        }
        return new HBaseRequestAdapter(this.options, tableName, this.mutationAdapters);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    @Deprecated
    public Table getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        for (RegionLocator locator : this.locatorCache) {
            if (!locator.getName().equals((Object)tableName)) continue;
            return locator;
        }
        BigtableRegionLocator newLocator = new BigtableRegionLocator(tableName, this.options, this.session.getDataClient());
        if (this.locatorCache.add(newLocator)) {
            return newLocator;
        }
        for (RegionLocator locator : this.locatorCache) {
            if (!locator.getName().equals((Object)tableName)) continue;
            return locator;
        }
        throw new IllegalStateException(newLocator + " was supposed to be in the cache");
    }

    public void abort(String msg, Throwable t) {
        if (t != null) {
            this.LOG.fatal(msg, t, new Object[0]);
        } else {
            this.LOG.fatal(msg, new Object[0]);
        }
        this.aborted = true;
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close the connection", e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.session.close();
            this.shutdownBatchPool();
            if (this.bufferedMutatorExecutorService != null) {
                this.bufferedMutatorExecutorService.shutdown();
                this.bufferedMutatorExecutorService = null;
            }
            this.closed = true;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(AbstractBigtableConnection.class).add("project", this.options.getProjectId()).add("instance", this.options.getInstanceId()).add("dataHost", this.options.getDataHost()).add("tableAdminHost", this.options.getTableAdminHost()).toString();
    }

    private void shutdownBatchPool() {
        if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
            this.batchPool.shutdown();
            try {
                if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.batchPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.batchPool.shutdownNow();
            }
        }
    }

    public abstract Admin getAdmin() throws IOException;

    protected BigtableTableAdminClient getBigtableTableAdminClient() throws IOException {
        return this.session.getTableAdminClient();
    }

    protected BigtableOptions getOptions() {
        return this.options;
    }

    protected Set<TableName> getDisabledTables() {
        return this.disabledTables;
    }

    public BigtableSession getSession() {
        return this.session;
    }

    static {
        Runnable shutDownRunnable = new Runnable(){

            @Override
            public void run() {
                for (BigtableBufferedMutator bbm : ACTIVE_BUFFERED_MUTATORS.values()) {
                    if (!bbm.hasInflightRequests()) continue;
                    int size = ACTIVE_BUFFERED_MUTATORS.size();
                    new Logger(AbstractBigtableConnection.class).warn("Shutdown is commencing and you have open %d buffered mutators.You need to close() or flush() them so that is not lost", size);
                    break;
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(shutDownRunnable));
        Adapters.class.getName();
    }
}

