/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.rpc;

import com.google.bigtable.repackaged.com.google.api.client.util.escape.PercentEscaper;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestParamsEncoder;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.Map;

@InternalApi(value="For use by transport-specific implementations")
public class RequestUrlParamsEncoder<RequestT>
implements RequestParamsEncoder<RequestT> {
    private static final PercentEscaper PERCENT_ESCAPER = new PercentEscaper("._-~");
    private final RequestParamsExtractor<RequestT> paramsExtractor;

    public RequestUrlParamsEncoder(RequestParamsExtractor<RequestT> paramsExtractor) {
        this.paramsExtractor = Preconditions.checkNotNull(paramsExtractor);
    }

    @Override
    public String encode(RequestT request) {
        Map<String, String> params = this.paramsExtractor.extract(request);
        if (params.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            String encodedKey = this.percentEncodeString(entry.getKey());
            String encodedValue = this.percentEncodeString(entry.getValue());
            sb.append(encodedKey).append("=").append(encodedValue);
        }
        return sb.toString();
    }

    private String percentEncodeString(String value) {
        return PERCENT_ESCAPER.escape(value);
    }
}

