/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.rls;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Ticker;
import com.google.bigtable.repackaged.io.grpc.rls.Throttler;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class AdaptiveThrottler
implements Throttler {
    private static final int DEFAULT_HISTORY_SECONDS = 30;
    private static final int DEFAULT_REQUEST_PADDING = 8;
    private static final float DEFAULT_RATIO_FOR_ACCEPT = 2.0f;
    private final int historySeconds;
    private final int requestsPadding;
    private final float ratioForAccepts;
    private final Ticker ticker;
    @VisibleForTesting
    final TimeBasedAccumulator requestStat;
    @VisibleForTesting
    final TimeBasedAccumulator throttledStat;

    private AdaptiveThrottler(Builder builder) {
        this.historySeconds = builder.historySeconds;
        this.requestsPadding = builder.requestsPadding;
        this.ratioForAccepts = builder.ratioForAccepts;
        this.ticker = builder.ticker;
        long internalNanos = TimeUnit.SECONDS.toNanos(this.historySeconds);
        this.requestStat = new TimeBasedAccumulator(internalNanos, this.ticker);
        this.throttledStat = new TimeBasedAccumulator(internalNanos, this.ticker);
    }

    @Override
    public boolean shouldThrottle() {
        return this.shouldThrottle(AdaptiveThrottler.randomFloat());
    }

    @VisibleForTesting
    boolean shouldThrottle(float random) {
        long nowNanos = this.ticker.read();
        if (this.getThrottleProbability(nowNanos) <= random) {
            return false;
        }
        this.requestStat.increment(nowNanos);
        this.throttledStat.increment(nowNanos);
        return true;
    }

    @VisibleForTesting
    float getThrottleProbability(long nowNanos) {
        long requests = this.requestStat.get(nowNanos);
        long accepts = requests - this.throttledStat.get(nowNanos);
        return ((float)requests - this.ratioForAccepts * (float)accepts) / (float)(requests + (long)this.requestsPadding);
    }

    @Override
    public void registerBackendResponse(boolean throttled) {
        long now = this.ticker.read();
        this.requestStat.increment(now);
        if (throttled) {
            this.throttledStat.increment(now);
        }
    }

    private static float randomFloat() {
        return ThreadLocalRandom.current().nextFloat();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("historySeconds", this.historySeconds).add("requestsPadding", this.requestsPadding).add("ratioForAccepts", this.ratioForAccepts).add("requestStat", this.requestStat).add("throttledStat", this.throttledStat).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class TimeBasedAccumulator {
        private static final int NUM_SLOTS = 50;
        private final AtomicReferenceArray<Slot> slots = new AtomicReferenceArray(50);
        private final long interval;
        private final long slotNanos;
        private volatile int currentIndex;
        private final Ticker ticker;

        TimeBasedAccumulator(long internalNanos, Ticker ticker) {
            Preconditions.checkArgument(internalNanos >= 50L, "Interval must be greater than %s", 50);
            this.interval = internalNanos;
            this.slotNanos = internalNanos / 50L;
            this.currentIndex = 0;
            this.ticker = Preconditions.checkNotNull(ticker, "ticker");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Slot getSlot(long now) {
            Slot currentSlot = this.slots.get(this.currentIndex);
            if (currentSlot != null && now - currentSlot.endNanos < 0L) {
                return currentSlot;
            }
            long slotBoundary = this.getSlotEndTime(now);
            TimeBasedAccumulator timeBasedAccumulator = this;
            synchronized (timeBasedAccumulator) {
                int index = this.currentIndex;
                currentSlot = this.slots.get(index);
                if (currentSlot != null && now - currentSlot.endNanos < 0L) {
                    return currentSlot;
                }
                int newIndex = index == 49 ? 0 : index + 1;
                Slot nextSlot = new Slot(slotBoundary);
                this.slots.set(newIndex, nextSlot);
                this.currentIndex = newIndex;
                return nextSlot;
            }
        }

        private long getSlotEndTime(long time) {
            return (time / this.slotNanos + 1L) * this.slotNanos;
        }

        long getInterval() {
            return this.interval;
        }

        void increment(long now) {
            this.getSlot(now).increment();
        }

        long get(long now) {
            long intervalEnd = this.getSlotEndTime(now);
            long intervalStart = intervalEnd - this.interval;
            int index = this.currentIndex;
            long accumulated = 0L;
            Long prevSlotEnd = null;
            for (int i = 0; i < 50; ++i) {
                if (index < 0) {
                    index = 49;
                }
                Slot currentSlot = this.slots.get(index);
                --index;
                if (currentSlot == null) continue;
                long currentSlotEnd = currentSlot.endNanos;
                if (currentSlotEnd - intervalStart <= 0L || prevSlotEnd != null && currentSlotEnd - prevSlotEnd > 0L) break;
                prevSlotEnd = currentSlotEnd;
                if (currentSlotEnd - intervalEnd > 0L) continue;
                accumulated += currentSlot.count;
            }
            return accumulated;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("interval", this.interval).add("current_count", this.get(this.ticker.read())).toString();
        }

        private static final class Slot {
            static final AtomicLongFieldUpdater<Slot> ATOMIC_COUNT = AtomicLongFieldUpdater.newUpdater(Slot.class, "count");
            volatile long count;
            final long endNanos;

            Slot(long endNanos) {
                this.endNanos = endNanos;
                this.count = 0L;
            }

            void increment() {
                ATOMIC_COUNT.incrementAndGet(this);
            }
        }
    }

    static final class Builder {
        private float ratioForAccepts = 2.0f;
        private int historySeconds = 30;
        private int requestsPadding = 8;
        private Ticker ticker = Ticker.systemTicker();

        Builder() {
        }

        public Builder setRatioForAccepts(float ratioForAccepts) {
            this.ratioForAccepts = ratioForAccepts;
            return this;
        }

        public Builder setHistorySeconds(int historySeconds) {
            this.historySeconds = historySeconds;
            return this;
        }

        public Builder setRequestsPadding(int requestsPadding) {
            this.requestsPadding = requestsPadding;
            return this;
        }

        public Builder setTicker(Ticker ticker) {
            this.ticker = Preconditions.checkNotNull(ticker, "ticker");
            return this;
        }

        public AdaptiveThrottler build() {
            return new AdaptiveThrottler(this);
        }
    }
}

