/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.grpc;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestMutator;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;

public class GrpcCallSettings<RequestT, ResponseT> {
    private final MethodDescriptor<RequestT, ResponseT> methodDescriptor;
    private final RequestParamsExtractor<RequestT> paramsExtractor;
    private final RequestMutator<RequestT> requestMutator;
    private final boolean alwaysAwaitTrailers;

    private GrpcCallSettings(Builder<RequestT, ResponseT> builder) {
        this.methodDescriptor = ((Builder)builder).methodDescriptor;
        this.paramsExtractor = ((Builder)builder).paramsExtractor;
        this.requestMutator = ((Builder)builder).requestMutator;
        this.alwaysAwaitTrailers = ((Builder)builder).shouldAwaitTrailers;
    }

    public MethodDescriptor<RequestT, ResponseT> getMethodDescriptor() {
        return this.methodDescriptor;
    }

    public RequestParamsExtractor<RequestT> getParamsExtractor() {
        return this.paramsExtractor;
    }

    public RequestMutator<RequestT> getRequestMutator() {
        return this.requestMutator;
    }

    @BetaApi
    public boolean shouldAwaitTrailers() {
        return this.alwaysAwaitTrailers;
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder().setShouldAwaitTrailers(true);
    }

    public static <RequestT, ResponseT> GrpcCallSettings<RequestT, ResponseT> create(MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
        return GrpcCallSettings.newBuilder().setMethodDescriptor(methodDescriptor).build();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder<RequestT, ResponseT> {
        private MethodDescriptor<RequestT, ResponseT> methodDescriptor;
        private RequestParamsExtractor<RequestT> paramsExtractor;
        private RequestMutator<RequestT> requestMutator;
        private boolean shouldAwaitTrailers;

        private Builder() {
        }

        private Builder(GrpcCallSettings<RequestT, ResponseT> settings) {
            this.methodDescriptor = ((GrpcCallSettings)settings).methodDescriptor;
            this.paramsExtractor = ((GrpcCallSettings)settings).paramsExtractor;
            this.requestMutator = ((GrpcCallSettings)settings).requestMutator;
            this.shouldAwaitTrailers = ((GrpcCallSettings)settings).alwaysAwaitTrailers;
        }

        public Builder<RequestT, ResponseT> setMethodDescriptor(MethodDescriptor<RequestT, ResponseT> methodDescriptor) {
            this.methodDescriptor = methodDescriptor;
            return this;
        }

        public Builder<RequestT, ResponseT> setParamsExtractor(RequestParamsExtractor<RequestT> paramsExtractor) {
            this.paramsExtractor = paramsExtractor;
            return this;
        }

        public Builder<RequestT, ResponseT> setRequestMutator(RequestMutator<RequestT> requestMutator) {
            this.requestMutator = requestMutator;
            return this;
        }

        @BetaApi
        public Builder<RequestT, ResponseT> setShouldAwaitTrailers(boolean b) {
            this.shouldAwaitTrailers = b;
            return this;
        }

        public GrpcCallSettings<RequestT, ResponseT> build() {
            return new GrpcCallSettings(this);
        }
    }
}

