/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Aggregate_Aggregator_Sum;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Bytes;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Bytes_Encoding_Raw;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Int64;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Int64_Encoding_BigEndianBytes;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AutoValue_Type_Raw;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

@BetaApi
public abstract class Type {
    private Type() {
    }

    abstract com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type toProto();

    static Type fromProto(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type source) {
        switch (source.getKindCase()) {
            case INT64_TYPE: {
                return Int64.fromProto(source.getInt64Type());
            }
            case BYTES_TYPE: {
                return Bytes.fromProto(source.getBytesType());
            }
            case AGGREGATE_TYPE: {
                return Aggregate.fromProto(source.getAggregateType());
            }
            case KIND_NOT_SET: {
                return Raw.create();
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Raw raw() {
        return Raw.create();
    }

    public static Bytes rawBytes() {
        return Bytes.create(Bytes.Encoding.raw());
    }

    public static Bytes bytes(Bytes.Encoding encoding) {
        return Bytes.create(encoding);
    }

    public static Int64 bigEndianInt64() {
        return Int64.create(Int64.Encoding.BigEndianBytes.create(Bytes.rawBytes()));
    }

    public static Int64 int64(Int64.Encoding encoding) {
        return Int64.create(encoding);
    }

    public static Aggregate int64Sum() {
        return Type.sum(Type.bigEndianInt64());
    }

    public static Aggregate sum(SumAggregateInput inputType) {
        return Aggregate.create(inputType, Aggregate.Aggregator.Sum.create());
    }

    @AutoValue
    public static abstract class Int64
    extends SumAggregateInput {
        public static Int64 create(Encoding encoding) {
            return new AutoValue_Type_Int64(encoding);
        }

        @Nonnull
        public abstract Encoding getEncoding();

        @Override
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type toProto() {
            Type.Builder builder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type.newBuilder();
            builder.getInt64TypeBuilder().setEncoding(this.getEncoding().toProto());
            return builder.build();
        }

        static Int64 fromProto(Type.Int64 source) {
            return Int64.create(Encoding.fromProto(source.getEncoding()));
        }

        public static abstract class Encoding {
            abstract Type.Int64.Encoding toProto();

            static Encoding fromProto(Type.Int64.Encoding source) {
                switch (source.getEncodingCase()) {
                    case BIG_ENDIAN_BYTES: {
                        return BigEndianBytes.create(Bytes.fromProto(source.getBigEndianBytes().getBytesType()));
                    }
                    case ENCODING_NOT_SET: {
                        return BigEndianBytes.create(Bytes.rawBytes());
                    }
                }
                throw new UnsupportedOperationException();
            }

            @AutoValue
            public static abstract class BigEndianBytes
            extends Encoding {
                public static BigEndianBytes create(Bytes bytes) {
                    return new AutoValue_Type_Int64_Encoding_BigEndianBytes(bytes);
                }

                @Nonnull
                public abstract Bytes getBytes();

                @Override
                Type.Int64.Encoding toProto() {
                    Type.Int64.Encoding.Builder builder = Type.Int64.Encoding.newBuilder();
                    builder.getBigEndianBytesBuilder().setBytesType(this.getBytes().toProto().getBytesType());
                    return builder.build();
                }
            }
        }
    }

    @AutoValue
    public static abstract class Bytes
    extends Type {
        public static Bytes create(Encoding encoding) {
            return new AutoValue_Type_Bytes(encoding);
        }

        @Nonnull
        public abstract Encoding getEncoding();

        @Override
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type toProto() {
            Type.Builder builder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type.newBuilder();
            builder.getBytesTypeBuilder().setEncoding(this.getEncoding().toProto());
            return builder.build();
        }

        static Bytes fromProto(Type.Bytes source) {
            return Bytes.create(Encoding.fromProto(source.getEncoding()));
        }

        public static abstract class Encoding {
            abstract Type.Bytes.Encoding toProto();

            static Encoding fromProto(Type.Bytes.Encoding source) {
                switch (source.getEncodingCase()) {
                    case RAW: 
                    case ENCODING_NOT_SET: {
                        return Raw.create();
                    }
                }
                throw new UnsupportedOperationException();
            }

            public static Encoding raw() {
                return Raw.create();
            }

            @AutoValue
            public static abstract class Raw
            extends Encoding {
                private static final Type.Bytes.Encoding PROTO_INSTANCE = Type.Bytes.Encoding.newBuilder().setRaw(Type.Bytes.Encoding.Raw.getDefaultInstance()).build();

                public static Raw create() {
                    return new AutoValue_Type_Bytes_Encoding_Raw();
                }

                @Override
                Type.Bytes.Encoding toProto() {
                    return PROTO_INSTANCE;
                }
            }
        }
    }

    @AutoValue
    public static abstract class Aggregate
    extends Type {
        public static Aggregate create(Type inputType, Aggregator aggregator) {
            return new AutoValue_Type_Aggregate(inputType, aggregator);
        }

        @Nonnull
        public abstract Type getInputType();

        @Nonnull
        public abstract Aggregator getAggregator();

        @Override
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type toProto() {
            Type.Builder typeBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type.newBuilder();
            Type.Aggregate.Builder aggregateBuilder = typeBuilder.getAggregateTypeBuilder();
            this.getAggregator().buildTo(aggregateBuilder);
            aggregateBuilder.setInputType(this.getInputType().toProto());
            return typeBuilder.build();
        }

        static Aggregate fromProto(Type.Aggregate source) {
            Type inputType = Type.fromProto(source.getInputType());
            Aggregator.Sum aggregator = null;
            switch (source.getAggregatorCase()) {
                case SUM: {
                    aggregator = Aggregator.Sum.create();
                    break;
                }
                case AGGREGATOR_NOT_SET: {
                    throw new UnsupportedOperationException();
                }
            }
            return Aggregate.create(inputType, Preconditions.checkNotNull(aggregator));
        }

        public static abstract class Aggregator {
            abstract void buildTo(Type.Aggregate.Builder var1);

            @AutoValue
            public static abstract class Sum
            extends Aggregator {
                public static Sum create() {
                    return new AutoValue_Type_Aggregate_Aggregator_Sum();
                }

                @Override
                void buildTo(Type.Aggregate.Builder builder) {
                    builder.setSum(Type.Aggregate.Sum.getDefaultInstance());
                }
            }
        }
    }

    @AutoValue
    public static abstract class Raw
    extends Type {
        public static Raw create() {
            return new AutoValue_Type_Raw();
        }

        @Override
        com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type toProto() {
            return com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Type.getDefaultInstance();
        }
    }

    public static abstract class SumAggregateInput
    extends Type {
    }
}

