/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.AuthorizedView;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models.SubsetView;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nonnull;

public final class UpdateAuthorizedViewRequest {
    private final UpdateAuthorizedViewRequest.Builder requestBuilder;
    private final String tableId;
    private final String authorizedViewId;

    public static UpdateAuthorizedViewRequest of(@Nonnull AuthorizedView authorizedView) {
        return new UpdateAuthorizedViewRequest(authorizedView.getTableId(), authorizedView.getId(), com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest.newBuilder().setAuthorizedView(authorizedView.toProto()));
    }

    public static UpdateAuthorizedViewRequest of(@Nonnull String tableId, @Nonnull String authorizedViewId) {
        return new UpdateAuthorizedViewRequest(tableId, authorizedViewId, com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest.newBuilder());
    }

    private UpdateAuthorizedViewRequest(@Nonnull String tableId, @Nonnull String authorizedViewId, @Nonnull UpdateAuthorizedViewRequest.Builder requestBuilder) {
        Preconditions.checkNotNull(tableId, "tableId must be set");
        Preconditions.checkNotNull(authorizedViewId, "authorizedViewId must be set");
        Preconditions.checkNotNull(requestBuilder, "proto builder must be set");
        this.tableId = tableId;
        this.authorizedViewId = authorizedViewId;
        this.requestBuilder = requestBuilder;
    }

    public UpdateAuthorizedViewRequest setDeletionProtection(boolean deletionProtection) {
        this.requestBuilder.getAuthorizedViewBuilder().setDeletionProtection(deletionProtection);
        this.updateFieldMask(4);
        return this;
    }

    public UpdateAuthorizedViewRequest setAuthorizedViewType(@Nonnull AuthorizedView.AuthorizedViewType authorizedViewType) {
        Preconditions.checkNotNull(authorizedViewType, "authorizedViewType must be set");
        if (!(authorizedViewType instanceof SubsetView)) {
            throw new IllegalArgumentException("Unknown authorizedViewType: " + authorizedViewType);
        }
        this.requestBuilder.getAuthorizedViewBuilder().setSubsetView(((SubsetView)authorizedViewType).toProto());
        this.updateFieldMask(2);
        return this;
    }

    public UpdateAuthorizedViewRequest setIgnoreWarnings(boolean value) {
        this.requestBuilder.setIgnoreWarnings(value);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(com.google.bigtable.repackaged.com.google.bigtable.admin.v2.AuthorizedView.class, fieldNumber);
        this.requestBuilder.setUpdateMask(FieldMaskUtil.union(this.requestBuilder.getUpdateMask(), newMask, new FieldMask[0]));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateAuthorizedViewRequest that = (UpdateAuthorizedViewRequest)o;
        return Objects.equal(this.requestBuilder.build(), that.requestBuilder.build()) && Objects.equal(this.tableId, that.tableId) && Objects.equal(this.authorizedViewId, that.authorizedViewId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.build(), this.tableId, this.authorizedViewId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateAuthorizedViewRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        this.requestBuilder.getAuthorizedViewBuilder().setName(NameUtil.formatAuthorizedViewName(projectId, instanceId, this.tableId, this.authorizedViewId));
        return this.requestBuilder.build();
    }
}

