/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcStatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryingFuture;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedAttemptSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiException;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.MutateRowsException;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsAttemptResult;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying.NonCancellableFuture;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.common.primitives.Ints;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MutateRowsAttemptCallable
implements Callable<MutateRowsAttemptResult> {
    private static final StatusCode LOCAL_UNKNOWN_STATUS = new StatusCode(){

        @Override
        public StatusCode.Code getCode() {
            return StatusCode.Code.UNKNOWN;
        }

        @Override
        public Object getTransportCode() {
            return null;
        }
    };
    @Nonnull
    private final UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable;
    @Nonnull
    private final ApiCallContext callContext;
    @Nonnull
    private MutateRowsRequest currentRequest;
    @Nullable
    private List<Integer> originalIndexes;
    @Nonnull
    private final Set<StatusCode.Code> retryableCodes;
    @Nullable
    private final List<MutateRowsException.FailedMutation> permanentFailures;
    @Nonnull
    private final RetryAlgorithm<MutateRowsRequest> retryAlgorithm;
    @Nonnull
    private TimedAttemptSettings attemptSettings;
    private RetryingFuture<MutateRowsAttemptResult> externalFuture;
    private final ApiFunction<List<MutateRowsResponse>, MutateRowsAttemptResult> attemptSuccessfulCallback = new ApiFunction<List<MutateRowsResponse>, MutateRowsAttemptResult>(){

        @Override
        public MutateRowsAttemptResult apply(List<MutateRowsResponse> responses) {
            return MutateRowsAttemptCallable.this.handleAttemptSuccess(responses);
        }
    };
    private final ApiFunction<Throwable, List<MutateRowsResponse>> attemptFailedCallback = new ApiFunction<Throwable, List<MutateRowsResponse>>(){

        @Override
        public List<MutateRowsResponse> apply(Throwable throwable) {
            MutateRowsAttemptCallable.this.handleAttemptError(throwable);
            return null;
        }
    };

    MutateRowsAttemptCallable(@Nonnull UnaryCallable<MutateRowsRequest, List<MutateRowsResponse>> innerCallable, @Nonnull MutateRowsRequest originalRequest, @Nonnull ApiCallContext callContext, @Nonnull Set<StatusCode.Code> retryableCodes, @Nonnull RetryAlgorithm<MutateRowsRequest> retryAlgorithm) {
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "innerCallable");
        this.currentRequest = Preconditions.checkNotNull(originalRequest, "currentRequest");
        this.callContext = Preconditions.checkNotNull(callContext, "callContext");
        this.retryableCodes = Preconditions.checkNotNull(retryableCodes, "retryableCodes");
        this.retryAlgorithm = retryAlgorithm;
        this.attemptSettings = retryAlgorithm.createFirstAttempt();
        this.permanentFailures = Lists.newArrayList();
    }

    public void setExternalFuture(RetryingFuture<MutateRowsAttemptResult> externalFuture) {
        this.externalFuture = externalFuture;
    }

    @Override
    public MutateRowsAttemptResult call() {
        try {
            Preconditions.checkNotNull(this.externalFuture, "External future must be set before starting an attempt");
            this.callContext.getTracer().attemptStarted(this.currentRequest, this.externalFuture.getAttemptSettings().getOverallAttemptCount());
            Preconditions.checkState(this.currentRequest.getEntriesCount() > 0, "Request doesn't have any mutations to send");
            ApiCallContext currentCallContext = this.callContext;
            if (currentCallContext.getTimeout() == null && !this.externalFuture.getAttemptSettings().getRpcTimeout().isZero()) {
                currentCallContext = currentCallContext.withTimeout(this.externalFuture.getAttemptSettings().getRpcTimeout());
            }
            this.externalFuture.setAttemptFuture(new NonCancellableFuture());
            if (this.externalFuture.isDone()) {
                return null;
            }
            ApiFuture<List<MutateRowsResponse>> innerFuture = this.innerCallable.futureCall(this.currentRequest, currentCallContext);
            ApiFuture<List<MutateRowsResponse>> catching = ApiFutures.catching(innerFuture, Throwable.class, this.attemptFailedCallback, MoreExecutors.directExecutor());
            ApiFuture<MutateRowsAttemptResult> transformed = ApiFutures.transform(catching, this.attemptSuccessfulCallback, MoreExecutors.directExecutor());
            this.externalFuture.setAttemptFuture(transformed);
        }
        catch (Throwable e) {
            this.externalFuture.setAttemptFuture(ApiFutures.immediateFailedFuture(e));
        }
        return null;
    }

    private void handleAttemptError(Throwable rpcError) {
        ApiException entryError = MutateRowsAttemptCallable.createSyntheticErrorForRpcFailure(rpcError);
        ImmutableList.Builder allFailures = ImmutableList.builder();
        MutateRowsRequest lastRequest = this.currentRequest;
        allFailures.addAll(this.permanentFailures);
        MutateRowsRequest.Builder builder = lastRequest.toBuilder().clearEntries();
        ArrayList<Integer> newOriginalIndexes = Lists.newArrayList();
        this.attemptSettings = this.retryAlgorithm.createNextAttempt(null, entryError, null, this.attemptSettings);
        for (int i = 0; i < this.currentRequest.getEntriesCount(); ++i) {
            int origIndex = this.getOriginalIndex(i);
            MutateRowsException.FailedMutation failedMutation = MutateRowsException.FailedMutation.create(origIndex, entryError);
            allFailures.add(failedMutation);
            if (!this.retryAlgorithm.shouldRetry(null, failedMutation.getError(), null, this.attemptSettings)) {
                this.permanentFailures.add(failedMutation);
                continue;
            }
            newOriginalIndexes.add(origIndex);
            builder.addEntries(lastRequest.getEntries(i));
        }
        this.currentRequest = builder.build();
        this.originalIndexes = newOriginalIndexes;
        throw MutateRowsException.create(rpcError, entryError.getStatusCode(), (List<MutateRowsException.FailedMutation>)((Object)allFailures.build()), builder.getEntriesCount() > 0);
    }

    private MutateRowsAttemptResult handleAttemptSuccess(List<MutateRowsResponse> responses) {
        ArrayList<MutateRowsException.FailedMutation> allFailures = Lists.newArrayList(this.permanentFailures);
        MutateRowsRequest lastRequest = this.currentRequest;
        MutateRowsRequest.Builder builder = lastRequest.toBuilder().clearEntries();
        ArrayList<Integer> newOriginalIndexes = Lists.newArrayList();
        boolean[] seenIndices = new boolean[this.currentRequest.getEntriesCount()];
        for (MutateRowsResponse response : responses) {
            for (MutateRowsResponse.Entry entry : response.getEntriesList()) {
                seenIndices[Ints.checkedCast((long)entry.getIndex())] = true;
                if (entry.getStatus().getCode() == 0) continue;
                int origIndex = this.getOriginalIndex((int)entry.getIndex());
                MutateRowsException.FailedMutation failedMutation = MutateRowsException.FailedMutation.create(origIndex, this.createEntryError(entry.getStatus()));
                allFailures.add(failedMutation);
                if (!failedMutation.getError().isRetryable()) {
                    this.permanentFailures.add(failedMutation);
                    continue;
                }
                newOriginalIndexes.add(origIndex);
                builder.addEntries(lastRequest.getEntries((int)entry.getIndex()));
            }
        }
        for (int i = 0; i < seenIndices.length; ++i) {
            if (seenIndices[i]) continue;
            int origIndex = this.getOriginalIndex(i);
            MutateRowsException.FailedMutation failedMutation = MutateRowsException.FailedMutation.create(origIndex, ApiExceptionFactory.createException("Missing entry response for entry " + origIndex, null, GrpcStatusCode.of(Status.Code.INTERNAL), false));
            allFailures.add(failedMutation);
            this.permanentFailures.add(failedMutation);
        }
        this.currentRequest = builder.build();
        this.originalIndexes = newOriginalIndexes;
        if (!allFailures.isEmpty()) {
            boolean isRetryable = builder.getEntriesCount() > 0;
            return MutateRowsAttemptResult.create(allFailures, isRetryable);
        }
        return MutateRowsAttemptResult.success();
    }

    private int getOriginalIndex(int index) {
        return this.originalIndexes != null ? this.originalIndexes.get(index) : index;
    }

    private ApiException createEntryError(com.google.bigtable.repackaged.com.google.rpc.Status protoStatus) {
        Status grpcStatus = Status.fromCodeValue(protoStatus.getCode()).withDescription(protoStatus.getMessage());
        GrpcStatusCode gaxStatusCode = GrpcStatusCode.of(grpcStatus.getCode());
        return ApiExceptionFactory.createException(grpcStatus.asRuntimeException(), gaxStatusCode, this.retryableCodes.contains((Object)gaxStatusCode.getCode()));
    }

    private static ApiException createSyntheticErrorForRpcFailure(Throwable overallRequestError) {
        if (overallRequestError instanceof ApiException) {
            ApiException requestApiException = (ApiException)overallRequestError;
            return ApiExceptionFactory.createException(overallRequestError, requestApiException.getStatusCode(), requestApiException.isRetryable(), requestApiException.getErrorDetails());
        }
        return ApiExceptionFactory.createException("Didn't receive a result for this mutation entry", overallRequestError, LOCAL_UNKNOWN_STATUS, false);
    }
}

