/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection;

import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.DetectedPlatform;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPMetadataConfig;
import com.google.bigtable.repackaged.com.google.cloud.opentelemetry.detection.GCPPlatformDetector;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class GoogleComputeEngine
implements DetectedPlatform {
    private final GCPMetadataConfig metadataConfig;
    private final Map<String, String> availableAttributes;

    GoogleComputeEngine(GCPMetadataConfig metadataConfig) {
        this.metadataConfig = metadataConfig;
        this.availableAttributes = this.prepareAttributes();
    }

    private Map<String, String> prepareAttributes() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("availability_zone", this.metadataConfig.getZone());
        map.put("cloud_region", this.metadataConfig.getRegionFromZone());
        map.put("instance_id", this.metadataConfig.getInstanceId());
        map.put("instance_name", this.metadataConfig.getInstanceName());
        map.put("instance_hostname", this.metadataConfig.getInstanceHostName());
        map.put("machine_type", this.metadataConfig.getMachineType());
        return Collections.unmodifiableMap(map);
    }

    @Override
    public GCPPlatformDetector.SupportedPlatform getSupportedPlatform() {
        return GCPPlatformDetector.SupportedPlatform.GOOGLE_COMPUTE_ENGINE;
    }

    @Override
    public String getProjectId() {
        return this.metadataConfig.getProjectId();
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.availableAttributes;
    }
}

