/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.lmax.disruptor;

import com.google.bigtable.repackaged.com.lmax.disruptor.InsufficientCapacityException;
import com.google.bigtable.repackaged.com.lmax.disruptor.SingleProducerSequencerFields;
import com.google.bigtable.repackaged.com.lmax.disruptor.WaitStrategy;
import com.google.bigtable.repackaged.com.lmax.disruptor.util.Util;
import java.util.concurrent.locks.LockSupport;

public final class SingleProducerSequencer
extends SingleProducerSequencerFields {
    protected long p1;
    protected long p2;
    protected long p3;
    protected long p4;
    protected long p5;
    protected long p6;
    protected long p7;

    public SingleProducerSequencer(int bufferSize, WaitStrategy waitStrategy) {
        super(bufferSize, waitStrategy);
    }

    @Override
    public boolean hasAvailableCapacity(int requiredCapacity) {
        return this.hasAvailableCapacity(requiredCapacity, false);
    }

    private boolean hasAvailableCapacity(int requiredCapacity, boolean doStore) {
        long nextValue = this.nextValue;
        long wrapPoint = nextValue + (long)requiredCapacity - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            if (doStore) {
                this.cursor.setVolatile(nextValue);
            }
            this.cachedValue = minSequence = Util.getMinimumSequence(this.gatingSequences, nextValue);
            if (wrapPoint > minSequence) {
                return false;
            }
        }
        return true;
    }

    @Override
    public long next() {
        return this.next(1);
    }

    @Override
    public long next(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        long nextValue = this.nextValue;
        long nextSequence = nextValue + (long)n;
        long wrapPoint = nextSequence - (long)this.bufferSize;
        long cachedGatingSequence = this.cachedValue;
        if (wrapPoint > cachedGatingSequence || cachedGatingSequence > nextValue) {
            long minSequence;
            this.cursor.setVolatile(nextValue);
            while (wrapPoint > (minSequence = Util.getMinimumSequence(this.gatingSequences, nextValue))) {
                LockSupport.parkNanos(1L);
            }
            this.cachedValue = minSequence;
        }
        this.nextValue = nextSequence;
        return nextSequence;
    }

    @Override
    public long tryNext() throws InsufficientCapacityException {
        return this.tryNext(1);
    }

    @Override
    public long tryNext(int n) throws InsufficientCapacityException {
        if (n < 1) {
            throw new IllegalArgumentException("n must be > 0");
        }
        if (!this.hasAvailableCapacity(n, true)) {
            throw InsufficientCapacityException.INSTANCE;
        }
        long nextSequence = this.nextValue += (long)n;
        return nextSequence;
    }

    @Override
    public long remainingCapacity() {
        long nextValue = this.nextValue;
        long consumed = Util.getMinimumSequence(this.gatingSequences, nextValue);
        long produced = nextValue;
        return (long)this.getBufferSize() - (produced - consumed);
    }

    @Override
    public void claim(long sequence) {
        this.nextValue = sequence;
    }

    @Override
    public void publish(long sequence) {
        this.cursor.set(sequence);
        this.waitStrategy.signalAllWhenBlocking();
    }

    @Override
    public void publish(long lo, long hi) {
        this.publish(hi);
    }

    @Override
    public boolean isAvailable(long sequence) {
        return sequence <= this.cursor.get();
    }

    @Override
    public long getHighestPublishedSequence(long lowerBound, long availableSequence) {
        return availableSequence;
    }
}

