/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds.internal.security;

import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.xds.internal.security.Closeable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckReturnValue;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class ReferenceCountingMap<K, V extends Closeable> {
    private final Map<K, Instance<V>> instances = new HashMap<K, Instance<V>>();
    private final ValueFactory<K, V> valueFactory;

    public ReferenceCountingMap(ValueFactory<K, V> valueFactory) {
        Preconditions.checkNotNull(valueFactory, "valueFactory");
        this.valueFactory = valueFactory;
    }

    @CheckReturnValue
    public V get(K key) {
        Preconditions.checkNotNull(key, "key");
        return this.getInternal(key);
    }

    public V release(K key, V value) {
        Preconditions.checkNotNull(key, "key");
        Preconditions.checkNotNull(value, "value");
        return this.releaseInternal(key, value);
    }

    private synchronized V getInternal(K key) {
        Instance<V> instance = this.instances.get(key);
        if (instance == null) {
            instance = new Instance<V>(this.valueFactory.create(key));
            this.instances.put(key, instance);
            return instance.value;
        }
        return instance.acquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized V releaseInternal(K key, V value) {
        Instance<V> cached = this.instances.get(key);
        Preconditions.checkArgument(cached != null, "No cached instance found for %s", key);
        Preconditions.checkArgument(value == cached.value, "Releasing the wrong instance");
        if (cached.release()) {
            try {
                cached.value.close();
            }
            finally {
                this.instances.remove(key);
            }
        }
        return null;
    }

    private static final class Instance<V extends Closeable> {
        final V value;
        private int refCount;

        V acquire() {
            ++this.refCount;
            return this.value;
        }

        boolean release() {
            Preconditions.checkState(this.refCount > 0, "refCount has to be > 0");
            return --this.refCount == 0;
        }

        Instance(V value) {
            this.value = value;
            this.refCount = 1;
        }
    }

    public static interface ValueFactory<K, V extends Closeable> {
        public V create(K var1);
    }
}

