/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data.ImmutableEventData;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface EventData {
    public static EventData create(long epochNanos, String name, Attributes attributes) {
        return ImmutableEventData.create(epochNanos, name, attributes);
    }

    public static EventData create(long epochNanos, String name, Attributes attributes, int totalAttributeCount) {
        return ImmutableEventData.create(epochNanos, name, attributes, totalAttributeCount);
    }

    public String getName();

    public Attributes getAttributes();

    public long getEpochNanos();

    public int getTotalAttributeCount();

    default public int getDroppedAttributesCount() {
        return this.getTotalAttributeCount() - this.getAttributes().size();
    }
}

