/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data;

import com.google.bigtable.repackaged.io.opentelemetry.api.common.Attributes;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.SpanContext;
import com.google.bigtable.repackaged.io.opentelemetry.api.trace.SpanKind;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.internal.InstrumentationScopeUtil;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.resources.Resource;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data.EventData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data.LinkData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data.StatusData;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public String getName();

    public SpanKind getKind();

    public SpanContext getSpanContext();

    default public String getTraceId() {
        return this.getSpanContext().getTraceId();
    }

    default public String getSpanId() {
        return this.getSpanContext().getSpanId();
    }

    public SpanContext getParentSpanContext();

    default public String getParentSpanId() {
        return this.getParentSpanContext().getSpanId();
    }

    public StatusData getStatus();

    public long getStartEpochNanos();

    public Attributes getAttributes();

    public List<EventData> getEvents();

    public List<LinkData> getLinks();

    public long getEndEpochNanos();

    public boolean hasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();

    @Deprecated
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    default public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return InstrumentationScopeUtil.toInstrumentationScopeInfo(this.getInstrumentationLibraryInfo());
    }

    public Resource getResource();
}

