/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.export;

import com.google.bigtable.repackaged.io.opentelemetry.context.Context;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.common.CompletableResultCode;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.ReadWriteSpan;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.ReadableSpan;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.SpanProcessor;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.data.SpanData;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.export.SimpleSpanProcessorBuilder;
import com.google.bigtable.repackaged.io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SimpleSpanProcessor
implements SpanProcessor {
    private static final Logger logger = Logger.getLogger(SimpleSpanProcessor.class.getName());
    private final SpanExporter spanExporter;
    private final boolean exportUnsampledSpans;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static SpanProcessor create(SpanExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return SimpleSpanProcessor.builder(exporter).build();
    }

    public static SimpleSpanProcessorBuilder builder(SpanExporter exporter) {
        Objects.requireNonNull(exporter, "exporter");
        return new SimpleSpanProcessorBuilder(exporter);
    }

    SimpleSpanProcessor(SpanExporter spanExporter, boolean exportUnsampledSpans) {
        this.spanExporter = Objects.requireNonNull(spanExporter, "spanExporter");
        this.exportUnsampledSpans = exportUnsampledSpans;
    }

    @Override
    public void onStart(Context parentContext, ReadWriteSpan span) {
    }

    @Override
    public boolean isStartRequired() {
        return false;
    }

    @Override
    public void onEnd(ReadableSpan span) {
        if (span != null && (this.exportUnsampledSpans || span.getSpanContext().isSampled())) {
            try {
                List<SpanData> spans = Collections.singletonList(span.toSpanData());
                CompletableResultCode result = this.spanExporter.export(spans);
                this.pendingExports.add(result);
                result.whenComplete(() -> {
                    this.pendingExports.remove(result);
                    if (!result.isSuccess()) {
                        logger.log(Level.FINE, "Exporter failed");
                    }
                });
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Exporter threw an Exception", e);
            }
        }
    }

    @Override
    public boolean isEndRequired() {
        return true;
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> {
            CompletableResultCode shutdownResult = this.spanExporter.shutdown();
            shutdownResult.whenComplete(() -> {
                if (!flushResult.isSuccess() || !shutdownResult.isSuccess()) {
                    result.fail();
                } else {
                    result.succeed();
                }
            });
        });
        return result;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public SpanExporter getSpanExporter() {
        return this.spanExporter;
    }

    public String toString() {
        return "SimpleSpanProcessor{spanExporter=" + this.spanExporter + ", exportUnsampledSpans=" + this.exportUnsampledSpans + '}';
    }
}

