/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.cloud.bigtable.hbase.wrappers.veneer.metrics.MetricsApiTracerAdapter;
import com.google.cloud.bigtable.metrics.RpcMetrics;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class MetricsApiTracerAdapterFactory
implements ApiTracerFactory {
    private final Map<String, RpcMetrics> methodMetrics = new HashMap<String, RpcMetrics>();

    @Override
    public ApiTracer newTracer(ApiTracer parent, SpanName spanName, ApiTracerFactory.OperationType operationType) {
        RpcMetrics rpcMetrics = this.getRpcMetrics(spanName);
        return new MetricsApiTracerAdapter(rpcMetrics, spanName.getMethodName(), operationType);
    }

    @VisibleForTesting
    public Map<String, RpcMetrics> getMethodMetrics() {
        return this.methodMetrics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RpcMetrics getRpcMetrics(SpanName spanName) {
        String key = spanName.getMethodName();
        RpcMetrics rpcMetrics = this.methodMetrics.get(key);
        if (rpcMetrics != null) {
            return rpcMetrics;
        }
        MetricsApiTracerAdapterFactory metricsApiTracerAdapterFactory = this;
        synchronized (metricsApiTracerAdapterFactory) {
            rpcMetrics = this.methodMetrics.get(key);
            if (rpcMetrics != null) {
                return rpcMetrics;
            }
            rpcMetrics = RpcMetrics.createRpcMetrics(key);
            this.methodMetrics.put(key, rpcMetrics);
            return rpcMetrics;
        }
    }
}

