/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase1_x;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.Throwables;
import com.google.bigtable.repackaged.net.bytebuddy.ByteBuddy;
import com.google.bigtable.repackaged.net.bytebuddy.implementation.InvocationHandlerAdapter;
import com.google.bigtable.repackaged.net.bytebuddy.matcher.ElementMatchers;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import org.apache.hadoop.hbase.ClusterStatus;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableAdmin;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.CommonConnection;

@InternalApi(value="For internal usage only")
public abstract class BigtableAdmin
extends AbstractBigtableAdmin {
    private static Class<? extends BigtableAdmin> adminClass = null;

    public BigtableAdmin(CommonConnection connection) throws IOException {
        super(connection);
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        this.disableTable(tableName);
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        this.enableTable(tableName);
    }

    public ClusterStatus getClusterStatus() throws IOException {
        return new ClusterStatus(){

            public Collection<ServerName> getServers() {
                return Collections.emptyList();
            }
        };
    }

    private static synchronized Class<? extends BigtableAdmin> getSubclass() {
        if (adminClass == null) {
            adminClass = new ByteBuddy().subclass(BigtableAdmin.class).method(ElementMatchers.isAbstract()).intercept(InvocationHandlerAdapter.of(new AbstractBigtableAdmin.UnsupportedOperationsHandler())).make().load(BigtableAdmin.class.getClassLoader()).getLoaded();
        }
        return adminClass;
    }

    public static Admin createInstance(CommonConnection connection) throws IOException {
        try {
            return BigtableAdmin.getSubclass().getDeclaredConstructor(CommonConnection.class).newInstance(connection);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfInstanceOf(e.getTargetException(), IOException.class);
            Throwables.throwIfInstanceOf(e.getTargetException(), RuntimeException.class);
            throw new IOException(e);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

