/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.bigtable.hbase.BigtableBufferedMutator;
import com.google.cloud.bigtable.hbase.BigtableHBaseVersion;
import com.google.cloud.bigtable.hbase.BigtableRegionLocator;
import com.google.cloud.bigtable.hbase.adapters.Adapters;
import com.google.cloud.bigtable.hbase.adapters.HBaseRequestAdapter;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase.util.Logger;
import com.google.cloud.bigtable.hbase.wrappers.BigtableApi;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.BufferedMutator;
import org.apache.hadoop.hbase.client.BufferedMutatorParams;
import org.apache.hadoop.hbase.client.CommonConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;

@InternalApi(value="For internal usage only")
public abstract class AbstractBigtableConnection
implements Connection,
CommonConnection,
Closeable {
    private final Logger LOG = new Logger(this.getClass());
    protected final Set<RegionLocator> locatorCache = new CopyOnWriteArraySet<RegionLocator>();
    private volatile boolean closed = false;
    private volatile boolean aborted;
    private volatile ExecutorService batchPool = null;
    private ExecutorService bufferedMutatorExecutorService;
    private final BigtableApi bigtableApi;
    private volatile boolean cleanupPool = false;
    private final BigtableHBaseSettings settings;
    private Set<TableName> disabledTables = new HashSet<TableName>();
    private HBaseRequestAdapter.MutationAdapters mutationAdapters;
    private static final AtomicBoolean firstConnection;

    public AbstractBigtableConnection(Configuration conf) throws IOException {
        this(conf, false, null, null);
    }

    protected AbstractBigtableConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        if (managed) {
            if (conf.getBoolean("google.bigtable.managed.connection.warning", false)) {
                this.LOG.warn("Bigtable does not support managed connections. This connection will end up leaking.", new Object[0]);
            } else {
                throw new IllegalArgumentException("Bigtable does not support managed connections.");
            }
        }
        try {
            this.settings = BigtableHBaseSettings.create(conf);
        }
        catch (IOException ioe) {
            this.LOG.error("Error loading BigtableOptions from Configuration.", ioe, new Object[0]);
            throw ioe;
        }
        this.logStartup(this.LOG, conf, this.settings);
        this.batchPool = pool;
        this.closed = false;
        this.bigtableApi = BigtableApi.create(this.settings);
    }

    private void logStartup(Logger logger, Configuration userConfig, BigtableHBaseSettings settings) {
        if (firstConnection.compareAndSet(false, true)) {
            String jarPath;
            try {
                jarPath = this.getClass().getProtectionDomain().getCodeSource().getLocation().toString();
            }
            catch (RuntimeException e) {
                jarPath = "<unknown>";
            }
            logger.info("Using bigtable-hbase client from jar %s. Version: %s", jarPath, BigtableHBaseVersion.getVersion());
        }
        MoreObjects.ToStringHelper configHelper = MoreObjects.toStringHelper("BigtableConfiguration");
        for (Map.Entry entry : userConfig) {
            if (!((String)entry.getKey()).startsWith("google.bigtable")) continue;
            configHelper.add((String)entry.getKey(), entry.getValue());
        }
        logger.info("User Configuration:\n" + ToStringHelperPrettyPrinter.print(configHelper.toString()), new Object[0]);
        settings.toDebugStrings().forEach((k, v) -> logger.info("Effective settings: BigtableHBaseVeneerSettings\n" + ToStringHelperPrettyPrinter.print(v), new Object[0]));
    }

    @Override
    public Configuration getConfiguration() {
        return this.settings.getConfiguration();
    }

    public Table getTable(TableName tableName) throws IOException {
        return this.getTable(tableName, this.batchPool);
    }

    public BufferedMutator getBufferedMutator(BufferedMutatorParams params) throws IOException {
        TableName tableName = params.getTableName();
        if (tableName == null) {
            throw new IllegalArgumentException("TableName cannot be null.");
        }
        HBaseRequestAdapter adapter = this.createAdapter(tableName);
        BufferedMutator.ExceptionListener listener = params.getListener();
        return new BigtableBufferedMutator(this.bigtableApi, this.settings, adapter, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HBaseRequestAdapter createAdapter(TableName tableName) {
        if (this.mutationAdapters == null) {
            AbstractBigtableConnection abstractBigtableConnection = this;
            synchronized (abstractBigtableConnection) {
                if (this.mutationAdapters == null) {
                    this.mutationAdapters = new HBaseRequestAdapter.MutationAdapters(this.settings);
                }
            }
        }
        return new HBaseRequestAdapter(this.settings, tableName, this.mutationAdapters);
    }

    public BufferedMutator getBufferedMutator(TableName tableName) throws IOException {
        return this.getBufferedMutator(new BufferedMutatorParams(tableName));
    }

    @Deprecated
    public Table getTable(String tableName) throws IOException {
        return this.getTable(TableName.valueOf((String)tableName));
    }

    public RegionLocator getRegionLocator(TableName tableName) throws IOException {
        RegionLocator locator = this.getCachedLocator(tableName);
        if (locator == null) {
            locator = new BigtableRegionLocator(tableName, this.settings, this.bigtableApi.getDataClient()){

                @Override
                public SampledRowKeysAdapter getSampledRowKeysAdapter(TableName tableName, ServerName serverName) {
                    return AbstractBigtableConnection.this.createSampledRowKeysAdapter(tableName, serverName);
                }
            };
            this.locatorCache.add(locator);
        }
        return locator;
    }

    private RegionLocator getCachedLocator(TableName tableName) {
        for (RegionLocator locator : this.locatorCache) {
            if (!locator.getName().equals((Object)tableName)) continue;
            return locator;
        }
        return null;
    }

    protected abstract SampledRowKeysAdapter createSampledRowKeysAdapter(TableName var1, ServerName var2);

    public void abort(String msg, Throwable t) {
        if (t != null) {
            this.LOG.fatal(msg, t, new Object[0]);
        } else {
            this.LOG.fatal(msg, new Object[0]);
        }
        this.aborted = true;
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close the connection", e);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.bigtableApi.close();
            this.shutdownBatchPool();
            if (this.bufferedMutatorExecutorService != null) {
                this.bufferedMutatorExecutorService.shutdown();
                this.bufferedMutatorExecutorService = null;
            }
            this.closed = true;
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper(AbstractBigtableConnection.class).add("project", this.settings.getProjectId()).add("instance", this.settings.getInstanceId()).add("dataHost", this.settings.getDataHost()).add("tableAdminHost", this.settings.getAdminHost()).toString();
    }

    private void shutdownBatchPool() {
        if (this.cleanupPool && this.batchPool != null && !this.batchPool.isShutdown()) {
            this.batchPool.shutdown();
            try {
                if (!this.batchPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                    this.batchPool.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.batchPool.shutdownNow();
            }
        }
    }

    public abstract Admin getAdmin() throws IOException;

    @Override
    public BigtableHBaseSettings getBigtableSettings() {
        return this.settings;
    }

    @Override
    public Set<TableName> getDisabledTables() {
        return this.disabledTables;
    }

    @Override
    public BigtableApi getBigtableApi() {
        return this.bigtableApi;
    }

    static {
        Adapters.class.getName();
        firstConnection = new AtomicBoolean();
    }

    private static class ToStringHelperPrettyPrinter {
        private ToStringHelperPrettyPrinter() {
        }

        private static void appendIndent(StringBuilder sb, int level) {
            for (int i = 0; i < level; ++i) {
                sb.append("  ");
            }
        }

        private static String print(String str) {
            StringBuilder sb = new StringBuilder();
            int indent = 0;
            State state = State.DEFAULT;
            block9: for (char c : str.toCharArray()) {
                switch (c) {
                    case '{': {
                        state = State.DEFAULT;
                        sb.append(" {\n");
                        ToStringHelperPrettyPrinter.appendIndent(sb, ++indent);
                        continue block9;
                    }
                    case '=': {
                        state = State.DEFAULT;
                        sb.append(" = ");
                        continue block9;
                    }
                    case ',': {
                        if (state == State.IN_SET) {
                            sb.append(',');
                            continue block9;
                        }
                        state = State.DEFAULT;
                        sb.append(",\n");
                        ToStringHelperPrettyPrinter.appendIndent(sb, indent);
                        continue block9;
                    }
                    case '}': {
                        state = State.DEFAULT;
                        sb.append("\n");
                        ToStringHelperPrettyPrinter.appendIndent(sb, --indent);
                        sb.append("}");
                        continue block9;
                    }
                    case ' ': {
                        if (state != State.IN_PHRASE && state != State.IN_SET) continue block9;
                        sb.append(" ");
                        continue block9;
                    }
                    case '[': {
                        sb.append('[');
                        state = State.IN_SET;
                        continue block9;
                    }
                    case ']': {
                        sb.append(']');
                        state = State.DEFAULT;
                        continue block9;
                    }
                    default: {
                        if (state != State.IN_SET) {
                            state = State.IN_PHRASE;
                        }
                        sb.append(c);
                    }
                }
            }
            return sb.toString();
        }

        static enum State {
            DEFAULT,
            IN_PHRASE,
            IN_SET;

        }
    }
}

