/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.GaxProperties;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PageContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.TraceServiceClient;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.GrpcTraceServiceStub;
import com.google.bigtable.repackaged.com.google.cloud.trace.v1.stub.TraceServiceStub;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.GetTraceRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.ListTracesRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.ListTracesResponse;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.PatchTracesRequest;
import com.google.bigtable.repackaged.com.google.devtools.cloudtrace.v1.Trace;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Set;

@BetaApi
public class TraceServiceStubSettings
extends StubSettings<TraceServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/cloud-platform")).add("https://www.googleapis.com/auth/trace.append")).add("https://www.googleapis.com/auth/trace.readonly")).build();
    private final UnaryCallSettings<PatchTracesRequest, Empty> patchTracesSettings;
    private final UnaryCallSettings<GetTraceRequest, Trace> getTraceSettings;
    private final PagedCallSettings<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings;
    private static final PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace> LIST_TRACES_PAGE_STR_DESC = new PagedListDescriptor<ListTracesRequest, ListTracesResponse, Trace>(){

        @Override
        public String emptyToken() {
            return "";
        }

        @Override
        public ListTracesRequest injectToken(ListTracesRequest payload, String token) {
            return ListTracesRequest.newBuilder(payload).setPageToken(token).build();
        }

        @Override
        public ListTracesRequest injectPageSize(ListTracesRequest payload, int pageSize) {
            return ListTracesRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        @Override
        public Integer extractPageSize(ListTracesRequest payload) {
            return payload.getPageSize();
        }

        @Override
        public String extractNextToken(ListTracesResponse payload) {
            return payload.getNextPageToken();
        }

        @Override
        public Iterable<Trace> extractResources(ListTracesResponse payload) {
            return payload.getTracesList() != null ? payload.getTracesList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> LIST_TRACES_PAGE_STR_FACT = new PagedListResponseFactory<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse>(){

        @Override
        public ApiFuture<TraceServiceClient.ListTracesPagedResponse> getFuturePagedResponse(UnaryCallable<ListTracesRequest, ListTracesResponse> callable, ListTracesRequest request, ApiCallContext context, ApiFuture<ListTracesResponse> futureResponse) {
            PageContext<ListTracesRequest, ListTracesResponse, Trace> pageContext = PageContext.create(callable, LIST_TRACES_PAGE_STR_DESC, request, context);
            return TraceServiceClient.ListTracesPagedResponse.createAsync(pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<PatchTracesRequest, Empty> patchTracesSettings() {
        return this.patchTracesSettings;
    }

    public UnaryCallSettings<GetTraceRequest, Trace> getTraceSettings() {
        return this.getTraceSettings;
    }

    public PagedCallSettings<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings() {
        return this.listTracesSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public TraceServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcTraceServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudtrace.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return TraceServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(TraceServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    protected TraceServiceStubSettings(Builder settingsBuilder) throws IOException {
        super(settingsBuilder);
        this.patchTracesSettings = settingsBuilder.patchTracesSettings().build();
        this.getTraceSettings = settingsBuilder.getTraceSettings().build();
        this.listTracesSettings = settingsBuilder.listTracesSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<TraceServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings;
        private final UnaryCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings;
        private final PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.patchTracesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTraceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTracesSettings = PagedCallSettings.newBuilder(LIST_TRACES_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(TraceServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider(TraceServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider(TraceServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(TraceServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.patchTracesSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            builder.getTraceSettings().setRetryableCodes((Set<StatusCode.Code>)RETRYABLE_CODE_DEFINITIONS.get("idempotent")).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            ((PagedCallSettings.Builder)builder.listTracesSettings().setRetryableCodes(RETRYABLE_CODE_DEFINITIONS.get("idempotent"))).setRetrySettings(RETRY_PARAM_DEFINITIONS.get("default"));
            return builder;
        }

        protected Builder(TraceServiceStubSettings settings) {
            super(settings);
            this.patchTracesSettings = settings.patchTracesSettings.toBuilder();
            this.getTraceSettings = settings.getTraceSettings.toBuilder();
            this.listTracesSettings = settings.listTracesSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.patchTracesSettings, this.getTraceSettings, this.listTracesSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<PatchTracesRequest, Empty> patchTracesSettings() {
            return this.patchTracesSettings;
        }

        public UnaryCallSettings.Builder<GetTraceRequest, Trace> getTraceSettings() {
            return this.getTraceSettings;
        }

        public PagedCallSettings.Builder<ListTracesRequest, ListTracesResponse, TraceServiceClient.ListTracesPagedResponse> listTracesSettings() {
            return this.listTracesSettings;
        }

        public TraceServiceStubSettings build() throws IOException {
            return new TraceServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder<String, Serializable> definitions = ImmutableMap.builder();
            definitions.put("idempotent", ImmutableSet.copyOf(Lists.newArrayList(StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE)));
            definitions.put("non_idempotent", ImmutableSet.copyOf(Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.2).setMaxRetryDelay(Duration.ofMillis(1000L)).setInitialRpcTimeout(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.5).setMaxRpcTimeout(Duration.ofMillis(30000L)).setTotalTimeout(Duration.ofMillis(45000L)).build();
            definitions.put("default", settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

