/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RowSetUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.Nonnull;

public final class Query
implements Serializable {
    private static final long serialVersionUID = -316972783499434755L;
    private static final int MAX_FILTER_SIZE = 20480;
    private final String tableId;
    private transient ReadRowsRequest.Builder builder = ReadRowsRequest.newBuilder();

    public static Query create(String tableId) {
        return new Query(tableId);
    }

    private Query(String tableId) {
        this.tableId = tableId;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadRowsRequest.Builder)ReadRowsRequest.newBuilder().mergeFrom(input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo(output);
    }

    public Query rowKey(String key) {
        Preconditions.checkNotNull(key, "Key can't be null.");
        return this.rowKey(ByteString.copyFromUtf8(key));
    }

    public Query rowKey(ByteString key) {
        Preconditions.checkNotNull(key, "Key can't be null.");
        this.builder.getRowsBuilder().addRowKeys(key);
        return this;
    }

    public Query prefix(ByteString prefix) {
        return this.range(Range.ByteStringRange.prefix(prefix));
    }

    public Query prefix(String prefix) {
        return this.range(Range.ByteStringRange.prefix(prefix));
    }

    public Query range(String start, String end) {
        return this.range(Query.wrapKey(start), Query.wrapKey(end));
    }

    public Query range(ByteString start, ByteString end) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        if (start != null) {
            rangeBuilder.setStartKeyClosed(start);
        }
        if (end != null) {
            rangeBuilder.setEndKeyOpen(end);
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query range(Range.ByteStringRange range) {
        RowRange.Builder rangeBuilder = RowRange.newBuilder();
        switch (range.getStartBound()) {
            case OPEN: {
                rangeBuilder.setStartKeyOpen((ByteString)range.getStart());
                break;
            }
            case CLOSED: {
                rangeBuilder.setStartKeyClosed((ByteString)range.getStart());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearStartKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown start bound: " + (Object)((Object)range.getStartBound()));
            }
        }
        switch (range.getEndBound()) {
            case OPEN: {
                rangeBuilder.setEndKeyOpen((ByteString)range.getEnd());
                break;
            }
            case CLOSED: {
                rangeBuilder.setEndKeyClosed((ByteString)range.getEnd());
                break;
            }
            case UNBOUNDED: {
                rangeBuilder.clearEndKey();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown end bound: " + (Object)((Object)range.getEndBound()));
            }
        }
        this.builder.getRowsBuilder().addRowRanges(rangeBuilder.build());
        return this;
    }

    public Query filter(Filters.Filter filter) {
        Preconditions.checkNotNull(filter, "filter can't be null");
        RowFilter rowFilter = filter.toProto();
        Preconditions.checkArgument(rowFilter.getSerializedSize() < 20480, "filter size can't be more than 20KB");
        this.builder.setFilter(rowFilter);
        return this;
    }

    public Query limit(long limit) {
        Preconditions.checkArgument(limit > 0L, "Limit must be greater than 0.");
        this.builder.setRowsLimit(limit);
        return this;
    }

    public List<Query> shard(List<KeyOffset> sampledRowKeys) {
        Preconditions.checkState(this.builder.getRowsLimit() == 0L, "Can't shard query with row limits");
        ImmutableSortedSet.Builder<ByteString> splitPoints = ImmutableSortedSet.orderedBy(ByteStringComparator.INSTANCE);
        for (KeyOffset keyOffset : sampledRowKeys) {
            if (keyOffset.getKey().isEmpty()) continue;
            splitPoints.add((Object)keyOffset.getKey());
        }
        return this.shard((SortedSet<ByteString>)((Object)splitPoints.build()));
    }

    public List<Query> shard(SortedSet<ByteString> splitPoints) {
        Preconditions.checkState(this.builder.getRowsLimit() == 0L, "Can't shard a query with a row limit");
        List<RowSet> shardedRowSets = RowSetUtil.shard(this.builder.getRows(), splitPoints);
        ArrayList<Query> shards = Lists.newArrayListWithCapacity(shardedRowSets.size());
        for (RowSet rowSet : shardedRowSets) {
            Query queryShard = new Query(this.tableId);
            queryShard.builder.mergeFrom(this.builder.build());
            queryShard.builder.setRows(rowSet);
            shards.add(queryShard);
        }
        return shards;
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public QueryPaginator createPaginator(int pageSize) {
        return new QueryPaginator(this, pageSize);
    }

    public Range.ByteStringRange getBound() {
        return RowSetUtil.getBound(this.builder.getRows());
    }

    @InternalApi
    public ReadRowsRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    public static Query fromProto(@Nonnull ReadRowsRequest request) {
        Preconditions.checkArgument(request != null, "ReadRowsRequest must not be null");
        Query query = new Query(NameUtil.extractTableIdFromTableName(request.getTableName()));
        query.builder = request.toBuilder();
        return query;
    }

    public Query clone() {
        Query query = Query.create(this.tableId);
        query.builder = this.builder.clone();
        return query;
    }

    private static ByteString wrapKey(String key) {
        if (key == null) {
            return null;
        }
        return ByteString.copyFromUtf8(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query = (Query)o;
        return Objects.equal(this.tableId, query.tableId) && Objects.equal(this.builder.getRows(), query.builder.getRows()) && Objects.equal(this.builder.getFilter(), query.builder.getFilter()) && Objects.equal(this.builder.getRowsLimit(), query.builder.getRowsLimit());
    }

    public int hashCode() {
        return Objects.hashCode(this.tableId, this.builder.getRows(), this.builder.getFilter(), this.builder.getRowsLimit());
    }

    public String toString() {
        ReadRowsRequest request = this.builder.build();
        return MoreObjects.toStringHelper(this).add("tableId", this.tableId).add("keys", request.getRows().getRowKeysList()).add("ranges", request.getRows().getRowRangesList()).add("filter", request.getFilter()).add("limit", request.getRowsLimit()).toString();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public static class QueryPaginator {
        private final boolean hasOverallLimit;
        private long remainingRows;
        private Query query;
        private final int pageSize;
        private ByteString prevSplitPoint;

        QueryPaginator(@Nonnull Query query, int pageSize) {
            this.hasOverallLimit = query.builder.getRowsLimit() > 0L;
            this.remainingRows = query.builder.getRowsLimit();
            this.query = query.limit(pageSize);
            if (this.hasOverallLimit) {
                this.remainingRows -= (long)pageSize;
            }
            this.pageSize = pageSize;
            this.prevSplitPoint = ByteString.EMPTY;
        }

        public Query getNextQuery() {
            return this.query;
        }

        public boolean advance(@Nonnull ByteString lastSeenRowKey) {
            Preconditions.checkNotNull(lastSeenRowKey, "lastSeenRowKey cannot be null, use ByteString.EMPTY instead.");
            if (lastSeenRowKey.equals(this.prevSplitPoint)) {
                return false;
            }
            this.prevSplitPoint = lastSeenRowKey;
            if (this.hasOverallLimit && this.remainingRows <= 0L) {
                return false;
            }
            if (this.hasOverallLimit) {
                this.query.limit(Math.min((long)this.pageSize, this.remainingRows));
                this.remainingRows -= (long)this.pageSize;
            } else {
                this.query.limit(this.pageSize);
            }
            RowSetUtil.Split split = RowSetUtil.split(this.query.builder.getRows(), lastSeenRowKey);
            if (split.getRight() == null) {
                return false;
            }
            this.query.builder.setRows(split.getRight());
            return true;
        }
    }
}

