/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ChangeStreamStateMachine;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.reframing.Reframer;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import java.util.ArrayDeque;
import java.util.Queue;

@InternalApi
public class ChangeStreamRecordMerger<ChangeStreamRecordT>
implements Reframer<ChangeStreamRecordT, ReadChangeStreamResponse> {
    private final ChangeStreamStateMachine<ChangeStreamRecordT> changeStreamStateMachine;
    private final Queue<ChangeStreamRecordT> changeStreamRecord;

    public ChangeStreamRecordMerger(ChangeStreamRecordAdapter.ChangeStreamRecordBuilder<ChangeStreamRecordT> changeStreamRecordBuilder) {
        this.changeStreamStateMachine = new ChangeStreamStateMachine<ChangeStreamRecordT>(changeStreamRecordBuilder);
        this.changeStreamRecord = new ArrayDeque<ChangeStreamRecordT>();
    }

    @Override
    public void push(ReadChangeStreamResponse response) {
        switch (response.getStreamRecordCase()) {
            case HEARTBEAT: {
                this.changeStreamStateMachine.handleHeartbeat(response.getHeartbeat());
                break;
            }
            case CLOSE_STREAM: {
                this.changeStreamStateMachine.handleCloseStream(response.getCloseStream());
                break;
            }
            case DATA_CHANGE: {
                this.changeStreamStateMachine.handleDataChange(response.getDataChange());
                break;
            }
            case STREAMRECORD_NOT_SET: {
                throw new IllegalStateException("Illegal stream record.");
            }
        }
        if (this.changeStreamStateMachine.hasCompleteChangeStreamRecord()) {
            this.changeStreamRecord.add(this.changeStreamStateMachine.consumeChangeStreamRecord());
        }
    }

    @Override
    public boolean hasFullFrame() {
        return !this.changeStreamRecord.isEmpty();
    }

    @Override
    public boolean hasPartialFrame() {
        return this.hasFullFrame() || this.changeStreamStateMachine.isChangeStreamRecordInProgress();
    }

    @Override
    public ChangeStreamRecordT pop() {
        return Preconditions.checkNotNull(this.changeStreamRecord.poll(), "ChangeStreamRecordMerger.pop() called when there are no change stream records.");
    }
}

