/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.StreamContinuationToken;
import com.google.bigtable.repackaged.com.google.bigtable.v2.StreamContinuationTokens;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;

@InternalApi
public class ReadChangeStreamResumptionStrategy<ChangeStreamRecordT>
implements StreamResumptionStrategy<ReadChangeStreamRequest, ChangeStreamRecordT> {
    private final ChangeStreamRecordAdapter<ChangeStreamRecordT> changeStreamRecordAdapter;
    private String token = null;

    public ReadChangeStreamResumptionStrategy(ChangeStreamRecordAdapter<ChangeStreamRecordT> changeStreamRecordAdapter) {
        this.changeStreamRecordAdapter = changeStreamRecordAdapter;
    }

    @Override
    public boolean canResume() {
        return true;
    }

    @Override
    public StreamResumptionStrategy<ReadChangeStreamRequest, ChangeStreamRecordT> createNew() {
        return new ReadChangeStreamResumptionStrategy<ChangeStreamRecordT>(this.changeStreamRecordAdapter);
    }

    @Override
    public ChangeStreamRecordT processResponse(ChangeStreamRecordT response) {
        if (this.changeStreamRecordAdapter.isHeartbeat(response)) {
            this.token = this.changeStreamRecordAdapter.getTokenFromHeartbeat(response);
        } else if (this.changeStreamRecordAdapter.isChangeStreamMutation(response)) {
            this.token = this.changeStreamRecordAdapter.getTokenFromChangeStreamMutation(response);
        }
        return response;
    }

    @Override
    public ReadChangeStreamRequest getResumeRequest(ReadChangeStreamRequest originalRequest) {
        if (this.token == null) {
            return originalRequest;
        }
        ReadChangeStreamRequest.Builder builder = originalRequest.toBuilder();
        builder.clearStartFrom();
        builder.setContinuationTokens(StreamContinuationTokens.newBuilder().addTokens(StreamContinuationToken.newBuilder().setPartition(originalRequest.getPartition()).setToken(this.token).build()).build());
        return builder.build();
    }
}

