/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.stats;

import com.google.bigtable.repackaged.com.google.api.Distribution;
import com.google.bigtable.repackaged.com.google.api.Metric;
import com.google.bigtable.repackaged.com.google.api.MetricDescriptor;
import com.google.bigtable.repackaged.com.google.api.MonitoredResource;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Function;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Functions;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.common.Timestamp;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelKey;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.LabelValue;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Distribution;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.MetricDescriptor;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Point;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Summary;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.TimeSeries;
import com.google.bigtable.repackaged.com.google.bigtable.veneer.repackaged.io.opencensus.metrics.export.Value;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.stats.BuiltinMeasureConstants;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.Maps;
import com.google.bigtable.repackaged.com.google.monitoring.v3.Point;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeInterval;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries;
import com.google.bigtable.repackaged.com.google.monitoring.v3.TypedValue;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

class BigtableStackdriverExportUtils {
    private static final Logger logger = Logger.getLogger(BigtableStackdriverExportUtils.class.getName());
    private static final Function<Double, TypedValue> typedValueDoubleFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        builder.setDoubleValue((double)arg);
        return builder.build();
    };
    private static final Function<Long, TypedValue> typedValueLongFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        builder.setInt64Value((long)arg);
        return builder.build();
    };
    private static final Function<Distribution, TypedValue> typedValueDistributionFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        return builder.setDistributionValue(BigtableStackdriverExportUtils.createDistribution(arg)).build();
    };
    private static final Function<Summary, TypedValue> typedValueSummaryFunction = arg -> {
        TypedValue.Builder builder = TypedValue.newBuilder();
        return builder.build();
    };
    private static final Function<Distribution.BucketOptions.ExplicitOptions, Distribution.BucketOptions> bucketOptionsExplicitFunction = arg -> {
        Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
        Distribution.BucketOptions.Explicit.Builder explicitBuilder = Distribution.BucketOptions.Explicit.newBuilder();
        explicitBuilder.addBounds(0.0);
        explicitBuilder.addAllBounds(arg.getBucketBoundaries());
        builder.setExplicitBuckets(explicitBuilder.build());
        return builder.build();
    };
    private static final Set<String> PROMOTED_RESOURCE_LABELS = ImmutableSet.of(BuiltinMeasureConstants.PROJECT_ID.getName(), BuiltinMeasureConstants.INSTANCE_ID.getName(), BuiltinMeasureConstants.CLUSTER.getName(), BuiltinMeasureConstants.ZONE.getName(), BuiltinMeasureConstants.TABLE.getName());
    private static final LabelKey CLIENT_UID_LABEL_KEY = LabelKey.create(BuiltinMeasureConstants.CLIENT_UID.getName(), "client uid");

    BigtableStackdriverExportUtils() {
    }

    static com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries convertTimeSeries(MetricDescriptor metricDescriptor, TimeSeries timeSeries, String clientId, MonitoredResource monitoredResource) {
        String metricName = metricDescriptor.getName();
        List<LabelKey> labelKeys = metricDescriptor.getLabelKeys();
        MetricDescriptor.Type metricType = metricDescriptor.getType();
        MonitoredResource.Builder monitoredResourceBuilder = monitoredResource.toBuilder();
        ArrayList<LabelKey> metricTagKeys = new ArrayList<LabelKey>();
        ArrayList<LabelValue> metricTagValues = new ArrayList<LabelValue>();
        List<LabelValue> labelValues = timeSeries.getLabelValues();
        for (int i = 0; i < labelValues.size(); ++i) {
            if (PROMOTED_RESOURCE_LABELS.contains(labelKeys.get(i).getKey())) {
                monitoredResourceBuilder.putLabels(labelKeys.get(i).getKey(), labelValues.get(i).getValue());
                continue;
            }
            metricTagKeys.add(labelKeys.get(i));
            metricTagValues.add(labelValues.get(i));
        }
        metricTagKeys.add(CLIENT_UID_LABEL_KEY);
        metricTagValues.add(LabelValue.create(clientId));
        TimeSeries.Builder builder = com.google.bigtable.repackaged.com.google.monitoring.v3.TimeSeries.newBuilder();
        builder.setResource(monitoredResourceBuilder.build());
        builder.setMetric(BigtableStackdriverExportUtils.createMetric(metricName, metricTagKeys, metricTagValues));
        builder.setMetricKind(BigtableStackdriverExportUtils.createMetricKind(metricType));
        builder.setValueType(BigtableStackdriverExportUtils.createValueType(metricType));
        Timestamp startTimeStamp = timeSeries.getStartTimestamp();
        for (Point point : timeSeries.getPoints()) {
            builder.addPoints(BigtableStackdriverExportUtils.createPoint(point, startTimeStamp));
        }
        return builder.build();
    }

    static String getProjectId(MetricDescriptor metricDescriptor, TimeSeries timeSeries) {
        List<LabelKey> labelKeys = metricDescriptor.getLabelKeys();
        List<LabelValue> labelValues = timeSeries.getLabelValues();
        for (int i = 0; i < labelKeys.size(); ++i) {
            if (!labelKeys.get(i).getKey().equals(BuiltinMeasureConstants.PROJECT_ID.getName())) continue;
            return labelValues.get(i).getValue();
        }
        throw new IllegalStateException("Can't find project id for the current timeseries");
    }

    static String getDefaultTaskValue() {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        if (jvmName.indexOf(64) < 1) {
            String hostname = "localhost";
            try {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                logger.log(Level.INFO, "Unable to get the hostname.", e);
            }
            return "java-" + new SecureRandom().nextInt() + "@" + hostname;
        }
        return "java-" + UUID.randomUUID() + jvmName;
    }

    private static MetricDescriptor.MetricKind createMetricKind(MetricDescriptor.Type type) {
        switch (type) {
            case CUMULATIVE_DOUBLE: 
            case CUMULATIVE_INT64: 
            case CUMULATIVE_DISTRIBUTION: {
                return MetricDescriptor.MetricKind.CUMULATIVE;
            }
        }
        return MetricDescriptor.MetricKind.UNRECOGNIZED;
    }

    private static MetricDescriptor.ValueType createValueType(MetricDescriptor.Type type) {
        switch (type) {
            case CUMULATIVE_DOUBLE: {
                return MetricDescriptor.ValueType.DOUBLE;
            }
            case CUMULATIVE_INT64: {
                return MetricDescriptor.ValueType.INT64;
            }
            case CUMULATIVE_DISTRIBUTION: {
                return MetricDescriptor.ValueType.DISTRIBUTION;
            }
        }
        return MetricDescriptor.ValueType.UNRECOGNIZED;
    }

    private static Metric createMetric(String metricName, List<LabelKey> labelKeys, List<LabelValue> labelValues) {
        Metric.Builder builder = Metric.newBuilder();
        builder.setType(metricName);
        HashMap<String, String> stringTagMap = Maps.newHashMap();
        for (int i = 0; i < labelValues.size(); ++i) {
            String value = labelValues.get(i).getValue();
            if (value == null) continue;
            stringTagMap.put(labelKeys.get(i).getKey(), value);
        }
        builder.putAllLabels(stringTagMap);
        return builder.build();
    }

    private static com.google.bigtable.repackaged.com.google.monitoring.v3.Point createPoint(Point point, Timestamp startTimestamp) {
        TimeInterval.Builder timeIntervalBuilder = TimeInterval.newBuilder();
        timeIntervalBuilder.setStartTime(BigtableStackdriverExportUtils.convertTimestamp(startTimestamp));
        timeIntervalBuilder.setEndTime(BigtableStackdriverExportUtils.convertTimestamp(point.getTimestamp()));
        Point.Builder builder = com.google.bigtable.repackaged.com.google.monitoring.v3.Point.newBuilder();
        builder.setInterval(timeIntervalBuilder.build());
        builder.setValue(BigtableStackdriverExportUtils.createTypedValue(point.getValue()));
        return builder.build();
    }

    private static TypedValue createTypedValue(Value value) {
        return value.match(typedValueDoubleFunction, typedValueLongFunction, typedValueDistributionFunction, typedValueSummaryFunction, Functions.throwIllegalArgumentException());
    }

    private static com.google.bigtable.repackaged.com.google.api.Distribution createDistribution(Distribution distribution) {
        Distribution.Builder builder = com.google.bigtable.repackaged.com.google.api.Distribution.newBuilder().setBucketOptions(BigtableStackdriverExportUtils.createBucketOptions(distribution.getBucketOptions())).setCount(distribution.getCount()).setMean(distribution.getCount() == 0L ? 0.0 : distribution.getSum() / (double)distribution.getCount()).setSumOfSquaredDeviation(distribution.getSumOfSquaredDeviations());
        BigtableStackdriverExportUtils.setBucketCounts(distribution.getBuckets(), builder);
        return builder.build();
    }

    private static Distribution.BucketOptions createBucketOptions(@Nullable Distribution.BucketOptions bucketOptions) {
        Distribution.BucketOptions.Builder builder = Distribution.BucketOptions.newBuilder();
        return bucketOptions == null ? builder.build() : bucketOptions.match(bucketOptionsExplicitFunction, Functions.throwIllegalArgumentException());
    }

    private static void setBucketCounts(List<Distribution.Bucket> buckets, Distribution.Builder builder) {
        builder.addBucketCounts(0L);
        for (Distribution.Bucket bucket : buckets) {
            builder.addBucketCounts(bucket.getCount());
        }
    }

    private static com.google.bigtable.repackaged.com.google.protobuf.Timestamp convertTimestamp(Timestamp censusTimestamp) {
        return censusTimestamp.getSeconds() < 0L ? com.google.bigtable.repackaged.com.google.protobuf.Timestamp.newBuilder().build() : com.google.bigtable.repackaged.com.google.protobuf.Timestamp.newBuilder().setSeconds(censusTimestamp.getSeconds()).setNanos(censusTimestamp.getNanos()).build();
    }
}

