/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.monitoring.v3;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.bigtable.repackaged.com.google.api.pathtemplate.ValidationException;
import com.google.bigtable.repackaged.com.google.api.resourcenames.ResourceName;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MonitoredResourceDescriptorName
implements ResourceName {
    private static final PathTemplate PROJECT_MONITORED_RESOURCE_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private static final PathTemplate ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("organizations/{organization}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private static final PathTemplate FOLDER_MONITORED_RESOURCE_DESCRIPTOR = PathTemplate.createWithoutUrlEncoding("folders/{folder}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String monitoredResourceDescriptor;
    private final String organization;
    private final String folder;

    @Deprecated
    protected MonitoredResourceDescriptorName() {
        this.project = null;
        this.monitoredResourceDescriptor = null;
        this.organization = null;
        this.folder = null;
    }

    private MonitoredResourceDescriptorName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.monitoredResourceDescriptor = Preconditions.checkNotNull(builder.getMonitoredResourceDescriptor());
        this.organization = null;
        this.folder = null;
        this.pathTemplate = PROJECT_MONITORED_RESOURCE_DESCRIPTOR;
    }

    private MonitoredResourceDescriptorName(OrganizationMonitoredResourceDescriptorBuilder builder) {
        this.organization = Preconditions.checkNotNull(builder.getOrganization());
        this.monitoredResourceDescriptor = Preconditions.checkNotNull(builder.getMonitoredResourceDescriptor());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR;
    }

    private MonitoredResourceDescriptorName(FolderMonitoredResourceDescriptorBuilder builder) {
        this.folder = Preconditions.checkNotNull(builder.getFolder());
        this.monitoredResourceDescriptor = Preconditions.checkNotNull(builder.getMonitoredResourceDescriptor());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_MONITORED_RESOURCE_DESCRIPTOR;
    }

    public String getProject() {
        return this.project;
    }

    public String getMonitoredResourceDescriptor() {
        return this.monitoredResourceDescriptor;
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getFolder() {
        return this.folder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static Builder newProjectMonitoredResourceDescriptorBuilder() {
        return new Builder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static OrganizationMonitoredResourceDescriptorBuilder newOrganizationMonitoredResourceDescriptorBuilder() {
        return new OrganizationMonitoredResourceDescriptorBuilder();
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static FolderMonitoredResourceDescriptorBuilder newFolderMonitoredResourceDescriptorBuilder() {
        return new FolderMonitoredResourceDescriptorBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MonitoredResourceDescriptorName of(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MonitoredResourceDescriptorName ofProjectMonitoredResourceDescriptorName(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MonitoredResourceDescriptorName ofOrganizationMonitoredResourceDescriptorName(String organization, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newOrganizationMonitoredResourceDescriptorBuilder().setOrganization(organization).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    @BetaApi(value="The static create methods are not stable yet and may be changed in the future.")
    public static MonitoredResourceDescriptorName ofFolderMonitoredResourceDescriptorName(String folder, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newFolderMonitoredResourceDescriptorBuilder().setFolder(folder).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build();
    }

    public static String format(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatProjectMonitoredResourceDescriptorName(String project, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newBuilder().setProject(project).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatOrganizationMonitoredResourceDescriptorName(String organization, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newOrganizationMonitoredResourceDescriptorBuilder().setOrganization(organization).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    @BetaApi(value="The static format methods are not stable yet and may be changed in the future.")
    public static String formatFolderMonitoredResourceDescriptorName(String folder, String monitoredResourceDescriptor) {
        return MonitoredResourceDescriptorName.newFolderMonitoredResourceDescriptorBuilder().setFolder(folder).setMonitoredResourceDescriptor(monitoredResourceDescriptor).build().toString();
    }

    public static MonitoredResourceDescriptorName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_MONITORED_RESOURCE_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = PROJECT_MONITORED_RESOURCE_DESCRIPTOR.match(formattedString);
            return MonitoredResourceDescriptorName.ofProjectMonitoredResourceDescriptorName(matchMap.get("project"), matchMap.get("monitored_resource_descriptor"));
        }
        if (ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR.match(formattedString);
            return MonitoredResourceDescriptorName.ofOrganizationMonitoredResourceDescriptorName(matchMap.get("organization"), matchMap.get("monitored_resource_descriptor"));
        }
        if (FOLDER_MONITORED_RESOURCE_DESCRIPTOR.matches(formattedString)) {
            Map<String, String> matchMap = FOLDER_MONITORED_RESOURCE_DESCRIPTOR.match(formattedString);
            return MonitoredResourceDescriptorName.ofFolderMonitoredResourceDescriptorName(matchMap.get("folder"), matchMap.get("monitored_resource_descriptor"));
        }
        throw new ValidationException("MonitoredResourceDescriptorName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<MonitoredResourceDescriptorName> parseList(List<String> formattedStrings) {
        ArrayList<MonitoredResourceDescriptorName> list = new ArrayList<MonitoredResourceDescriptorName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MonitoredResourceDescriptorName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MonitoredResourceDescriptorName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MonitoredResourceDescriptorName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_MONITORED_RESOURCE_DESCRIPTOR.matches(formattedString) || ORGANIZATION_MONITORED_RESOURCE_DESCRIPTOR.matches(formattedString) || FOLDER_MONITORED_RESOURCE_DESCRIPTOR.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MonitoredResourceDescriptorName monitoredResourceDescriptorName = this;
            synchronized (monitoredResourceDescriptorName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.monitoredResourceDescriptor != null) {
                        fieldMapBuilder.put("monitored_resource_descriptor", this.monitoredResourceDescriptor);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put("organization", this.organization);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put("folder", this.folder);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            MonitoredResourceDescriptorName that = (MonitoredResourceDescriptorName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.monitoredResourceDescriptor, that.monitoredResourceDescriptor) && Objects.equals(this.organization, that.organization) && Objects.equals(this.folder, that.folder);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.monitoredResourceDescriptor);
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        return h ^= Objects.hashCode(this.folder);
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class FolderMonitoredResourceDescriptorBuilder {
        private String folder;
        private String monitoredResourceDescriptor;

        protected FolderMonitoredResourceDescriptorBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public FolderMonitoredResourceDescriptorBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderMonitoredResourceDescriptorBuilder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }

    @BetaApi(value="The per-pattern Builders are not stable yet and may be changed in the future.")
    public static class OrganizationMonitoredResourceDescriptorBuilder {
        private String organization;
        private String monitoredResourceDescriptor;

        protected OrganizationMonitoredResourceDescriptorBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public OrganizationMonitoredResourceDescriptorBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationMonitoredResourceDescriptorBuilder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }

    public static class Builder {
        private String project;
        private String monitoredResourceDescriptor;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getMonitoredResourceDescriptor() {
            return this.monitoredResourceDescriptor;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setMonitoredResourceDescriptor(String monitoredResourceDescriptor) {
            this.monitoredResourceDescriptor = monitoredResourceDescriptor;
            return this;
        }

        private Builder(MonitoredResourceDescriptorName monitoredResourceDescriptorName) {
            Preconditions.checkArgument(Objects.equals(monitoredResourceDescriptorName.pathTemplate, PROJECT_MONITORED_RESOURCE_DESCRIPTOR), "toBuilder is only supported when MonitoredResourceDescriptorName has the pattern of projects/{project}/monitoredResourceDescriptors/{monitored_resource_descriptor}");
            this.project = monitoredResourceDescriptorName.project;
            this.monitoredResourceDescriptor = monitoredResourceDescriptorName.monitoredResourceDescriptor;
        }

        public MonitoredResourceDescriptorName build() {
            return new MonitoredResourceDescriptorName(this);
        }
    }
}

