/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.census;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Attributes;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ClientStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.ServerStreamTracer;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.opencensus.trace.AttributeValue;
import com.google.bigtable.repackaged.io.opencensus.trace.BlankSpan;
import com.google.bigtable.repackaged.io.opencensus.trace.EndSpanOptions;
import com.google.bigtable.repackaged.io.opencensus.trace.MessageEvent;
import com.google.bigtable.repackaged.io.opencensus.trace.Span;
import com.google.bigtable.repackaged.io.opencensus.trace.SpanContext;
import com.google.bigtable.repackaged.io.opencensus.trace.Tracer;
import com.google.bigtable.repackaged.io.opencensus.trace.propagation.BinaryFormat;
import com.google.bigtable.repackaged.io.opencensus.trace.unsafe.ContextUtils;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class CensusTracingModule {
    private static final Logger logger;
    @Nullable
    private static final AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> callEndedUpdater;
    @Nullable
    private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
    private final Tracer censusTracer;
    @VisibleForTesting
    final Metadata.Key<SpanContext> tracingHeader;
    private final TracingClientInterceptor clientInterceptor = new TracingClientInterceptor();
    private final ServerTracerFactory serverTracerFactory = new ServerTracerFactory();
    private final boolean addMessageEvents;

    CensusTracingModule(Tracer censusTracer, final BinaryFormat censusPropagationBinaryFormat, boolean addMessageEvents) {
        this.censusTracer = Preconditions.checkNotNull(censusTracer, "censusTracer");
        Preconditions.checkNotNull(censusPropagationBinaryFormat, "censusPropagationBinaryFormat");
        this.tracingHeader = Metadata.Key.of("grpc-trace-bin", new Metadata.BinaryMarshaller<SpanContext>(){

            @Override
            public byte[] toBytes(SpanContext context) {
                return censusPropagationBinaryFormat.toByteArray(context);
            }

            @Override
            public SpanContext parseBytes(byte[] serialized) {
                try {
                    return censusPropagationBinaryFormat.fromByteArray(serialized);
                }
                catch (Exception e) {
                    logger.log(Level.FINE, "Failed to parse tracing header", e);
                    return SpanContext.INVALID;
                }
            }
        });
        this.addMessageEvents = addMessageEvents;
    }

    @VisibleForTesting
    CallAttemptsTracerFactory newClientCallTracer(@Nullable Span parentSpan, MethodDescriptor<?, ?> method) {
        return new CallAttemptsTracerFactory(parentSpan, method);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return this.serverTracerFactory;
    }

    ClientInterceptor getClientInterceptor() {
        return this.clientInterceptor;
    }

    @VisibleForTesting
    static com.google.bigtable.repackaged.io.opencensus.trace.Status convertStatus(Status grpcStatus) {
        com.google.bigtable.repackaged.io.opencensus.trace.Status status;
        switch (grpcStatus.getCode()) {
            case OK: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.OK;
                break;
            }
            case CANCELLED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.CANCELLED;
                break;
            }
            case UNKNOWN: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.UNKNOWN;
                break;
            }
            case INVALID_ARGUMENT: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.INVALID_ARGUMENT;
                break;
            }
            case DEADLINE_EXCEEDED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.DEADLINE_EXCEEDED;
                break;
            }
            case NOT_FOUND: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.NOT_FOUND;
                break;
            }
            case ALREADY_EXISTS: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.ALREADY_EXISTS;
                break;
            }
            case PERMISSION_DENIED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.PERMISSION_DENIED;
                break;
            }
            case RESOURCE_EXHAUSTED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.RESOURCE_EXHAUSTED;
                break;
            }
            case FAILED_PRECONDITION: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.FAILED_PRECONDITION;
                break;
            }
            case ABORTED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.ABORTED;
                break;
            }
            case OUT_OF_RANGE: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.OUT_OF_RANGE;
                break;
            }
            case UNIMPLEMENTED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.UNIMPLEMENTED;
                break;
            }
            case INTERNAL: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.INTERNAL;
                break;
            }
            case UNAVAILABLE: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.UNAVAILABLE;
                break;
            }
            case DATA_LOSS: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.DATA_LOSS;
                break;
            }
            case UNAUTHENTICATED: {
                status = com.google.bigtable.repackaged.io.opencensus.trace.Status.UNAUTHENTICATED;
                break;
            }
            default: {
                throw new AssertionError((Object)("Unhandled status code " + (Object)((Object)grpcStatus.getCode())));
            }
        }
        if (grpcStatus.getDescription() != null) {
            status = status.withDescription(grpcStatus.getDescription());
        }
        return status;
    }

    private static EndSpanOptions createEndSpanOptions(Status status, boolean sampledToLocalTracing) {
        return EndSpanOptions.builder().setStatus(CensusTracingModule.convertStatus(status)).setSampleToLocalSpanStore(sampledToLocalTracing).build();
    }

    private void recordMessageEvent(Span span, MessageEvent.Type type, int seqNo, long optionalWireSize, long optionalUncompressedSize) {
        if (!this.addMessageEvents) {
            return;
        }
        MessageEvent.Builder eventBuilder = MessageEvent.builder(type, seqNo);
        if (optionalUncompressedSize != -1L) {
            eventBuilder.setUncompressedMessageSize(optionalUncompressedSize);
        }
        if (optionalWireSize != -1L) {
            eventBuilder.setCompressedMessageSize(optionalWireSize);
        }
        span.addMessageEvent(eventBuilder.build());
    }

    @VisibleForTesting
    static String generateTraceSpanName(boolean isServer, String fullMethodName) {
        String prefix = isServer ? "Recv" : "Sent";
        return prefix + "." + fullMethodName.replace('/', '.');
    }

    static {
        AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
        AtomicIntegerFieldUpdater<CallAttemptsTracerFactory> tmpCallEndedUpdater;
        logger = Logger.getLogger(CensusTracingModule.class.getName());
        try {
            tmpCallEndedUpdater = AtomicIntegerFieldUpdater.newUpdater(CallAttemptsTracerFactory.class, "callEnded");
            tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
            tmpCallEndedUpdater = null;
            tmpStreamClosedUpdater = null;
        }
        callEndedUpdater = tmpCallEndedUpdater;
        streamClosedUpdater = tmpStreamClosedUpdater;
    }

    @VisibleForTesting
    final class TracingClientInterceptor
    implements ClientInterceptor {
        TracingClientInterceptor() {
        }

        @Override
        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            final CallAttemptsTracerFactory tracerFactory = CensusTracingModule.this.newClientCallTracer(ContextUtils.getValue(Context.current()), method);
            ClientCall<ReqT, RespT> call = next.newCall(method, callOptions.withStreamTracerFactory(tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                @Override
                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start(new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        @Override
                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        @Override
        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            SpanContext remoteSpan = headers.get(CensusTracingModule.this.tracingHeader);
            if (remoteSpan == SpanContext.INVALID) {
                remoteSpan = null;
            }
            return new ServerTracer(fullMethodName, remoteSpan);
        }
    }

    private final class ServerTracer
    extends ServerStreamTracer {
        private final Span span;
        volatile boolean isSampledToLocalTracing;
        volatile int streamClosed;

        ServerTracer(@Nullable String fullMethodName, SpanContext remoteSpan) {
            Preconditions.checkNotNull(fullMethodName, "fullMethodName");
            this.span = CensusTracingModule.this.censusTracer.spanBuilderWithRemoteParent(CensusTracingModule.generateTraceSpanName(true, fullMethodName), remoteSpan).setRecordEvents(true).startSpan();
        }

        @Override
        public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
            this.isSampledToLocalTracing = callInfo.getMethodDescriptor().isSampledToLocalTracing();
        }

        @Override
        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            this.span.end(CensusTracingModule.createEndSpanOptions(status, this.isSampledToLocalTracing));
        }

        @Override
        public Context filterContext(Context context) {
            return ContextUtils.withValue(context, this.span);
        }

        @Override
        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordMessageEvent(this.span, MessageEvent.Type.SENT, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        @Override
        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordMessageEvent(this.span, MessageEvent.Type.RECEIVED, seqNo, optionalWireSize, optionalUncompressedSize);
        }
    }

    private final class ClientTracer
    extends ClientStreamTracer {
        private final Span span;
        final Metadata.Key<SpanContext> tracingHeader;
        final boolean isSampledToLocalTracing;

        ClientTracer(Span span, Metadata.Key<SpanContext> tracingHeader, boolean isSampledToLocalTracing) {
            this.span = Preconditions.checkNotNull(span, "span");
            this.tracingHeader = tracingHeader;
            this.isSampledToLocalTracing = isSampledToLocalTracing;
        }

        @Override
        public void streamCreated(Attributes transportAtts, Metadata headers) {
            if (this.span != BlankSpan.INSTANCE) {
                headers.discardAll(this.tracingHeader);
                headers.put(this.tracingHeader, this.span.getContext());
            }
        }

        @Override
        public void outboundMessageSent(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordMessageEvent(this.span, MessageEvent.Type.SENT, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        @Override
        public void inboundMessageRead(int seqNo, long optionalWireSize, long optionalUncompressedSize) {
            CensusTracingModule.this.recordMessageEvent(this.span, MessageEvent.Type.RECEIVED, seqNo, optionalWireSize, optionalUncompressedSize);
        }

        @Override
        public void streamClosed(Status status) {
            this.span.end(CensusTracingModule.createEndSpanOptions(status, this.isSampledToLocalTracing));
        }
    }

    @VisibleForTesting
    final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        volatile int callEnded;
        private final boolean isSampledToLocalTracing;
        private final Span span;
        private final String fullMethodName;

        CallAttemptsTracerFactory(Span parentSpan, MethodDescriptor<?, ?> method) {
            Preconditions.checkNotNull(method, "method");
            this.isSampledToLocalTracing = method.isSampledToLocalTracing();
            this.fullMethodName = method.getFullMethodName();
            this.span = CensusTracingModule.this.censusTracer.spanBuilderWithExplicitParent(CensusTracingModule.generateTraceSpanName(false, this.fullMethodName), parentSpan).setRecordEvents(true).startSpan();
        }

        @Override
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata headers) {
            Span attemptSpan = CensusTracingModule.this.censusTracer.spanBuilderWithExplicitParent("Attempt." + this.fullMethodName.replace('/', '.'), this.span).setRecordEvents(true).startSpan();
            attemptSpan.putAttribute("previous-rpc-attempts", AttributeValue.longAttributeValue(info.getPreviousAttempts()));
            attemptSpan.putAttribute("transparent-retry", AttributeValue.booleanAttributeValue(info.isTransparentRetry()));
            return new ClientTracer(attemptSpan, CensusTracingModule.this.tracingHeader, this.isSampledToLocalTracing);
        }

        void callEnded(Status status) {
            if (callEndedUpdater != null) {
                if (callEndedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.callEnded != 0) {
                    return;
                }
                this.callEnded = 1;
            }
            this.span.end(CensusTracingModule.createEndSpanOptions(status, this.isSampledToLocalTracing));
        }
    }
}

