/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.services;

import com.google.bigtable.repackaged.io.grpc.ExperimentalApi;
import com.google.bigtable.repackaged.io.grpc.services.MetricReport;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/9006")
public final class MetricRecorder {
    private volatile ConcurrentHashMap<String, Double> metricsData = new ConcurrentHashMap();
    private volatile double cpuUtilization;
    private volatile double memoryUtilization;

    public static MetricRecorder newInstance() {
        return new MetricRecorder();
    }

    private MetricRecorder() {
    }

    public void putUtilizationMetric(String key, double value) {
        this.metricsData.put(key, value);
    }

    public void setAllUtilizationMetrics(Map<String, Double> metrics) {
        this.metricsData = new ConcurrentHashMap<String, Double>(metrics);
    }

    public void removeUtilizationMetric(String key) {
        this.metricsData.remove(key);
    }

    public void setCpuUtilizationMetric(double value) {
        this.cpuUtilization = value;
    }

    public void clearCpuUtilizationMetric() {
        this.cpuUtilization = 0.0;
    }

    public void setMemoryUtilizationMetric(double value) {
        this.memoryUtilization = value;
    }

    public void clearMemoryUtilizationMetric() {
        this.memoryUtilization = 0.0;
    }

    MetricReport getMetricReport() {
        return new MetricReport(this.cpuUtilization, this.memoryUtilization, Collections.emptyMap(), Collections.unmodifiableMap(this.metricsData));
    }
}

