/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.io.grpc.xds;

import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Stopwatch;
import com.google.bigtable.repackaged.com.google.common.base.Supplier;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.SettableFuture;
import com.google.bigtable.repackaged.com.google.protobuf.Any;
import com.google.bigtable.repackaged.io.grpc.ChannelCredentials;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.Grpc;
import com.google.bigtable.repackaged.io.grpc.InternalLogId;
import com.google.bigtable.repackaged.io.grpc.LoadBalancerRegistry;
import com.google.bigtable.repackaged.io.grpc.ManagedChannel;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.Status;
import com.google.bigtable.repackaged.io.grpc.SynchronizationContext;
import com.google.bigtable.repackaged.io.grpc.internal.BackoffPolicy;
import com.google.bigtable.repackaged.io.grpc.internal.TimeProvider;
import com.google.bigtable.repackaged.io.grpc.xds.AbstractXdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.Bootstrapper;
import com.google.bigtable.repackaged.io.grpc.xds.BootstrapperImpl;
import com.google.bigtable.repackaged.io.grpc.xds.FilterRegistry;
import com.google.bigtable.repackaged.io.grpc.xds.LoadReportClient;
import com.google.bigtable.repackaged.io.grpc.xds.LoadStatsManager2;
import com.google.bigtable.repackaged.io.grpc.xds.Locality;
import com.google.bigtable.repackaged.io.grpc.xds.TlsContextManager;
import com.google.bigtable.repackaged.io.grpc.xds.XdsClient;
import com.google.bigtable.repackaged.io.grpc.xds.XdsListenerResource;
import com.google.bigtable.repackaged.io.grpc.xds.XdsLogger;
import com.google.bigtable.repackaged.io.grpc.xds.XdsResourceType;
import com.google.bigtable.repackaged.io.grpc.xds.XdsRouteConfigureResource;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class XdsClientImpl
extends XdsClient
implements XdsClient.XdsResponseHandler,
XdsClient.ResourceStore,
XdsClient.TimerLaunch {
    private static boolean LOG_XDS_NODE_ID = Boolean.parseBoolean(System.getenv("GRPC_LOG_XDS_NODE_ID"));
    private static final Logger classLogger = Logger.getLogger(XdsClientImpl.class.getName());
    @VisibleForTesting
    static final int INITIAL_RESOURCE_FETCH_TIMEOUT_SEC = 15;
    private final SynchronizationContext syncContext = new SynchronizationContext(new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "Uncaught exception in XdsClient SynchronizationContext. Panic!", e);
            throw new AssertionError((Object)e);
        }
    });
    private final FilterRegistry filterRegistry = FilterRegistry.getDefaultRegistry();
    private final LoadBalancerRegistry loadBalancerRegistry = LoadBalancerRegistry.getDefaultRegistry();
    private final Map<Bootstrapper.ServerInfo, AbstractXdsClient> serverChannelMap = new HashMap<Bootstrapper.ServerInfo, AbstractXdsClient>();
    private final Map<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>> resourceSubscribers = new HashMap<XdsResourceType<? extends XdsClient.ResourceUpdate>, Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>>>();
    private final Map<String, XdsResourceType<?>> subscribedResourceTypeUrls = new HashMap();
    private final LoadStatsManager2 loadStatsManager;
    private final Map<Bootstrapper.ServerInfo, LoadReportClient> serverLrsClientMap = new HashMap<Bootstrapper.ServerInfo, LoadReportClient>();
    private final XdsChannelFactory xdsChannelFactory;
    private final Bootstrapper.BootstrapInfo bootstrapInfo;
    private final Context context;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final TimeProvider timeProvider;
    private boolean reportingLoad;
    private final TlsContextManager tlsContextManager;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private volatile boolean isShutdown;

    XdsClientImpl(XdsChannelFactory xdsChannelFactory, Bootstrapper.BootstrapInfo bootstrapInfo, Context context, ScheduledExecutorService timeService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, TimeProvider timeProvider, TlsContextManager tlsContextManager) {
        this.xdsChannelFactory = xdsChannelFactory;
        this.bootstrapInfo = bootstrapInfo;
        this.context = context;
        this.timeService = timeService;
        this.loadStatsManager = new LoadStatsManager2(stopwatchSupplier);
        this.backoffPolicyProvider = backoffPolicyProvider;
        this.stopwatchSupplier = stopwatchSupplier;
        this.timeProvider = timeProvider;
        this.tlsContextManager = Preconditions.checkNotNull(tlsContextManager, "tlsContextManager");
        this.logId = InternalLogId.allocate("xds-client", null);
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
        if (LOG_XDS_NODE_ID) {
            classLogger.log(Level.INFO, "xDS node ID: {0}", bootstrapInfo.node().getId());
        }
    }

    private void maybeCreateXdsChannelWithLrs(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        if (this.serverChannelMap.containsKey(serverInfo)) {
            return;
        }
        AbstractXdsClient xdsChannel = new AbstractXdsClient(this.xdsChannelFactory, serverInfo, this.bootstrapInfo.node(), this, this, this.context, this.timeService, this.syncContext, this.backoffPolicyProvider, this.stopwatchSupplier, this);
        LoadReportClient lrsClient = new LoadReportClient(this.loadStatsManager, xdsChannel.channel(), this.context, this.bootstrapInfo.node(), this.syncContext, this.timeService, this.backoffPolicyProvider, this.stopwatchSupplier);
        this.serverChannelMap.put(serverInfo, xdsChannel);
        this.serverLrsClientMap.put(serverInfo, lrsClient);
    }

    @Override
    public void handleResourceResponse(XdsResourceType<?> xdsResourceType, Bootstrapper.ServerInfo serverInfo, String versionInfo, List<Any> resources, String nonce) {
        Preconditions.checkNotNull(xdsResourceType, "xdsResourceType");
        this.syncContext.throwIfNotInThisSynchronizationContext();
        Set<String> toParseResourceNames = null;
        if (xdsResourceType != XdsListenerResource.getInstance() && xdsResourceType != XdsRouteConfigureResource.getInstance() && this.resourceSubscribers.containsKey(xdsResourceType)) {
            toParseResourceNames = this.resourceSubscribers.get(xdsResourceType).keySet();
        }
        XdsResourceType.Args args = new XdsResourceType.Args(serverInfo, versionInfo, nonce, this.bootstrapInfo, this.filterRegistry, this.loadBalancerRegistry, this.tlsContextManager, toParseResourceNames);
        this.handleResourceUpdate(args, resources, xdsResourceType);
    }

    @Override
    public void handleStreamClosed(Status error) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        this.cleanUpResourceTimers();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (subscriber.hasResult()) continue;
                subscriber.onError(error);
            }
        }
    }

    @Override
    public void handleStreamRestarted(Bootstrapper.ServerInfo serverInfo) {
        this.syncContext.throwIfNotInThisSynchronizationContext();
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                if (!((ResourceSubscriber)subscriber).serverInfo.equals(serverInfo)) continue;
                subscriber.restartTimer();
            }
        }
    }

    @Override
    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutdown) {
                    return;
                }
                XdsClientImpl.this.isShutdown = true;
                for (AbstractXdsClient xdsChannel : XdsClientImpl.this.serverChannelMap.values()) {
                    xdsChannel.shutdown();
                }
                if (XdsClientImpl.this.reportingLoad) {
                    for (LoadReportClient lrsClient : XdsClientImpl.this.serverLrsClientMap.values()) {
                        lrsClient.stopLoadReporting();
                    }
                }
                XdsClientImpl.this.cleanUpResourceTimers();
            }
        });
    }

    @Override
    boolean isShutDown() {
        return this.isShutdown;
    }

    @Override
    public Map<String, XdsResourceType<?>> getSubscribedResourceTypesWithTypeUrl() {
        return Collections.unmodifiableMap(this.subscribedResourceTypeUrls);
    }

    @Override
    @Nullable
    public Collection<String> getSubscribedResources(Bootstrapper.ServerInfo serverInfo, XdsResourceType<? extends XdsClient.ResourceUpdate> type) {
        Map resources = this.resourceSubscribers.getOrDefault(type, Collections.emptyMap());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String key : resources.keySet()) {
            if (!((ResourceSubscriber)resources.get(key)).serverInfo.equals(serverInfo)) continue;
            builder.add(key);
        }
        ImmutableCollection retVal = builder.build();
        return retVal.isEmpty() ? null : retVal;
    }

    @Override
    ListenableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> getSubscribedResourcesMetadataSnapshot() {
        final SettableFuture<Map<XdsResourceType<?>, Map<String, XdsClient.ResourceMetadata>>> future = SettableFuture.create();
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ImmutableMap.Builder metadataSnapshot = ImmutableMap.builder();
                for (XdsResourceType resourceType : XdsClientImpl.this.resourceSubscribers.keySet()) {
                    ImmutableMap.Builder<String, XdsClient.ResourceMetadata> metadataMap = ImmutableMap.builder();
                    for (Map.Entry resourceEntry : ((Map)XdsClientImpl.this.resourceSubscribers.get(resourceType)).entrySet()) {
                        metadataMap.put((String)resourceEntry.getKey(), ((ResourceSubscriber)resourceEntry.getValue()).metadata);
                    }
                    metadataSnapshot.put(resourceType, metadataMap.buildOrThrow());
                }
                future.set(metadataSnapshot.buildOrThrow());
            }
        });
        return future;
    }

    @Override
    TlsContextManager getTlsContextManager() {
        return this.tlsContextManager;
    }

    @Override
    <T extends XdsClient.ResourceUpdate> void watchXdsResource(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber;
                if (!XdsClientImpl.this.resourceSubscribers.containsKey(type)) {
                    XdsClientImpl.this.resourceSubscribers.put(type, new HashMap());
                    XdsClientImpl.this.subscribedResourceTypeUrls.put(type.typeUrl(), type);
                }
                if ((subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName)) == null) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Subscribe {0} resource {1}", type, resourceName);
                    subscriber = new ResourceSubscriber(type, resourceName);
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).put(resourceName, subscriber);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(type);
                    }
                }
                subscriber.addWatcher(watcher);
            }
        });
    }

    @Override
    <T extends XdsClient.ResourceUpdate> void cancelXdsResourceWatch(final XdsResourceType<T> type, final String resourceName, final XdsClient.ResourceWatcher<T> watcher) {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ResourceSubscriber subscriber = (ResourceSubscriber)((Map)XdsClientImpl.this.resourceSubscribers.get(type)).get(resourceName);
                subscriber.removeWatcher(watcher);
                if (!subscriber.isWatched()) {
                    subscriber.cancelResourceWatch();
                    ((Map)XdsClientImpl.this.resourceSubscribers.get(type)).remove(resourceName);
                    if (subscriber.xdsChannel != null) {
                        subscriber.xdsChannel.adjustResourceSubscription(type);
                    }
                    if (((Map)XdsClientImpl.this.resourceSubscribers.get(type)).isEmpty()) {
                        XdsClientImpl.this.resourceSubscribers.remove(type);
                        XdsClientImpl.this.subscribedResourceTypeUrls.remove(type.typeUrl());
                    }
                }
            }
        });
    }

    @Override
    LoadStatsManager2.ClusterDropStats addClusterDropStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName) {
        LoadStatsManager2.ClusterDropStats dropCounter = this.loadStatsManager.getClusterDropStats(clusterName, edsServiceName);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsClientImpl.this.reportingLoad) {
                    ((LoadReportClient)XdsClientImpl.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
                    XdsClientImpl.this.reportingLoad = true;
                }
            }
        });
        return dropCounter;
    }

    @Override
    LoadStatsManager2.ClusterLocalityStats addClusterLocalityStats(final Bootstrapper.ServerInfo serverInfo, String clusterName, @Nullable String edsServiceName, Locality locality) {
        LoadStatsManager2.ClusterLocalityStats loadCounter = this.loadStatsManager.getClusterLocalityStats(clusterName, edsServiceName, locality);
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (!XdsClientImpl.this.reportingLoad) {
                    ((LoadReportClient)XdsClientImpl.this.serverLrsClientMap.get(serverInfo)).startLoadReporting();
                    XdsClientImpl.this.reportingLoad = true;
                }
            }
        });
        return loadCounter;
    }

    @Override
    Bootstrapper.BootstrapInfo getBootstrapInfo() {
        return this.bootstrapInfo;
    }

    public String toString() {
        return this.logId.toString();
    }

    @Override
    public void startSubscriberTimersIfNeeded(final Bootstrapper.ServerInfo serverInfo) {
        if (this.isShutDown()) {
            return;
        }
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                if (XdsClientImpl.this.isShutDown()) {
                    return;
                }
                for (Map subscriberMap : XdsClientImpl.this.resourceSubscribers.values()) {
                    for (ResourceSubscriber subscriber : subscriberMap.values()) {
                        if (!subscriber.serverInfo.equals(serverInfo) || subscriber.respTimer != null) continue;
                        subscriber.restartTimer();
                    }
                }
            }
        });
    }

    private void cleanUpResourceTimers() {
        for (Map<String, ResourceSubscriber<? extends XdsClient.ResourceUpdate>> subscriberMap : this.resourceSubscribers.values()) {
            for (ResourceSubscriber<? extends XdsClient.ResourceUpdate> subscriber : subscriberMap.values()) {
                subscriber.stopTimer();
            }
        }
    }

    private <T extends XdsClient.ResourceUpdate> void handleResourceUpdate(XdsResourceType.Args args, List<Any> resources, XdsResourceType<T> xdsResourceType) {
        XdsResourceType.ValidatedResourceUpdate<T> result = xdsResourceType.parse(args, resources);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received {0} Response version {1} nonce {2}. Parsed resources: {3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, result.unpackedResources);
        Map parsedResources = result.parsedResources;
        Set<String> invalidResources = result.invalidResources;
        List<String> errors = result.errors;
        String errorDetail = null;
        if (errors.isEmpty()) {
            Preconditions.checkArgument(invalidResources.isEmpty(), "found invalid resources but missing errors");
            this.serverChannelMap.get(args.serverInfo).ackResponse(xdsResourceType, args.versionInfo, args.nonce);
        } else {
            errorDetail = Joiner.on('\n').join(errors);
            this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Failed processing {0} Response version {1} nonce {2}. Errors:\n{3}", xdsResourceType.typeName(), args.versionInfo, args.nonce, errorDetail);
            this.serverChannelMap.get(args.serverInfo).nackResponse(xdsResourceType, args.nonce, errorDetail);
        }
        long updateTime = this.timeProvider.currentTimeNanos();
        Map subscribedResources = this.resourceSubscribers.getOrDefault(xdsResourceType, Collections.emptyMap());
        for (Map.Entry entry : subscribedResources.entrySet()) {
            String resourceName = (String)entry.getKey();
            ResourceSubscriber subscriber = (ResourceSubscriber)entry.getValue();
            if (parsedResources.containsKey(resourceName)) {
                subscriber.onData(parsedResources.get(resourceName), args.versionInfo, updateTime);
                continue;
            }
            if (invalidResources.contains(resourceName)) {
                subscriber.onRejected(args.versionInfo, updateTime, errorDetail);
            }
            if (!xdsResourceType.isFullStateOfTheWorld()) continue;
            if (invalidResources.contains(resourceName)) {
                if (subscriber.data != null) continue;
                subscriber.onError(Status.UNAVAILABLE.withDescription(errorDetail));
                continue;
            }
            subscriber.onAbsent();
        }
    }

    static abstract class XdsChannelFactory {
        static final XdsChannelFactory DEFAULT_XDS_CHANNEL_FACTORY = new XdsChannelFactory(){

            @Override
            ManagedChannel create(Bootstrapper.ServerInfo serverInfo) {
                String target = serverInfo.target();
                ChannelCredentials channelCredentials = serverInfo.channelCredentials();
                return ((ManagedChannelBuilder)Grpc.newChannelBuilder(target, channelCredentials).keepAliveTime(5L, TimeUnit.MINUTES)).build();
            }
        };

        XdsChannelFactory() {
        }

        abstract ManagedChannel create(Bootstrapper.ServerInfo var1);
    }

    static final class ResourceInvalidException
    extends Exception {
        private static final long serialVersionUID = 0L;

        ResourceInvalidException(String message) {
            super(message, null, false, false);
        }

        ResourceInvalidException(String message, Throwable cause) {
            super(cause != null ? message + ": " + cause.getMessage() : message, cause, false, false);
        }
    }

    private final class ResourceSubscriber<T extends XdsClient.ResourceUpdate> {
        @Nullable
        private final Bootstrapper.ServerInfo serverInfo;
        @Nullable
        private final AbstractXdsClient xdsChannel;
        private final XdsResourceType<T> type;
        private final String resource;
        private final Set<XdsClient.ResourceWatcher<T>> watchers = new HashSet<XdsClient.ResourceWatcher<T>>();
        @Nullable
        private T data;
        private boolean absent;
        private boolean resourceDeletionIgnored;
        @Nullable
        private SynchronizationContext.ScheduledHandle respTimer;
        @Nullable
        private XdsClient.ResourceMetadata metadata;
        @Nullable
        private String errorDescription;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ResourceSubscriber(XdsResourceType<T> type, String resource) {
            XdsClientImpl.this.syncContext.throwIfNotInThisSynchronizationContext();
            this.type = type;
            this.resource = resource;
            this.serverInfo = this.getServerInfo(resource);
            if (this.serverInfo == null) {
                this.errorDescription = "Wrong configuration: xds server does not exist for resource " + resource;
                this.xdsChannel = null;
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataUnknown();
            AbstractXdsClient xdsChannelTemp = null;
            try {
                XdsClientImpl.this.maybeCreateXdsChannelWithLrs(this.serverInfo);
                xdsChannelTemp = (AbstractXdsClient)XdsClientImpl.this.serverChannelMap.get(this.serverInfo);
                if (xdsChannelTemp.isInBackoff()) {
                    return;
                }
            }
            catch (IllegalArgumentException e) {
                xdsChannelTemp = null;
                this.errorDescription = "Bad configuration:  " + e.getMessage();
                return;
            }
            finally {
                this.xdsChannel = xdsChannelTemp;
            }
            this.restartTimer();
        }

        @Nullable
        private Bootstrapper.ServerInfo getServerInfo(String resource) {
            if (BootstrapperImpl.enableFederation && resource.startsWith("xdstp:")) {
                Bootstrapper.AuthorityInfo authorityInfo;
                URI uri = URI.create(resource);
                String authority = uri.getAuthority();
                if (authority == null) {
                    authority = "";
                }
                if ((authorityInfo = XdsClientImpl.this.bootstrapInfo.authorities().get(authority)) == null || authorityInfo.xdsServers().isEmpty()) {
                    return null;
                }
                return (Bootstrapper.ServerInfo)authorityInfo.xdsServers().get(0);
            }
            return (Bootstrapper.ServerInfo)XdsClientImpl.this.bootstrapInfo.servers().get(0);
        }

        void addWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument(!this.watchers.contains(watcher), "watcher %s already registered", watcher);
            this.watchers.add(watcher);
            if (this.errorDescription != null) {
                watcher.onError(Status.INVALID_ARGUMENT.withDescription(this.errorDescription));
                return;
            }
            if (this.data != null) {
                this.notifyWatcher(watcher, this.data);
            } else if (this.absent) {
                watcher.onResourceDoesNotExist(this.resource);
            }
        }

        void removeWatcher(XdsClient.ResourceWatcher<T> watcher) {
            Preconditions.checkArgument(this.watchers.contains(watcher), "watcher %s not registered", watcher);
            this.watchers.remove(watcher);
        }

        void restartTimer() {
            if (this.data != null || this.absent) {
                return;
            }
            if (!this.xdsChannel.isReady()) {
                return;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataRequested();
            class ResourceNotFound
            implements Runnable {
                ResourceNotFound() {
                }

                @Override
                public void run() {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "{0} resource {1} initial fetch timeout", ResourceSubscriber.this.type, ResourceSubscriber.this.resource);
                    ResourceSubscriber.this.respTimer = null;
                    ResourceSubscriber.this.onAbsent();
                }

                public String toString() {
                    return ResourceSubscriber.this.type + this.getClass().getSimpleName();
                }
            }
            this.respTimer = XdsClientImpl.this.syncContext.schedule(new ResourceNotFound(), 15L, TimeUnit.SECONDS, XdsClientImpl.this.timeService);
        }

        void stopTimer() {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
        }

        void cancelResourceWatch() {
            if (this.isWatched()) {
                throw new IllegalStateException("Can't cancel resource watch with active watchers present");
            }
            this.stopTimer();
            String message = "Unsubscribing {0} resource {1} from server {2}";
            XdsLogger.XdsLogLevel logLevel = XdsLogger.XdsLogLevel.INFO;
            if (this.resourceDeletionIgnored) {
                message = message + " for which we previously ignored a deletion";
                logLevel = XdsLogger.XdsLogLevel.FORCE_INFO;
            }
            XdsClientImpl.this.logger.log(logLevel, message, this.type, this.resource, this.serverInfo != null ? this.serverInfo.target() : "unknown");
        }

        boolean isWatched() {
            return !this.watchers.isEmpty();
        }

        boolean hasResult() {
            return this.data != null || this.absent;
        }

        void onData(XdsResourceType.ParsedResource<T> parsedResource, String version, long updateTime) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataAcked(parsedResource.getRawResource(), version, updateTime);
            T oldData = this.data;
            this.data = parsedResource.getResourceUpdate();
            this.absent = false;
            if (this.resourceDeletionIgnored) {
                XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_INFO, "xds server {0}: server returned new version of resource for which we previously ignored a deletion: type {1} name {2}", this.serverInfo != null ? this.serverInfo.target() : "unknown", this.type, this.resource);
                this.resourceDeletionIgnored = false;
            }
            if (!Objects.equals(oldData, this.data)) {
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers) {
                    this.notifyWatcher(watcher, this.data);
                }
            }
        }

        void onAbsent() {
            boolean ignoreResourceDeletionEnabled;
            if (this.respTimer != null && this.respTimer.isPending()) {
                return;
            }
            boolean bl = ignoreResourceDeletionEnabled = this.serverInfo != null && this.serverInfo.ignoreResourceDeletion();
            if (ignoreResourceDeletionEnabled && this.type.isFullStateOfTheWorld() && this.data != null) {
                if (!this.resourceDeletionIgnored) {
                    XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.FORCE_WARNING, "xds server {0}: ignoring deletion for resource type {1} name {2}}", this.serverInfo.target(), this.type, this.resource);
                    this.resourceDeletionIgnored = true;
                }
                return;
            }
            XdsClientImpl.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Conclude {0} resource {1} not exist", this.type, this.resource);
            if (!this.absent) {
                this.data = null;
                this.absent = true;
                this.metadata = XdsClient.ResourceMetadata.newResourceMetadataDoesNotExist();
                for (XdsClient.ResourceWatcher<T> watcher : this.watchers) {
                    watcher.onResourceDoesNotExist(this.resource);
                }
            }
        }

        void onError(Status error) {
            if (this.respTimer != null && this.respTimer.isPending()) {
                this.respTimer.cancel();
                this.respTimer = null;
            }
            String description = error.getDescription() == null ? "" : error.getDescription() + " ";
            Status errorAugmented = Status.fromCode(error.getCode()).withDescription(description + "nodeID: " + XdsClientImpl.this.bootstrapInfo.node().getId()).withCause(error.getCause());
            for (XdsClient.ResourceWatcher<T> watcher : this.watchers) {
                watcher.onError(errorAugmented);
            }
        }

        void onRejected(String rejectedVersion, long rejectedTime, String rejectedDetails) {
            this.metadata = XdsClient.ResourceMetadata.newResourceMetadataNacked(this.metadata, rejectedVersion, rejectedTime, rejectedDetails);
        }

        private void notifyWatcher(XdsClient.ResourceWatcher<T> watcher, T update) {
            watcher.onChanged(update);
        }
    }
}

