/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase.wrappers.veneer;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowControlSettings;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.NoCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.GoogleCredentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.stub.BigtableInstanceAdminStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableBulkReadRowsCallSettings;
import com.google.bigtable.repackaged.com.google.common.base.Joiner;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.base.Strings;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.io.grpc.ManagedChannelBuilder;
import com.google.bigtable.repackaged.io.grpc.internal.GrpcUtil;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import com.google.cloud.bigtable.hbase.BigtableConfiguration;
import com.google.cloud.bigtable.hbase.BigtableExtendedConfiguration;
import com.google.cloud.bigtable.hbase.BigtableHBaseVersion;
import com.google.cloud.bigtable.hbase.wrappers.BigtableHBaseSettings;
import com.google.cloud.bigtable.hbase.wrappers.veneer.metrics.MetricsApiTracerAdapterFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.util.VersionInfo;

@InternalApi(value="For internal usage only")
public class BigtableHBaseVeneerSettings
extends BigtableHBaseSettings {
    private static final String BIGTABLE_BATCH_DATA_HOST_DEFAULT = "batch-bigtable.googleapis.com";
    private static final ClientOperationTimeouts DEFAULT_TIMEOUTS = new ClientOperationTimeouts(new OperationTimeouts(Optional.absent(), Optional.of(Duration.ofSeconds(20L)), Optional.of(Duration.ofMinutes(5L))), new OperationTimeouts(Optional.of(Duration.ofMinutes(5L)), Optional.of(Duration.ofMinutes(10L)), Optional.absent()), new OperationTimeouts(Optional.absent(), Optional.of(Duration.ofMinutes(1L)), Optional.of(Duration.ofMinutes(10L))));
    private static final int MAX_CONSECUTIVE_SCAN_ATTEMPTS = 10;
    private final Configuration configuration;
    private final BigtableDataSettings dataSettings;
    private final BigtableTableAdminSettings tableAdminSettings;
    private final BigtableInstanceAdminSettings instanceAdminSettings;
    private final String dataHost;
    private final String adminHost;
    private final int port;
    private final int bulkMaxRowKeyCount;
    private final long batchingMaxMemory;
    private final boolean isChannelPoolCachingEnabled;
    private final boolean allowRetriesWithoutTimestamp;
    private final ClientOperationTimeouts clientTimeouts;

    public static BigtableHBaseVeneerSettings create(Configuration configuration) throws IOException {
        Configuration copy = new Configuration(configuration);
        if (configuration instanceof BigtableExtendedConfiguration) {
            BigtableExtendedConfiguration extConfig = (BigtableExtendedConfiguration)configuration;
            copy = BigtableConfiguration.withCredentials(copy, extConfig.getCredentials());
        }
        return new BigtableHBaseVeneerSettings(copy);
    }

    private BigtableHBaseVeneerSettings(Configuration configuration) throws IOException {
        super(configuration);
        this.configuration = configuration;
        this.clientTimeouts = this.buildCallSettings();
        this.dataSettings = this.buildBigtableDataSettings(this.clientTimeouts);
        this.tableAdminSettings = this.buildBigtableTableAdminSettings();
        this.instanceAdminSettings = this.buildBigtableInstanceAdminSettings();
        String dataEndpoint = this.dataSettings.getStubSettings().getEndpoint();
        this.dataHost = dataEndpoint.substring(0, dataEndpoint.lastIndexOf(":"));
        String adminEndpoint = this.tableAdminSettings.getStubSettings().getEndpoint();
        this.adminHost = adminEndpoint.substring(0, adminEndpoint.lastIndexOf(":"));
        this.port = Integer.parseInt(dataEndpoint.substring(dataEndpoint.lastIndexOf(":") + 1));
        this.bulkMaxRowKeyCount = this.dataSettings.getStubSettings().bulkMutateRowsSettings().getBatchingSettings().getElementCountThreshold().intValue();
        this.batchingMaxMemory = Objects.requireNonNull(this.dataSettings.getStubSettings().bulkMutateRowsSettings().getBatchingSettings().getFlowControlSettings().getMaxOutstandingRequestBytes());
        boolean batchingModeEnabled = configuration.getBoolean("google.bigtable.use.batch", false);
        this.isChannelPoolCachingEnabled = configuration.getBoolean("google.bigtable.use.cached.data.channel.pool", batchingModeEnabled);
        this.allowRetriesWithoutTimestamp = configuration.getBoolean("google.bigtable.alllow.no.timestamp.retries", false);
    }

    @Override
    public String getDataHost() {
        return this.dataHost;
    }

    @Override
    public String getAdminHost() {
        return this.adminHost;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public int getBulkMaxRowCount() {
        return this.bulkMaxRowKeyCount;
    }

    @Override
    public long getBatchingMaxRequestSize() {
        return this.batchingMaxMemory;
    }

    @Override
    public boolean isRetriesWithoutTimestampAllowed() {
        return this.allowRetriesWithoutTimestamp;
    }

    public ClientOperationTimeouts getClientTimeouts() {
        return this.clientTimeouts;
    }

    public boolean isChannelPoolCachingEnabled() {
        return this.isChannelPoolCachingEnabled;
    }

    public BigtableDataSettings getDataSettings() {
        return this.dataSettings;
    }

    public BigtableTableAdminSettings getTableAdminSettings() {
        return this.tableAdminSettings;
    }

    public BigtableInstanceAdminSettings getInstanceAdminSettings() {
        return this.instanceAdminSettings;
    }

    @Override
    public String toDebugString() {
        return MoreObjects.toStringHelper(this).add("dataSettings", this.dataSettings).add("tableAdminSettings", this.tableAdminSettings).add("instanceAdminSettings", this.instanceAdminSettings).toString();
    }

    @Override
    public Map<String, String> toDebugStrings() {
        return ImmutableMap.of("dataSettings", this.dataSettings.toString(), "tableAdminSettings", this.tableAdminSettings.toString(), "instanceAdminSettings", this.instanceAdminSettings.toString());
    }

    private BigtableDataSettings buildBigtableDataSettings(ClientOperationTimeouts clientTimeouts) throws IOException {
        BigtableDataSettings.Builder dataBuilder;
        Optional<String> emulatorEndpoint = Optional.fromNullable(this.configuration.get("google.bigtable.emulator.endpoint.host"));
        if (emulatorEndpoint.isPresent()) {
            int split = emulatorEndpoint.get().lastIndexOf(58);
            String host = emulatorEndpoint.get().substring(0, split);
            int port = Integer.parseInt(emulatorEndpoint.get().substring(split + 1));
            dataBuilder = BigtableDataSettings.newBuilderForEmulator(host, port);
        } else {
            dataBuilder = BigtableDataSettings.newBuilder();
            this.configureConnection(dataBuilder.stubSettings(), "google.bigtable.endpoint.host");
            this.configureCredentialProvider(dataBuilder.stubSettings());
        }
        this.configureHeaderProvider(dataBuilder.stubSettings());
        dataBuilder.setProjectId(this.getProjectId()).setInstanceId(this.getInstanceId());
        String appProfileId = this.configuration.get("google.bigtable.app_profile.id");
        if (!Strings.isNullOrEmpty(appProfileId)) {
            dataBuilder.setAppProfileId(appProfileId);
        }
        this.configureMetricsBridge(dataBuilder);
        this.configureBulkMutationSettings(dataBuilder.stubSettings().bulkMutateRowsSettings(), clientTimeouts.getBulkMutateTimeouts());
        this.configureBulkReadRowsSettings(dataBuilder.stubSettings().bulkReadRowsSettings(), clientTimeouts.getScanTimeouts());
        this.configureReadRowsSettings(dataBuilder.stubSettings().readRowsSettings(), clientTimeouts.getScanTimeouts());
        this.configureNonRetryableCallSettings(dataBuilder.stubSettings().checkAndMutateRowSettings(), clientTimeouts.getUnaryTimeouts());
        this.configureNonRetryableCallSettings(dataBuilder.stubSettings().readModifyWriteRowSettings(), clientTimeouts.getUnaryTimeouts());
        this.configureRetryableCallSettings(dataBuilder.stubSettings().mutateRowSettings(), clientTimeouts.getUnaryTimeouts());
        this.configureRetryableCallSettings(dataBuilder.stubSettings().readRowSettings(), clientTimeouts.getUnaryTimeouts());
        this.configureRetryableCallSettings(dataBuilder.stubSettings().sampleRowKeysSettings(), clientTimeouts.getUnaryTimeouts());
        return dataBuilder.build();
    }

    private void configureMetricsBridge(BigtableDataSettings.Builder settings) {
        MetricsApiTracerAdapterFactory metricsApiTracerAdapterFactory = new MetricsApiTracerAdapterFactory();
        settings.stubSettings().setTracerFactory(metricsApiTracerAdapterFactory);
    }

    private BigtableTableAdminSettings buildBigtableTableAdminSettings() throws IOException {
        BigtableTableAdminSettings.Builder adminBuilder;
        String emulatorEndpoint = this.configuration.get("google.bigtable.emulator.endpoint.host");
        if (!Strings.isNullOrEmpty(emulatorEndpoint)) {
            int split = emulatorEndpoint.lastIndexOf(58);
            String host = emulatorEndpoint.substring(0, split);
            int port = Integer.parseInt(emulatorEndpoint.substring(split + 1));
            adminBuilder = BigtableTableAdminSettings.newBuilderForEmulator(host, port);
        } else {
            adminBuilder = BigtableTableAdminSettings.newBuilder();
            this.configureConnection(adminBuilder.stubSettings(), "google.bigtable.admin.endpoint.host");
            this.configureCredentialProvider(adminBuilder.stubSettings());
        }
        this.configureHeaderProvider(adminBuilder.stubSettings());
        adminBuilder.setProjectId(this.getProjectId()).setInstanceId(this.getInstanceId());
        return adminBuilder.build();
    }

    private BigtableInstanceAdminSettings buildBigtableInstanceAdminSettings() throws IOException {
        BigtableInstanceAdminSettings.Builder adminBuilder;
        String emulatorEndpoint = this.configuration.get("google.bigtable.emulator.endpoint.host");
        if (!Strings.isNullOrEmpty(emulatorEndpoint)) {
            adminBuilder = BigtableInstanceAdminSettings.newBuilder();
            ((BigtableInstanceAdminStubSettings.Builder)((BigtableInstanceAdminStubSettings.Builder)adminBuilder.stubSettings().setEndpoint(emulatorEndpoint)).setCredentialsProvider(NoCredentialsProvider.create())).setTransportChannelProvider(BigtableInstanceAdminStubSettings.defaultGrpcTransportProviderBuilder().setChannelConfigurator(new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

                @Override
                public ManagedChannelBuilder apply(ManagedChannelBuilder managedChannelBuilder) {
                    return managedChannelBuilder.usePlaintext();
                }
            }).build());
        } else {
            adminBuilder = BigtableInstanceAdminSettings.newBuilder();
            this.configureConnection(adminBuilder.stubSettings(), "google.bigtable.admin.endpoint.host");
            this.configureCredentialProvider(adminBuilder.stubSettings());
        }
        this.configureHeaderProvider(adminBuilder.stubSettings());
        adminBuilder.setProjectId(this.getProjectId());
        return adminBuilder.build();
    }

    private void configureConnection(StubSettings.Builder<?, ?> stubSettings, String endpointKey) {
        String channelCount;
        ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder> prevConfigurator;
        String defaultEndpoint = stubSettings.getEndpoint();
        String defaultHostname = defaultEndpoint.substring(0, defaultEndpoint.lastIndexOf(58));
        String defaultPort = defaultEndpoint.substring(defaultEndpoint.lastIndexOf(58) + 1);
        Optional<String> hostOverride = Optional.fromNullable(this.configuration.get(endpointKey));
        Optional<String> portOverride = Optional.fromNullable(this.configuration.get("google.bigtable.endpoint.port"));
        Optional<Object> endpointOverride = Optional.absent();
        if (hostOverride.isPresent() || portOverride.isPresent()) {
            endpointOverride = Optional.of(hostOverride.or(defaultHostname) + ":" + portOverride.or(defaultPort));
        } else if (endpointKey.equals("google.bigtable.endpoint.host") && defaultEndpoint.equals("bigtable.googleapis.com:443") && this.configuration.getBoolean("google.bigtable.use.batch", false)) {
            endpointOverride = Optional.of("batch-bigtable.googleapis.com:443");
        }
        if (endpointOverride.isPresent()) {
            stubSettings.setEndpoint((String)endpointOverride.get());
            LOG.debug("%s is configured at %s", endpointKey, endpointOverride);
        }
        InstantiatingGrpcChannelProvider.Builder channelProvider = ((InstantiatingGrpcChannelProvider)stubSettings.getTransportChannelProvider()).toBuilder();
        if (this.configuration.getBoolean("google.bigtable.use.plaintext.negotiation", false)) {
            prevConfigurator = channelProvider.getChannelConfigurator();
            channelProvider.setChannelConfigurator(new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

                @Override
                public ManagedChannelBuilder apply(ManagedChannelBuilder channelBuilder) {
                    if (prevConfigurator != null) {
                        channelBuilder = (ManagedChannelBuilder)prevConfigurator.apply(channelBuilder);
                    }
                    return channelBuilder.usePlaintext();
                }
            });
        }
        if (endpointKey.equals("google.bigtable.endpoint.host") && !Strings.isNullOrEmpty(channelCount = this.configuration.get("google.bigtable.grpc.channel.count"))) {
            channelProvider.setPoolSize(Integer.parseInt(channelCount));
        }
        prevConfigurator = channelProvider.getChannelConfigurator();
        channelProvider.setChannelConfigurator(new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            @Override
            public ManagedChannelBuilder apply(ManagedChannelBuilder channelBuilder) {
                if (prevConfigurator != null) {
                    channelBuilder = (ManagedChannelBuilder)prevConfigurator.apply(channelBuilder);
                }
                return channelBuilder.executor(null);
            }
        });
        stubSettings.setTransportChannelProvider(channelProvider.build());
    }

    private void configureHeaderProvider(StubSettings.Builder<?, ?> stubSettings) {
        ImmutableMap.Builder<String, String> headersBuilder = ImmutableMap.builder();
        ArrayList<String> userAgentParts = Lists.newArrayList();
        userAgentParts.add("hbase/" + VersionInfo.getVersion());
        userAgentParts.add("bigtable-hbase/" + BigtableHBaseVersion.getVersion());
        String customUserAgent = this.configuration.get("google.bigtable.custom.user.agent");
        if (customUserAgent != null) {
            userAgentParts.add(customUserAgent);
        }
        String userAgent = Joiner.on(" ").join(userAgentParts);
        headersBuilder.put(GrpcUtil.USER_AGENT_KEY.name(), userAgent);
        String tracingCookie = this.configuration.get("google.bigtable.tracing.cookie.header");
        if (tracingCookie != null) {
            headersBuilder.put("cookie", tracingCookie);
        }
        stubSettings.setHeaderProvider(FixedHeaderProvider.create(headersBuilder.build()));
    }

    private void configureCredentialProvider(StubSettings.Builder<?, ?> stubSettings) throws IOException {
        if (this.configuration instanceof BigtableExtendedConfiguration) {
            Credentials credentials = ((BigtableExtendedConfiguration)this.configuration).getCredentials();
            stubSettings.setCredentialsProvider(FixedCredentialsProvider.create(credentials));
        } else if (Boolean.parseBoolean(this.configuration.get("google.bigtable.auth.null.credential.enable"))) {
            stubSettings.setCredentialsProvider(NoCredentialsProvider.create());
        } else if (!Strings.isNullOrEmpty(this.configuration.get("google.bigtable.auth.json.value"))) {
            String jsonValue = this.configuration.get("google.bigtable.auth.json.value");
            stubSettings.setCredentialsProvider(FixedCredentialsProvider.create(GoogleCredentials.fromStream(new ByteArrayInputStream(jsonValue.getBytes(StandardCharsets.UTF_8)))));
        } else if (!Strings.isNullOrEmpty(this.configuration.get("google.bigtable.auth.json.keyfile"))) {
            String keyFileLocation = this.configuration.get("google.bigtable.auth.json.keyfile");
            stubSettings.setCredentialsProvider(FixedCredentialsProvider.create(GoogleCredentials.fromStream(new FileInputStream(keyFileLocation))));
        } else if (!Strings.isNullOrEmpty(this.configuration.get("google.bigtable.auth.service.account.email"))) {
            String serviceAccount = this.configuration.get("google.bigtable.auth.service.account.email");
            String keyFileLocation = this.configuration.get("google.bigtable.auth.service.account.keyfile");
            Preconditions.checkState(!Strings.isNullOrEmpty(keyFileLocation), "Key file location must be specified when setting service account email");
            stubSettings.setCredentialsProvider(FixedCredentialsProvider.create(this.buildCredentialFromPrivateKey(serviceAccount, keyFileLocation)));
        }
    }

    private Credentials buildCredentialFromPrivateKey(String serviceAccountEmail, String privateKeyFile) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance("PKCS12");
            try (FileInputStream fin = new FileInputStream(privateKeyFile);){
                keyStore.load(fin, "notasecret".toCharArray());
            }
            PrivateKey privateKey = (PrivateKey)keyStore.getKey("privatekey", "notasecret".toCharArray());
            return ServiceAccountJwtAccessCredentials.newBuilder().setClientEmail(serviceAccountEmail).setPrivateKey(privateKey).build();
        }
        catch (GeneralSecurityException exception) {
            throw new RuntimeException("exception while retrieving credentials", exception);
        }
    }

    private void configureBulkMutationSettings(BigtableBatchingCallSettings.Builder builder, OperationTimeouts operationTimeouts) {
        String maxMemory;
        String requestByteThresholdStr;
        String bulkMaxRowKeyCountStr;
        BatchingSettings.Builder batchingSettingsBuilder = builder.getBatchingSettings().toBuilder();
        this.configureRetryableCallSettings(builder, operationTimeouts);
        String autoFlushStr = this.configuration.get("google.bigtable.bulk.autoflush.ms");
        if (!Strings.isNullOrEmpty(autoFlushStr)) {
            long autoFlushMs = Long.parseLong(autoFlushStr);
            if (autoFlushMs == 0L) {
                batchingSettingsBuilder.setDelayThreshold(null);
            } else {
                batchingSettingsBuilder.setDelayThreshold(Duration.ofMillis(autoFlushMs));
            }
        }
        if (!Strings.isNullOrEmpty(bulkMaxRowKeyCountStr = this.configuration.get("google.bigtable.bulk.max.row.key.count"))) {
            batchingSettingsBuilder.setElementCountThreshold(Long.parseLong(bulkMaxRowKeyCountStr));
        }
        if (!Strings.isNullOrEmpty(requestByteThresholdStr = this.configuration.get("google.bigtable.bulk.max.request.size.bytes"))) {
            batchingSettingsBuilder.setRequestByteThreshold(Long.valueOf(requestByteThresholdStr));
        }
        FlowControlSettings.Builder flowControl = builder.getBatchingSettings().getFlowControlSettings().toBuilder();
        String maxInflightRpcStr = this.configuration.get("google.bigtable.buffered.mutator.max.inflight.rpcs");
        if (!Strings.isNullOrEmpty(maxInflightRpcStr)) {
            int maxInflightRpcCount = Integer.parseInt(maxInflightRpcStr);
            long bulkMaxRowKeyCount = Strings.isNullOrEmpty(bulkMaxRowKeyCountStr) ? builder.getBatchingSettings().getElementCountThreshold() : Long.parseLong(bulkMaxRowKeyCountStr);
            long maxInflightElements = (long)maxInflightRpcCount * bulkMaxRowKeyCount;
            flowControl.setMaxOutstandingElementCount(maxInflightElements);
        }
        if (!Strings.isNullOrEmpty(maxMemory = this.configuration.get("google.bigtable.buffered.mutator.max.memory"))) {
            flowControl.setMaxOutstandingRequestBytes(Long.valueOf(maxMemory));
        }
        batchingSettingsBuilder.setFlowControlSettings(flowControl.build());
        builder.setBatchingSettings(batchingSettingsBuilder.build());
        if (Boolean.parseBoolean(this.configuration.get("google.bigtable.buffered.mutator.throttling.enable"))) {
            int latencyMs = this.configuration.getInt("google.bigtable.buffered.mutator.throttling.threshold.ms", 100);
            builder.enableLatencyBasedThrottling(latencyMs);
        }
    }

    private void configureBulkReadRowsSettings(BigtableBulkReadRowsCallSettings.Builder builder, OperationTimeouts operationTimeouts) {
        BatchingSettings.Builder bulkReadBatchingBuilder = builder.getBatchingSettings().toBuilder();
        this.configureRetryableCallSettings(builder, operationTimeouts);
        String bulkMaxRowKeyCountStr = this.configuration.get("google.bigtable.bulk.max.row.key.count");
        if (!Strings.isNullOrEmpty(bulkMaxRowKeyCountStr)) {
            bulkReadBatchingBuilder.setElementCountThreshold(Long.parseLong(bulkMaxRowKeyCountStr));
        }
        builder.setBatchingSettings(bulkReadBatchingBuilder.build());
    }

    private void configureReadRowsSettings(ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings, OperationTimeouts operationTimeouts) {
        if (!this.configuration.getBoolean("google.bigtable.grpc.retry.enable", true)) {
            readRowsSettings.setRetryableCodes(Collections.emptySet());
        } else {
            readRowsSettings.setRetryableCodes(this.extractRetryCodesFromConfig(readRowsSettings.getRetryableCodes()));
            String initialElapsedBackoffMsStr = this.configuration.get("google.bigtable.grpc.retry.initial.elapsed.backoff.ms");
            if (!Strings.isNullOrEmpty(initialElapsedBackoffMsStr)) {
                long initialElapsedBackoffMs = Long.parseLong(initialElapsedBackoffMsStr);
                readRowsSettings.retrySettings().setInitialRetryDelay(Duration.ofMillis(initialElapsedBackoffMs));
                if (initialElapsedBackoffMs > readRowsSettings.retrySettings().getMaxRetryDelay().toMillis()) {
                    readRowsSettings.retrySettings().setMaxRetryDelay(Duration.ofMillis(initialElapsedBackoffMs));
                }
            }
            readRowsSettings.retrySettings().setMaxAttempts(this.configuration.getInt("google.bigtable.grpc.retry.max.scan.timeout.retries", 10));
        }
        if (operationTimeouts.getResponseTimeout().isPresent()) {
            readRowsSettings.retrySettings().setInitialRpcTimeout(operationTimeouts.getResponseTimeout().get()).setMaxRpcTimeout(operationTimeouts.getResponseTimeout().get());
        }
        if (operationTimeouts.getOperationTimeout().isPresent()) {
            readRowsSettings.retrySettings().setTotalTimeout(operationTimeouts.getOperationTimeout().get());
        }
    }

    private void configureRetryableCallSettings(UnaryCallSettings.Builder<?, ?> unaryCallSettings, OperationTimeouts operationTimeouts) {
        Optional<Duration> effectiveAttemptTimeout;
        if (!this.configuration.getBoolean("google.bigtable.grpc.retry.enable", true)) {
            this.configureNonRetryableCallSettings(unaryCallSettings, operationTimeouts);
            return;
        }
        unaryCallSettings.setRetryableCodes(this.extractRetryCodesFromConfig(unaryCallSettings.getRetryableCodes()));
        String initialElapsedBackoffMsStr = this.configuration.get("google.bigtable.grpc.retry.initial.elapsed.backoff.ms");
        if (!Strings.isNullOrEmpty(initialElapsedBackoffMsStr)) {
            long initialElapsedBackoffMs = Long.parseLong(initialElapsedBackoffMsStr);
            unaryCallSettings.retrySettings().setInitialRetryDelay(Duration.ofMillis(initialElapsedBackoffMs));
            if (initialElapsedBackoffMs > unaryCallSettings.retrySettings().getMaxRetryDelay().toMillis()) {
                unaryCallSettings.retrySettings().setMaxRetryDelay(Duration.ofMillis(initialElapsedBackoffMs));
            }
        }
        if (operationTimeouts.getOperationTimeout().isPresent()) {
            unaryCallSettings.retrySettings().setTotalTimeout(operationTimeouts.getOperationTimeout().get());
        }
        if ((effectiveAttemptTimeout = operationTimeouts.getAttemptTimeout().or(operationTimeouts.getOperationTimeout())).isPresent()) {
            unaryCallSettings.retrySettings().setInitialRpcTimeout(effectiveAttemptTimeout.get());
            unaryCallSettings.retrySettings().setMaxRpcTimeout(effectiveAttemptTimeout.get());
        }
    }

    private void configureNonRetryableCallSettings(UnaryCallSettings.Builder<?, ?> unaryCallSettings, OperationTimeouts operationTimeouts) {
        unaryCallSettings.setRetryableCodes(Collections.emptySet());
        if (operationTimeouts.getOperationTimeout().isPresent()) {
            unaryCallSettings.retrySettings().setLogicalTimeout(operationTimeouts.getOperationTimeout().get());
        }
    }

    private ClientOperationTimeouts buildCallSettings() {
        Optional<Duration> defaultBatchMutateOverallTimeout = DEFAULT_TIMEOUTS.bulkMutateTimeouts.operationTimeout;
        if (this.configuration.getBoolean("google.bigtable.use.batch", false)) {
            defaultBatchMutateOverallTimeout = Optional.of(Duration.ofMinutes(20L));
        }
        OperationTimeouts bulkMutateTimeouts = new OperationTimeouts(DEFAULT_TIMEOUTS.bulkMutateTimeouts.responseTimeout, this.extractDuration("google.bigtable.mutate.rpc.attempt.timeout.ms").or(DEFAULT_TIMEOUTS.bulkMutateTimeouts.attemptTimeout), this.extractDuration("google.bigtable.mutate.rpc.timeout.ms", "google.bigtable.long.rpc.timeout.ms").or(defaultBatchMutateOverallTimeout));
        OperationTimeouts scanTimeouts = new OperationTimeouts(this.extractDuration("google.bigtable.grpc.read.partial.row.timeout.ms").or(DEFAULT_TIMEOUTS.scanTimeouts.responseTimeout), this.extractDuration("google.bigtable.read.rpc.attempt.timeout.ms").or(DEFAULT_TIMEOUTS.scanTimeouts.attemptTimeout), this.extractDuration("google.bigtable.read.rpc.timeout.ms", "google.bigtable.long.rpc.timeout.ms").or(DEFAULT_TIMEOUTS.scanTimeouts.operationTimeout));
        OperationTimeouts unaryTimeouts = new OperationTimeouts(DEFAULT_TIMEOUTS.unaryTimeouts.responseTimeout, this.extractDuration("google.bigtable.rpc.attempt.timeout.ms").or(DEFAULT_TIMEOUTS.unaryTimeouts.attemptTimeout), this.extractDuration("google.bigtable.rpc.timeout.ms", "google.bigtable.grpc.retry.max.elapsed.backoff.ms").or(DEFAULT_TIMEOUTS.unaryTimeouts.operationTimeout));
        return new ClientOperationTimeouts(unaryTimeouts, scanTimeouts, bulkMutateTimeouts);
    }

    private Optional<Duration> extractDuration(String ... keys) {
        for (String key : keys) {
            String timeoutStr = this.configuration.get(key);
            if (Strings.isNullOrEmpty(timeoutStr)) continue;
            return Optional.of(Duration.ofMillis(Long.parseLong(timeoutStr)));
        }
        return Optional.absent();
    }

    private Set<StatusCode.Code> extractRetryCodesFromConfig(Set<StatusCode.Code> defaultCodes) {
        HashSet<StatusCode.Code> codes = new HashSet<StatusCode.Code>(defaultCodes);
        String retryCodes = this.configuration.get("google.bigtable.grpc.retry.codes", "");
        for (String stringCode : retryCodes.split(",")) {
            String trimmed = stringCode.trim();
            if (trimmed.isEmpty()) continue;
            StatusCode.Code code = StatusCode.Code.valueOf(trimmed);
            Preconditions.checkNotNull(code, String.format("Unknown status code %s found", stringCode));
            codes.add(code);
        }
        String enableDeadlineRetry = this.configuration.get("google.bigtable.grpc.retry.deadlineexceeded.enable");
        if (!Strings.isNullOrEmpty(enableDeadlineRetry)) {
            if (Boolean.parseBoolean(enableDeadlineRetry)) {
                codes.add(StatusCode.Code.DEADLINE_EXCEEDED);
            } else {
                codes.remove((Object)StatusCode.Code.DEADLINE_EXCEEDED);
            }
        }
        return codes;
    }

    static class OperationTimeouts {
        static final OperationTimeouts EMPTY = new OperationTimeouts(Optional.absent(), Optional.absent(), Optional.absent());
        private final Optional<Duration> responseTimeout;
        private final Optional<Duration> attemptTimeout;
        private final Optional<Duration> operationTimeout;

        public OperationTimeouts(Optional<Duration> responseTimeout, Optional<Duration> attemptTimeout, Optional<Duration> operationTimeout) {
            this.responseTimeout = responseTimeout;
            this.attemptTimeout = attemptTimeout;
            this.operationTimeout = operationTimeout;
        }

        public Optional<Duration> getResponseTimeout() {
            return this.responseTimeout;
        }

        public Optional<Duration> getAttemptTimeout() {
            return this.attemptTimeout;
        }

        public Optional<Duration> getOperationTimeout() {
            return this.operationTimeout;
        }
    }

    static class ClientOperationTimeouts {
        static final ClientOperationTimeouts EMPTY = new ClientOperationTimeouts(OperationTimeouts.EMPTY, OperationTimeouts.EMPTY, OperationTimeouts.EMPTY);
        private final OperationTimeouts unaryTimeouts;
        private final OperationTimeouts scanTimeouts;
        private final OperationTimeouts bulkMutateTimeouts;

        public ClientOperationTimeouts(OperationTimeouts unaryTimeouts, OperationTimeouts scanTimeouts, OperationTimeouts bulkMutateTimeouts) {
            this.unaryTimeouts = unaryTimeouts;
            this.scanTimeouts = scanTimeouts;
            this.bulkMutateTimeouts = bulkMutateTimeouts;
        }

        public OperationTimeouts getUnaryTimeouts() {
            return this.unaryTimeouts;
        }

        public OperationTimeouts getScanTimeouts() {
            return this.scanTimeouts;
        }

        public OperationTimeouts getBulkMutateTimeouts() {
            return this.bulkMutateTimeouts;
        }
    }
}

