/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Batcher;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatcherImpl;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowController;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.CredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcRawCallableFactory;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ExponentialRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.ScheduledRetryingExecutor;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.OpencensusTracerFactory;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.auth.oauth2.ServiceAccountJwtAccessCredentials;
import com.google.bigtable.repackaged.com.google.bigtable.v2.BigtableGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.GenerateInitialChangeStreamPartitionsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.PingAndWarmResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.JwtCredentialsWithAudience;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultChangeStreamRecordAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.DefaultRowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadChangeStreamQuery;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.CheckAndMutateRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.ConvertExceptionCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.DynamicFlowControlStats;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.MutateRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.ReadModifyWriteRowCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.SampleRowKeysCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ChangeStreamRecordMergingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.GenerateInitialChangeStreamPartitionsUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamResumptionStrategy;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.changestream.ReadChangeStreamUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BigtableTracerUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.CompositeTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.MetricsTracerFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcMeasureConstants;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.StatsHeadersServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.StatsHeadersUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.TracedBatcherUnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.BulkMutateRowsUserFacingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsRetryingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.FilterMarkerRowsCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsFirstCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsResumptionStrategy;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsRetryCompletedCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsUserCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.RowMergingCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.gaxx.retrying.ApiResultRetryAlgorithm;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.io.opencensus.stats.Stats;
import com.google.bigtable.repackaged.io.opencensus.stats.StatsRecorder;
import com.google.bigtable.repackaged.io.opencensus.tags.TagKey;
import com.google.bigtable.repackaged.io.opencensus.tags.TagValue;
import com.google.bigtable.repackaged.io.opencensus.tags.Tagger;
import com.google.bigtable.repackaged.io.opencensus.tags.Tags;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class EnhancedBigtableStub
implements AutoCloseable {
    private static final String CLIENT_NAME = "Bigtable";
    private static final long FLOW_CONTROL_ADJUSTING_INTERVAL_MS = TimeUnit.SECONDS.toMillis(20L);
    private final EnhancedBigtableStubSettings settings;
    private final ClientContext clientContext;
    private final RequestContext requestContext;
    private final FlowController bulkMutationFlowController;
    private final DynamicFlowControlStats bulkMutationDynamicFlowControlStats;
    private final ServerStreamingCallable<Query, Row> readRowsCallable;
    private final UnaryCallable<Query, Row> readRowCallable;
    private final UnaryCallable<Query, List<Row>> bulkReadRowsCallable;
    private final UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable;
    private final UnaryCallable<RowMutation, Void> mutateRowCallable;
    private final UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable;
    private final UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable;
    private final UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable;
    private final ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable;
    private final ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable;

    public static EnhancedBigtableStub create(EnhancedBigtableStubSettings settings) throws IOException {
        settings = EnhancedBigtableStub.finalizeSettings(settings, Tags.getTagger(), Stats.getStatsRecorder());
        return new EnhancedBigtableStub(settings, ClientContext.create(settings));
    }

    public static EnhancedBigtableStubSettings finalizeSettings(EnhancedBigtableStubSettings settings, Tagger tagger, StatsRecorder stats) throws IOException {
        EnhancedBigtableStubSettings.Builder builder = settings.toBuilder();
        EnhancedBigtableStub.patchCredentials(builder);
        if (settings.isRefreshingChannel()) {
            Credentials credentials = null;
            if (builder.getCredentialsProvider() != null) {
                credentials = builder.getCredentialsProvider().getCredentials();
            }
            builder.setCredentialsProvider(FixedCredentialsProvider.create(credentials));
            InstantiatingGrpcChannelProvider transportProvider = (InstantiatingGrpcChannelProvider)settings.getTransportChannelProvider();
            builder.setTransportChannelProvider(transportProvider.toBuilder().setChannelPrimer(BigtableChannelPrimer.create(credentials, settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId())).build());
        }
        ImmutableMap<TagKey, TagValue> attributes = ImmutableMap.builder().put(RpcMeasureConstants.BIGTABLE_PROJECT_ID, TagValue.create(settings.getProjectId())).put(RpcMeasureConstants.BIGTABLE_INSTANCE_ID, TagValue.create(settings.getInstanceId())).put(RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID, TagValue.create(settings.getAppProfileId())).build();
        ImmutableMap<String, String> builtinAttributes = ImmutableMap.builder().put("project_id", settings.getProjectId()).put("instance", settings.getInstanceId()).put("app_profile", settings.getAppProfileId()).build();
        builder.setTracerFactory(new CompositeTracerFactory(ImmutableList.of(new OpencensusTracerFactory(ImmutableMap.builder().put(RpcMeasureConstants.BIGTABLE_PROJECT_ID.getName(), settings.getProjectId()).put(RpcMeasureConstants.BIGTABLE_INSTANCE_ID.getName(), settings.getInstanceId()).put(RpcMeasureConstants.BIGTABLE_APP_PROFILE_ID.getName(), settings.getAppProfileId()).put("gax", GaxGrpcProperties.getGaxGrpcVersion()).put("grpc", GaxGrpcProperties.getGrpcVersion()).put("gapic", Version.VERSION).build()), MetricsTracerFactory.create(tagger, stats, attributes), BuiltinMetricsTracerFactory.create(builtinAttributes), settings.getTracerFactory())));
        return builder.build();
    }

    private static void patchCredentials(EnhancedBigtableStubSettings.Builder settings) throws IOException {
        int i = settings.getEndpoint().lastIndexOf(":");
        String host = settings.getEndpoint().substring(0, i);
        String audience = settings.getJwtAudienceMapping().get(host);
        if (audience == null) {
            return;
        }
        URI audienceUri = null;
        try {
            audienceUri = new URI(audience);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("invalid JWT audience override", e);
        }
        CredentialsProvider credentialsProvider = settings.getCredentialsProvider();
        if (credentialsProvider == null) {
            return;
        }
        Credentials credentials = credentialsProvider.getCredentials();
        if (credentials == null) {
            return;
        }
        if (!(credentials instanceof ServiceAccountJwtAccessCredentials)) {
            return;
        }
        ServiceAccountJwtAccessCredentials jwtCreds = (ServiceAccountJwtAccessCredentials)credentials;
        JwtCredentialsWithAudience patchedCreds = new JwtCredentialsWithAudience(jwtCreds, audienceUri);
        settings.setCredentialsProvider(FixedCredentialsProvider.create(patchedCreds));
    }

    public EnhancedBigtableStub(EnhancedBigtableStubSettings settings, ClientContext clientContext) {
        this.settings = settings;
        this.clientContext = clientContext;
        this.requestContext = RequestContext.create(settings.getProjectId(), settings.getInstanceId(), settings.getAppProfileId());
        this.bulkMutationFlowController = new FlowController(settings.bulkMutateRowsSettings().getDynamicFlowControlSettings());
        this.bulkMutationDynamicFlowControlStats = new DynamicFlowControlStats();
        this.readRowsCallable = this.createReadRowsCallable(new DefaultRowAdapter());
        this.readRowCallable = this.createReadRowCallable(new DefaultRowAdapter());
        this.bulkReadRowsCallable = this.createBulkReadRowsCallable(new DefaultRowAdapter());
        this.sampleRowKeysCallable = this.createSampleRowKeysCallable();
        this.mutateRowCallable = this.createMutateRowCallable();
        this.bulkMutateRowsCallable = this.createBulkMutateRowsCallable();
        this.checkAndMutateRowCallable = this.createCheckAndMutateRowCallable();
        this.readModifyWriteRowCallable = this.createReadModifyWriteRowCallable();
        this.generateInitialChangeStreamPartitionsCallable = this.createGenerateInitialChangeStreamPartitionsCallable();
        this.readChangeStreamCallable = this.createReadChangeStreamCallable(new DefaultChangeStreamRecordAdapter());
        this.pingAndWarmCallable = this.createPingAndWarmCallable();
    }

    @BetaApi(value="This surface is stable yet it might be removed in the future.")
    public <RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsRawCallable(RowAdapter<RowT> rowAdapter) {
        return this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter).withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> ServerStreamingCallable<Query, RowT> createReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readRowsUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <RowT> UnaryCallable<Query, RowT> createReadRowCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable((ServerStreamingCallSettings)ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.readRowSettings().getRetryableCodes()).setRetrySettings(this.settings.readRowSettings().getRetrySettings()).setIdleTimeout(this.settings.readRowSettings().getRetrySettings().getTotalTimeout()).build(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        ReadRowsFirstCallable firstRow = new ReadRowsFirstCallable(readRowCallable);
        TracedUnaryCallable traced = new TracedUnaryCallable(firstRow, this.clientContext.getTracerFactory(), this.getSpanName("ReadRow"));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <ReqT, RowT> ServerStreamingCallable<ReadRowsRequest, RowT> createReadRowsBaseCallable(ServerStreamingCallSettings<ReqT, Row> readRowsSettings, RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadRowsMethod()).setParamsExtractor(new RequestParamsExtractor<ReadRowsRequest>(){

            @Override
            public Map<String, String> extract(ReadRowsRequest readRowsRequest) {
                return ImmutableMap.of("table_name", readRowsRequest.getTableName(), "app_profile_id", readRowsRequest.getAppProfileId());
            }
        }).build(), readRowsSettings.getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse> convertException = new ConvertExceptionCallable<ReadRowsRequest, ReadRowsResponse>(withStatsHeaders);
        RowMergingCallable<RowT> merging = new RowMergingCallable<RowT>(convertException, rowAdapter);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadRowsResumptionStrategy<RowT>(rowAdapter)).setRetryableCodes(readRowsSettings.getRetryableCodes()).setRetrySettings(readRowsSettings.getRetrySettings()).setIdleTimeout(readRowsSettings.getIdleTimeout()).build();
        ServerStreamingCallable watched = Callables.watched(merging, innerSettings, this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ReadRowsRetryCompletedCallable retrying1 = new ReadRowsRetryCompletedCallable(withBigtableTracer);
        ServerStreamingCallable retrying2 = Callables.retrying(retrying1, innerSettings, this.clientContext);
        return new FilterMarkerRowsCallable(retrying2, rowAdapter);
    }

    private <RowT> UnaryCallable<Query, List<RowT>> createBulkReadRowsCallable(RowAdapter<RowT> rowAdapter) {
        ServerStreamingCallable<ReadRowsRequest, RowT> readRowsCallable = this.createReadRowsBaseCallable(this.settings.readRowsSettings(), rowAdapter);
        ReadRowsUserCallable<RowT> readRowsUserCallable = new ReadRowsUserCallable<RowT>(readRowsCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadRows");
        TracedBatcherUnaryCallable tracedBatcher = new TracedBatcherUnaryCallable(readRowsUserCallable.all());
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(tracedBatcher);
        TracedUnaryCallable traced = new TracedUnaryCallable(withBigtableTracer, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<String, List<KeyOffset>> createSampleRowKeysCallable() {
        String methodName = "SampleRowKeys";
        ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getSampleRowKeysMethod()).setParamsExtractor(new RequestParamsExtractor<SampleRowKeysRequest>(){

            @Override
            public Map<String, String> extract(SampleRowKeysRequest sampleRowKeysRequest) {
                return ImmutableMap.of("table_name", sampleRowKeysRequest.getTableName(), "app_profile_id", sampleRowKeysRequest.getAppProfileId());
            }
        }).build(), this.settings.sampleRowKeysSettings().getRetryableCodes());
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> spoolable = base.all();
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(spoolable);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<SampleRowKeysRequest, List<SampleRowKeysResponse>> retryable = Callables.retrying(withBigtableTracer, this.settings.sampleRowKeysSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new SampleRowKeysCallable(retryable, this.requestContext));
    }

    private UnaryCallable<RowMutation, Void> createMutateRowCallable() {
        String methodName = "MutateRow";
        UnaryCallable<MutateRowRequest, MutateRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowMethod()).setParamsExtractor(new RequestParamsExtractor<MutateRowRequest>(){

            @Override
            public Map<String, String> extract(MutateRowRequest mutateRowRequest) {
                return ImmutableMap.of("table_name", mutateRowRequest.getTableName(), "app_profile_id", mutateRowRequest.getAppProfileId());
            }
        }).build(), this.settings.mutateRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<MutateRowRequest, MutateRowResponse> retrying = Callables.retrying(withBigtableTracer, this.settings.mutateRowSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new MutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<BulkMutation, Void> createBulkMutateRowsCallable() {
        DynamicFlowControlCallable baseCallable = this.createMutateRowsBaseCallable();
        DynamicFlowControlCallable flowControlCallable = null;
        if (this.settings.bulkMutateRowsSettings().isLatencyBasedThrottlingEnabled()) {
            flowControlCallable = new DynamicFlowControlCallable(baseCallable, this.bulkMutationFlowController, this.bulkMutationDynamicFlowControlStats, this.settings.bulkMutateRowsSettings().getTargetRpcLatencyMs(), FLOW_CONTROL_ADJUSTING_INTERVAL_MS);
        }
        BulkMutateRowsUserFacingCallable userFacing = new BulkMutateRowsUserFacingCallable(flowControlCallable != null ? flowControlCallable : baseCallable, this.requestContext);
        SpanName spanName = this.getSpanName("MutateRows");
        TracedBatcherUnaryCallable tracedBatcherUnaryCallable = new TracedBatcherUnaryCallable(userFacing);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(tracedBatcherUnaryCallable);
        TracedUnaryCallable traced = new TracedUnaryCallable(withBigtableTracer, this.clientContext.getTracerFactory(), spanName);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public Batcher<RowMutationEntry, Void> newMutateRowsBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        return new BatcherImpl<RowMutationEntry, Void, BulkMutation, Void>(this.settings.bulkMutateRowsSettings().getBatchingDescriptor(), this.bulkMutateRowsCallable, BulkMutation.create(tableId), this.settings.bulkMutateRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), this.bulkMutationFlowController, MoreObjects.firstNonNull(ctx, this.clientContext.getDefaultCallContext()));
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(@Nonnull Query query, @Nullable GrpcCallContext ctx) {
        Preconditions.checkNotNull(query, "query cannot be null");
        return new BatcherImpl<ByteString, Row, Query, List<Row>>(this.settings.bulkReadRowsSettings().getBatchingDescriptor(), this.bulkReadRowsCallable, query, this.settings.bulkReadRowsSettings().getBatchingSettings(), this.clientContext.getExecutor(), null, MoreObjects.firstNonNull(ctx, this.clientContext.getDefaultCallContext()));
    }

    private UnaryCallable<MutateRowsRequest, Void> createMutateRowsBaseCallable() {
        ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getMutateRowsMethod()).setParamsExtractor(new RequestParamsExtractor<MutateRowsRequest>(){

            @Override
            public Map<String, String> extract(MutateRowsRequest mutateRowsRequest) {
                return ImmutableMap.of("table_name", mutateRowsRequest.getTableName(), "app_profile_id", mutateRowsRequest.getAppProfileId());
            }
        }).build(), this.settings.bulkMutateRowsSettings().getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<MutateRowsRequest, MutateRowsResponse> convertException = new ConvertExceptionCallable<MutateRowsRequest, MutateRowsResponse>(withStatsHeaders);
        RetryAlgorithm retryAlgorithm = new RetryAlgorithm(new ApiResultRetryAlgorithm(), (TimedRetryAlgorithm)new ExponentialRetryAlgorithm(this.settings.bulkMutateRowsSettings().getRetrySettings(), this.clientContext.getClock()));
        ScheduledRetryingExecutor<Void> retryingExecutor = new ScheduledRetryingExecutor<Void>(retryAlgorithm, this.clientContext.getExecutor());
        return new MutateRowsRetryingCallable(this.clientContext.getDefaultCallContext(), convertException, retryingExecutor, this.settings.bulkMutateRowsSettings().getRetryableCodes());
    }

    private UnaryCallable<ConditionalRowMutation, Boolean> createCheckAndMutateRowCallable() {
        String methodName = "CheckAndMutateRow";
        UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getCheckAndMutateRowMethod()).setParamsExtractor(new RequestParamsExtractor<CheckAndMutateRowRequest>(){

            @Override
            public Map<String, String> extract(CheckAndMutateRowRequest checkAndMutateRowRequest) {
                return ImmutableMap.of("table_name", checkAndMutateRowRequest.getTableName(), "app_profile_id", checkAndMutateRowRequest.getAppProfileId());
            }
        }).build(), this.settings.checkAndMutateRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> retrying = Callables.retrying(withBigtableTracer, this.settings.checkAndMutateRowSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new CheckAndMutateRowCallable(retrying, this.requestContext));
    }

    private UnaryCallable<ReadModifyWriteRow, Row> createReadModifyWriteRowCallable() {
        UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> base = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadModifyWriteRowMethod()).setParamsExtractor(new RequestParamsExtractor<ReadModifyWriteRowRequest>(){

            @Override
            public Map<String, String> extract(ReadModifyWriteRowRequest request) {
                return ImmutableMap.of("table_name", request.getTableName(), "app_profile_id", request.getAppProfileId());
            }
        }).build(), this.settings.readModifyWriteRowSettings().getRetryableCodes());
        StatsHeadersUnaryCallable withStatsHeaders = new StatsHeadersUnaryCallable(base);
        String methodName = "ReadModifyWriteRow";
        BigtableTracerUnaryCallable withBigtableTracer = new BigtableTracerUnaryCallable(withStatsHeaders);
        UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> retrying = Callables.retrying(withBigtableTracer, this.settings.readModifyWriteRowSettings(), this.clientContext);
        return this.createUserFacingUnaryCallable(methodName, new ReadModifyWriteRowCallable(retrying, this.requestContext));
    }

    private ServerStreamingCallable<String, Range.ByteStringRange> createGenerateInitialChangeStreamPartitionsCallable() {
        ServerStreamingCallable<GenerateInitialChangeStreamPartitionsRequest, GenerateInitialChangeStreamPartitionsResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getGenerateInitialChangeStreamPartitionsMethod()).setParamsExtractor(new RequestParamsExtractor<GenerateInitialChangeStreamPartitionsRequest>(){

            @Override
            public Map<String, String> extract(GenerateInitialChangeStreamPartitionsRequest generateInitialChangeStreamPartitionsRequest) {
                return ImmutableMap.of("table_name", generateInitialChangeStreamPartitionsRequest.getTableName(), "app_profile_id", generateInitialChangeStreamPartitionsRequest.getAppProfileId());
            }
        }).build(), this.settings.generateInitialChangeStreamPartitionsSettings().getRetryableCodes());
        GenerateInitialChangeStreamPartitionsUserCallable userCallable = new GenerateInitialChangeStreamPartitionsUserCallable(base, this.requestContext);
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(userCallable);
        ConvertExceptionCallable convertException = new ConvertExceptionCallable(withStatsHeaders);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setRetryableCodes(this.settings.generateInitialChangeStreamPartitionsSettings().getRetryableCodes()).setRetrySettings(this.settings.generateInitialChangeStreamPartitionsSettings().getRetrySettings()).setIdleTimeout(this.settings.generateInitialChangeStreamPartitionsSettings().getIdleTimeout()).build();
        ServerStreamingCallable watched = Callables.watched(convertException, innerSettings, this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ServerStreamingCallable retrying = Callables.retrying(withBigtableTracer, innerSettings, this.clientContext);
        SpanName span = this.getSpanName("GenerateInitialChangeStreamPartitions");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(retrying, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public <ChangeStreamRecordT> ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecordT> createReadChangeStreamCallable(ChangeStreamRecordAdapter<ChangeStreamRecordT> changeStreamRecordAdapter) {
        ServerStreamingCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> base = GrpcRawCallableFactory.createServerStreamingCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getReadChangeStreamMethod()).setParamsExtractor(new RequestParamsExtractor<ReadChangeStreamRequest>(){

            @Override
            public Map<String, String> extract(ReadChangeStreamRequest readChangeStreamRequest) {
                return ImmutableMap.of("table_name", readChangeStreamRequest.getTableName(), "app_profile_id", readChangeStreamRequest.getAppProfileId());
            }
        }).build(), this.settings.readChangeStreamSettings().getRetryableCodes());
        StatsHeadersServerStreamingCallable withStatsHeaders = new StatsHeadersServerStreamingCallable(base);
        ConvertExceptionCallable<ReadChangeStreamRequest, ReadChangeStreamResponse> convertException = new ConvertExceptionCallable<ReadChangeStreamRequest, ReadChangeStreamResponse>(withStatsHeaders);
        ChangeStreamRecordMergingCallable<ChangeStreamRecordT> merging = new ChangeStreamRecordMergingCallable<ChangeStreamRecordT>(convertException, changeStreamRecordAdapter);
        StreamingCallSettings innerSettings = ServerStreamingCallSettings.newBuilder().setResumptionStrategy(new ReadChangeStreamResumptionStrategy<ChangeStreamRecordT>(changeStreamRecordAdapter)).setRetryableCodes(this.settings.readChangeStreamSettings().getRetryableCodes()).setRetrySettings(this.settings.readChangeStreamSettings().getRetrySettings()).setIdleTimeout(this.settings.readChangeStreamSettings().getIdleTimeout()).build();
        ServerStreamingCallable watched = Callables.watched(merging, innerSettings, this.clientContext);
        BigtableTracerStreamingCallable withBigtableTracer = new BigtableTracerStreamingCallable(watched);
        ServerStreamingCallable readChangeStreamCallable = Callables.retrying(withBigtableTracer, innerSettings, this.clientContext);
        ReadChangeStreamUserCallable readChangeStreamUserCallable = new ReadChangeStreamUserCallable(readChangeStreamCallable, this.requestContext);
        SpanName span = this.getSpanName("ReadChangeStream");
        TracedServerStreamingCallable traced = new TracedServerStreamingCallable(readChangeStreamUserCallable, this.clientContext.getTracerFactory(), span);
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUserFacingUnaryCallable(String methodName, UnaryCallable<RequestT, ResponseT> inner) {
        TracedUnaryCallable<RequestT, ResponseT> traced = new TracedUnaryCallable<RequestT, ResponseT>(inner, this.clientContext.getTracerFactory(), this.getSpanName(methodName));
        return traced.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    private UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> createPingAndWarmCallable() {
        UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarm = GrpcRawCallableFactory.createUnaryCallable(GrpcCallSettings.newBuilder().setMethodDescriptor(BigtableGrpc.getPingAndWarmMethod()).setParamsExtractor(new RequestParamsExtractor<PingAndWarmRequest>(){

            @Override
            public Map<String, String> extract(PingAndWarmRequest request) {
                return ImmutableMap.of("name", request.getName(), "app_profile_id", request.getAppProfileId());
            }
        }).build(), Collections.emptySet());
        return pingAndWarm.withDefaultCallContext(this.clientContext.getDefaultCallContext());
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.readRowsCallable;
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.readRowCallable;
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    public UnaryCallable<BulkMutation, Void> bulkMutateRowsCallable() {
        return this.bulkMutateRowsCallable;
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    public ServerStreamingCallable<String, Range.ByteStringRange> generateInitialChangeStreamPartitionsCallable() {
        return this.generateInitialChangeStreamPartitionsCallable;
    }

    public ServerStreamingCallable<ReadChangeStreamQuery, ChangeStreamRecord> readChangeStreamCallable() {
        return this.readChangeStreamCallable;
    }

    UnaryCallable<PingAndWarmRequest, PingAndWarmResponse> pingAndWarmCallable() {
        return this.pingAndWarmCallable;
    }

    private SpanName getSpanName(String methodName) {
        return SpanName.of(CLIENT_NAME, methodName);
    }

    @Override
    public void close() {
        for (BackgroundResource backgroundResource : this.clientContext.getBackgroundResources()) {
            try {
                backgroundResource.close();
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to close resource", e);
            }
        }
    }
}

