/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase1_x;

import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.cloud.bigtable.grpc.BigtableSnapshotName;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.common.util.concurrent.Futures;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.ProcedureInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableAdmin;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;

public class BigtableAdmin
extends AbstractBigtableAdmin {
    public BigtableAdmin(AbstractBigtableConnection connection) throws IOException {
        super(connection);
    }

    public MasterProtos.SnapshotResponse takeSnapshotAsync(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException {
        this.snapshotTable(snapshot.getName(), TableName.valueOf((String)snapshot.getTable()));
        this.LOG.warn("isSnapshotFinished() is not currently supported by BigtableAdmin.\nYou may poll for existence of the snapshot with listSnapshots(snpashotName)", new Object[0]);
        return MasterProtos.SnapshotResponse.newBuilder().setExpectedTimeout(TimeUnit.MINUTES.toMillis(5L)).build();
    }

    public void disableTableAsync(TableName tableName) throws IOException {
        this.disableTable(tableName);
    }

    public void enableTableAsync(TableName tableName) throws IOException {
        this.enableTable(tableName);
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getCompactionState");
    }

    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionStateForRegion(byte[] bytes) throws IOException {
        throw new UnsupportedOperationException("getCompactionStateForRegion");
    }

    public void snapshot(String snapshotName, TableName tableName, HBaseProtos.SnapshotDescription.Type type) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshotName, tableName);
    }

    public void snapshot(HBaseProtos.SnapshotDescription snapshot) throws IOException, SnapshotCreationException, IllegalArgumentException {
        this.snapshot(snapshot.getName(), TableName.valueOf((String)snapshot.getTable()));
    }

    public boolean isSnapshotFinished(HBaseProtos.SnapshotDescription snapshot) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        throw new UnsupportedOperationException("isSnapshotFinished");
    }

    public void restoreSnapshot(String s, boolean b, boolean b1) throws IOException, RestoreSnapshotException {
    }

    public void cloneSnapshot(String s, TableName tableName, boolean b) throws IOException, TableExistsException, RestoreSnapshotException {
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots() throws IOException {
        ListSnapshotsRequest request = ListSnapshotsRequest.newBuilder().setParent(this.getSnapshotClusterName().toString()).build();
        ListSnapshotsResponse snapshotList = (ListSnapshotsResponse)Futures.getChecked((Future)this.bigtableTableAdminClient.listSnapshotsAsync(request), IOException.class);
        ArrayList<HBaseProtos.SnapshotDescription> response = new ArrayList<HBaseProtos.SnapshotDescription>();
        for (Snapshot snapshot : snapshotList.getSnapshotsList()) {
            BigtableSnapshotName snapshotName = new BigtableSnapshotName(snapshot.getName());
            BigtableTableName tableName = new BigtableTableName(snapshot.getSourceTable().getName());
            response.add(HBaseProtos.SnapshotDescription.newBuilder().setName(snapshotName.getSnapshotId()).setTable(tableName.getTableId()).setCreationTime(TimeUnit.SECONDS.toMillis(snapshot.getCreateTime().getSeconds())).build());
        }
        return response;
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    public List<HBaseProtos.SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        ArrayList<HBaseProtos.SnapshotDescription> response = new ArrayList<HBaseProtos.SnapshotDescription>();
        for (HBaseProtos.SnapshotDescription description : this.listSnapshots()) {
            if (!pattern.matcher(description.getName()).matches()) continue;
            response.add(description);
        }
        return response;
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        return this.listTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    public List<HBaseProtos.SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        ArrayList<HBaseProtos.SnapshotDescription> response = new ArrayList<HBaseProtos.SnapshotDescription>();
        for (HBaseProtos.SnapshotDescription snapshotDescription : this.listSnapshots(snapshotNamePattern)) {
            if (!tableNamePattern.matcher(snapshotDescription.getTable()).matches()) continue;
            response.add(snapshotDescription);
        }
        return response;
    }

    public boolean isBalancerEnabled() throws IOException {
        throw new UnsupportedOperationException("isBalancerEnabled");
    }

    public long getLastMajorCompactionTimestamp(TableName tableName) throws IOException {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestamp");
    }

    public long getLastMajorCompactionTimestampForRegion(byte[] regionName) throws IOException {
        throw new UnsupportedOperationException("getLastMajorCompactionTimestampForRegion");
    }

    public void setQuota(QuotaSettings quota) throws IOException {
        throw new UnsupportedOperationException("setQuota");
    }

    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        throw new UnsupportedOperationException("getQuotaRetriever");
    }

    public boolean normalize() throws IOException {
        throw new UnsupportedOperationException("normalize");
    }

    public boolean isNormalizerEnabled() throws IOException {
        throw new UnsupportedOperationException("isNormalizerEnabled");
    }

    public boolean setNormalizerRunning(boolean on) throws IOException {
        throw new UnsupportedOperationException("setNormalizerRunning");
    }

    public boolean setCleanerChoreRunning(boolean b) throws IOException {
        throw new UnsupportedOperationException("setCleanerChoreRunning");
    }

    public boolean runCleanerChore() throws IOException {
        throw new UnsupportedOperationException("runCleanerChore");
    }

    public boolean isCleanerChoreEnabled() throws IOException {
        throw new UnsupportedOperationException("isCleanerChoreEnabled");
    }

    public boolean isMasterInMaintenanceMode() throws IOException {
        throw new UnsupportedOperationException("isMasterInMaintenanceMode");
    }

    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        throw new UnsupportedOperationException("abortProcedure");
    }

    public ProcedureInfo[] listProcedures() throws IOException {
        throw new UnsupportedOperationException("listProcedures");
    }

    public Future<Boolean> abortProcedureAsync(long procId, boolean mayInterruptIfRunning) throws IOException {
        throw new UnsupportedOperationException("abortProcedureAsync");
    }

    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        throw new UnsupportedOperationException("getSecurityCapabilities");
    }

    public boolean balancer(boolean arg0) throws IOException {
        throw new UnsupportedOperationException("balancer");
    }

    public boolean isSplitOrMergeEnabled(Admin.MasterSwitchType arg0) throws IOException {
        throw new UnsupportedOperationException("isSplitOrMergeEnabled");
    }

    public List<ServerName> listDeadServers() throws IOException {
        throw new UnsupportedOperationException("listDeadServers");
    }

    public List<ServerName> clearDeadServers(List<ServerName> list) throws IOException {
        throw new UnsupportedOperationException("clearDeadServers");
    }

    public boolean[] setSplitOrMergeEnabled(boolean arg0, boolean arg1, Admin.MasterSwitchType ... arg2) throws IOException {
        throw new UnsupportedOperationException("setSplitOrMergeEnabled");
    }
}

