/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.hbase1_x;

import com.google.cloud.bigtable.hbase.AbstractBigtableTable;
import com.google.cloud.bigtable.hbase.adapters.SampledRowKeysAdapter;
import com.google.cloud.bigtable.hbase1_x.BigtableAdmin;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AbstractBigtableConnection;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.security.User;

public class BigtableConnection
extends AbstractBigtableConnection {
    public BigtableConnection(Configuration conf) throws IOException {
        super(conf);
    }

    BigtableConnection(Configuration conf, boolean managed, ExecutorService pool, User user) throws IOException {
        super(conf, managed, pool, user);
    }

    public Admin getAdmin() throws IOException {
        return new BigtableAdmin(this);
    }

    protected SampledRowKeysAdapter createSampledRowKeysAdapter(TableName tableName, ServerName serverName) {
        return new SampledRowKeysAdapter(tableName, serverName){

            protected HRegionLocation createRegionLocation(byte[] startKey, byte[] endKey) {
                HRegionInfo hRegionInfo = new HRegionInfo(this.tableName, startKey, endKey);
                return new HRegionLocation(hRegionInfo, this.serverName);
            }
        };
    }

    public Table getTable(TableName tableName, ExecutorService ignored) throws IOException {
        return new AbstractBigtableTable(this, this.createAdapter(tableName)){};
    }
}

