/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.grpc;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.CallOptionsUtil;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.ResponseMetadataHandler;
import com.google.bigtable.repackaged.io.grpc.CallOptions;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.ClientCall;
import com.google.bigtable.repackaged.io.grpc.ClientInterceptor;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCall;
import com.google.bigtable.repackaged.io.grpc.ForwardingClientCallListener;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.Status;

@InternalApi
class GrpcMetadataHandlerInterceptor
implements ClientInterceptor {
    GrpcMetadataHandlerInterceptor() {
    }

    @Override
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        ClientCall<ReqT, RespT> call = next.newCall(method, callOptions);
        final ResponseMetadataHandler metadataHandler = CallOptionsUtil.getMetadataHandlerOption(callOptions);
        if (metadataHandler == null) {
            return call;
        }
        return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

            @Override
            public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                ForwardingClientCallListener.SimpleForwardingClientCallListener forwardingResponseListener = new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                    @Override
                    public void onHeaders(Metadata headers) {
                        super.onHeaders(headers);
                        metadataHandler.onHeaders(headers);
                    }

                    @Override
                    public void onClose(Status status, Metadata trailers) {
                        super.onClose(status, trailers);
                        metadataHandler.onTrailers(trailers);
                    }
                };
                super.start(forwardingResponseListener, headers);
            }
        };
    }
}

