/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.client.http.HttpTransport;
import com.google.bigtable.repackaged.com.google.api.client.json.JsonFactory;
import com.google.bigtable.repackaged.com.google.api.core.SettableApiFuture;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonHeaderEnhancer;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpRequestRunnable;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import java.util.List;

final class AutoValue_HttpRequestRunnable<RequestT, ResponseT>
extends HttpRequestRunnable<RequestT, ResponseT> {
    private final HttpJsonCallOptions httpJsonCallOptions;
    private final RequestT request;
    private final ApiMethodDescriptor<RequestT, ResponseT> apiMethodDescriptor;
    private final HttpTransport httpTransport;
    private final String endpoint;
    private final JsonFactory jsonFactory;
    private final ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers;
    private final SettableApiFuture<ResponseT> responseFuture;

    private AutoValue_HttpRequestRunnable(HttpJsonCallOptions httpJsonCallOptions, RequestT request, ApiMethodDescriptor<RequestT, ResponseT> apiMethodDescriptor, HttpTransport httpTransport, String endpoint, JsonFactory jsonFactory, ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers, SettableApiFuture<ResponseT> responseFuture) {
        this.httpJsonCallOptions = httpJsonCallOptions;
        this.request = request;
        this.apiMethodDescriptor = apiMethodDescriptor;
        this.httpTransport = httpTransport;
        this.endpoint = endpoint;
        this.jsonFactory = jsonFactory;
        this.headerEnhancers = headerEnhancers;
        this.responseFuture = responseFuture;
    }

    @Override
    HttpJsonCallOptions getHttpJsonCallOptions() {
        return this.httpJsonCallOptions;
    }

    @Override
    RequestT getRequest() {
        return this.request;
    }

    @Override
    ApiMethodDescriptor<RequestT, ResponseT> getApiMethodDescriptor() {
        return this.apiMethodDescriptor;
    }

    @Override
    HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    @Override
    String getEndpoint() {
        return this.endpoint;
    }

    @Override
    JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    @Override
    ImmutableList<HttpJsonHeaderEnhancer> getHeaderEnhancers() {
        return this.headerEnhancers;
    }

    @Override
    SettableApiFuture<ResponseT> getResponseFuture() {
        return this.responseFuture;
    }

    public String toString() {
        return "HttpRequestRunnable{httpJsonCallOptions=" + this.httpJsonCallOptions + ", request=" + this.request + ", apiMethodDescriptor=" + this.apiMethodDescriptor + ", httpTransport=" + this.httpTransport + ", endpoint=" + this.endpoint + ", jsonFactory=" + this.jsonFactory + ", headerEnhancers=" + this.headerEnhancers + ", responseFuture=" + this.responseFuture + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpRequestRunnable) {
            HttpRequestRunnable that = (HttpRequestRunnable)o;
            return this.httpJsonCallOptions.equals(that.getHttpJsonCallOptions()) && this.request.equals(that.getRequest()) && this.apiMethodDescriptor.equals(that.getApiMethodDescriptor()) && this.httpTransport.equals(that.getHttpTransport()) && this.endpoint.equals(that.getEndpoint()) && this.jsonFactory.equals(that.getJsonFactory()) && this.headerEnhancers.equals(that.getHeaderEnhancers()) && this.responseFuture.equals(that.getResponseFuture());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.httpJsonCallOptions.hashCode();
        h$ *= 1000003;
        h$ ^= this.request.hashCode();
        h$ *= 1000003;
        h$ ^= this.apiMethodDescriptor.hashCode();
        h$ *= 1000003;
        h$ ^= this.httpTransport.hashCode();
        h$ *= 1000003;
        h$ ^= this.endpoint.hashCode();
        h$ *= 1000003;
        h$ ^= this.jsonFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.headerEnhancers.hashCode();
        h$ *= 1000003;
        return h$ ^= this.responseFuture.hashCode();
    }

    static final class Builder<RequestT, ResponseT>
    extends HttpRequestRunnable.Builder<RequestT, ResponseT> {
        private HttpJsonCallOptions httpJsonCallOptions;
        private RequestT request;
        private ApiMethodDescriptor<RequestT, ResponseT> apiMethodDescriptor;
        private HttpTransport httpTransport;
        private String endpoint;
        private JsonFactory jsonFactory;
        private ImmutableList<HttpJsonHeaderEnhancer> headerEnhancers;
        private SettableApiFuture<ResponseT> responseFuture;

        Builder() {
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setHttpJsonCallOptions(HttpJsonCallOptions httpJsonCallOptions) {
            if (httpJsonCallOptions == null) {
                throw new NullPointerException("Null httpJsonCallOptions");
            }
            this.httpJsonCallOptions = httpJsonCallOptions;
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setRequest(RequestT request) {
            if (request == null) {
                throw new NullPointerException("Null request");
            }
            this.request = request;
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setApiMethodDescriptor(ApiMethodDescriptor<RequestT, ResponseT> apiMethodDescriptor) {
            if (apiMethodDescriptor == null) {
                throw new NullPointerException("Null apiMethodDescriptor");
            }
            this.apiMethodDescriptor = apiMethodDescriptor;
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setHttpTransport(HttpTransport httpTransport) {
            if (httpTransport == null) {
                throw new NullPointerException("Null httpTransport");
            }
            this.httpTransport = httpTransport;
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setEndpoint(String endpoint) {
            if (endpoint == null) {
                throw new NullPointerException("Null endpoint");
            }
            this.endpoint = endpoint;
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setJsonFactory(JsonFactory jsonFactory) {
            if (jsonFactory == null) {
                throw new NullPointerException("Null jsonFactory");
            }
            this.jsonFactory = jsonFactory;
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setHeaderEnhancers(List<HttpJsonHeaderEnhancer> headerEnhancers) {
            this.headerEnhancers = ImmutableList.copyOf(headerEnhancers);
            return this;
        }

        @Override
        HttpRequestRunnable.Builder<RequestT, ResponseT> setResponseFuture(SettableApiFuture<ResponseT> responseFuture) {
            if (responseFuture == null) {
                throw new NullPointerException("Null responseFuture");
            }
            this.responseFuture = responseFuture;
            return this;
        }

        @Override
        HttpRequestRunnable<RequestT, ResponseT> build() {
            if (this.httpJsonCallOptions == null || this.request == null || this.apiMethodDescriptor == null || this.httpTransport == null || this.endpoint == null || this.jsonFactory == null || this.headerEnhancers == null || this.responseFuture == null) {
                StringBuilder missing = new StringBuilder();
                if (this.httpJsonCallOptions == null) {
                    missing.append(" httpJsonCallOptions");
                }
                if (this.request == null) {
                    missing.append(" request");
                }
                if (this.apiMethodDescriptor == null) {
                    missing.append(" apiMethodDescriptor");
                }
                if (this.httpTransport == null) {
                    missing.append(" httpTransport");
                }
                if (this.endpoint == null) {
                    missing.append(" endpoint");
                }
                if (this.jsonFactory == null) {
                    missing.append(" jsonFactory");
                }
                if (this.headerEnhancers == null) {
                    missing.append(" headerEnhancers");
                }
                if (this.responseFuture == null) {
                    missing.append(" responseFuture");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_HttpRequestRunnable(this.httpJsonCallOptions, this.request, this.apiMethodDescriptor, this.httpTransport, this.endpoint, this.jsonFactory, this.headerEnhancers, this.responseFuture);
        }
    }
}

