/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonDirectCallable;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonExceptionCallable;
import com.google.bigtable.repackaged.com.google.api.gax.longrunning.OperationSnapshot;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.BatchingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.Callables;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.LongRunningClient;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.OperationCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.OperationCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.PagedCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.SpanName;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.TracedUnaryCallable;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@BetaApi
public class HttpJsonCallableFactory {
    private static final Pattern FULL_METHOD_NAME_REGEX = Pattern.compile("^(.+)\\.(.+)$");

    private HttpJsonCallableFactory() {
    }

    private static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createDirectUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings) {
        return new HttpJsonDirectCallable<RequestT, ResponseT>(httpJsonCallSettings.getMethodDescriptor(), httpJsonCallSettings.getTypeRegistry());
    }

    static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable callable = new HttpJsonExceptionCallable<RequestT, ResponseT>(innerCallable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBaseUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<?, ?> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = new HttpJsonExceptionCallable<RequestT, ResponseT>(callable, callSettings.getRetryableCodes());
        callable = Callables.retrying(callable, callSettings, clientContext);
        return callable;
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createUnaryCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, UnaryCallSettings<RequestT, ResponseT> callSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> innerCallable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        innerCallable = new TracedUnaryCallable<RequestT, ResponseT>(innerCallable, clientContext.getTracerFactory(), HttpJsonCallableFactory.getSpanName(httpJsonCallSettings.getMethodDescriptor()));
        return HttpJsonCallableFactory.createUnaryCallable(innerCallable, callSettings, clientContext);
    }

    public static <RequestT, ResponseT, PagedListResponseT> UnaryCallable<RequestT, PagedListResponseT> createPagedCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, PagedCallSettings<RequestT, ResponseT, PagedListResponseT> pagedCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, pagedCallSettings, clientContext);
        UnaryCallable<RequestT, PagedListResponseT> pagedCallable = Callables.paged(callable, pagedCallSettings);
        return pagedCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    public static <RequestT, ResponseT> UnaryCallable<RequestT, ResponseT> createBatchingCallable(HttpJsonCallSettings<RequestT, ResponseT> httpJsonCallSettings, BatchingCallSettings<RequestT, ResponseT> batchingCallSettings, ClientContext clientContext) {
        UnaryCallable<RequestT, ResponseT> callable = HttpJsonCallableFactory.createDirectUnaryCallable(httpJsonCallSettings);
        callable = HttpJsonCallableFactory.createUnaryCallable(callable, batchingCallSettings, clientContext);
        callable = Callables.batching(callable, batchingCallSettings, clientContext);
        return callable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public static <RequestT, ResponseT, MetadataT> OperationCallable<RequestT, ResponseT, MetadataT> createOperationCallable(OperationCallSettings<RequestT, ResponseT, MetadataT> operationCallSettings, ClientContext clientContext, LongRunningClient longRunningClient, UnaryCallable<RequestT, OperationSnapshot> operationSnapshotCallable) {
        OperationCallable<RequestT, ResponseT, MetadataT> operationCallable = Callables.longRunningOperation(operationSnapshotCallable, operationCallSettings, clientContext, longRunningClient);
        return operationCallable.withDefaultCallContext(clientContext.getDefaultCallContext());
    }

    @InternalApi(value="Visible for testing")
    static SpanName getSpanName(@Nonnull ApiMethodDescriptor<?, ?> methodDescriptor) {
        Matcher matcher = FULL_METHOD_NAME_REGEX.matcher(methodDescriptor.getFullMethodName());
        Preconditions.checkArgument(matcher.matches(), "Invalid fullMethodName");
        return SpanName.of(matcher.group(1), matcher.group(2));
    }
}

