/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.api.gax.httpjson;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.httpjson.HttpJsonCallOptions;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.TypeRegistry;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;

class HttpJsonDirectCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final ApiMethodDescriptor<RequestT, ResponseT> descriptor;
    private final TypeRegistry typeRegistry;

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor) {
        this(descriptor, null);
    }

    HttpJsonDirectCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor, TypeRegistry typeRegistry) {
        this.descriptor = descriptor;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request, ApiCallContext inputContext) {
        Preconditions.checkNotNull(request);
        HttpJsonCallContext context = HttpJsonCallContext.createDefault().nullToSelf(inputContext);
        Instant deadline = context.getDeadline();
        if (context.getTimeout() != null) {
            Instant newDeadline = Instant.now().plus(context.getTimeout());
            if (deadline == null || newDeadline.isBefore(deadline)) {
                deadline = newDeadline;
            }
        }
        HttpJsonCallOptions callOptions = HttpJsonCallOptions.newBuilder().setDeadline(deadline).setCredentials(context.getCredentials()).setTypeRegistry(this.typeRegistry).build();
        return context.getChannel().issueFutureUnaryCall(callOptions, request, this.descriptor);
    }

    public String toString() {
        return String.format("direct(%s)", this.descriptor);
    }
}

