/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Objects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.Timestamps;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.org.threeten.bp.Instant;

public final class UpdateBackupRequest {
    private final UpdateBackupRequest.Builder requestBuilder = com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest.newBuilder();
    private final String backupId;
    private final String clusterId;

    public static UpdateBackupRequest of(String clusterId, String backupId) {
        UpdateBackupRequest request = new UpdateBackupRequest(clusterId, backupId);
        return request;
    }

    private UpdateBackupRequest(String clusterId, String backupId) {
        Preconditions.checkNotNull(clusterId);
        Preconditions.checkNotNull(backupId);
        this.backupId = backupId;
        this.clusterId = clusterId;
    }

    public UpdateBackupRequest setExpireTime(Instant expireTime) {
        Preconditions.checkNotNull(expireTime);
        this.requestBuilder.getBackupBuilder().setExpireTime(Timestamps.fromMillis(expireTime.toEpochMilli()));
        this.requestBuilder.setUpdateMask(FieldMask.newBuilder().addPaths("expire_time"));
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateBackupRequest that = (UpdateBackupRequest)o;
        return Objects.equal(this.requestBuilder.getBackupBuilder().getExpireTime(), that.requestBuilder.getBackupBuilder().getExpireTime()) && Objects.equal(this.requestBuilder.getUpdateMask(), that.requestBuilder.getUpdateMask()) && Objects.equal(this.clusterId, that.clusterId) && Objects.equal(this.backupId, that.backupId);
    }

    public int hashCode() {
        return Objects.hashCode(this.requestBuilder.getBackupBuilder().getExpireTime(), this.requestBuilder.getUpdateMask(), this.backupId);
    }

    @InternalApi
    public com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest toProto(@Nonnull String projectId, @Nonnull String instanceId) {
        Preconditions.checkNotNull(projectId);
        Preconditions.checkNotNull(instanceId);
        this.requestBuilder.getBackupBuilder().setName(NameUtil.formatBackupName(projectId, instanceId, this.clusterId, this.backupId));
        return this.requestBuilder.build();
    }
}

