/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Instance;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.PartialUpdateInstanceRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.admin.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.FieldMask;
import com.google.bigtable.repackaged.com.google.protobuf.util.FieldMaskUtil;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.util.Map;

public class UpdateInstanceRequest {
    private final String instanceId;
    private final PartialUpdateInstanceRequest.Builder builder = PartialUpdateInstanceRequest.newBuilder();

    public static UpdateInstanceRequest of(@Nonnull String instanceId) {
        return new UpdateInstanceRequest(instanceId);
    }

    private UpdateInstanceRequest(@Nonnull String instanceId) {
        Preconditions.checkNotNull(instanceId, "instanceId can't be null");
        this.instanceId = instanceId;
    }

    public UpdateInstanceRequest setDisplayName(@Nonnull String displayName) {
        Preconditions.checkNotNull(displayName);
        this.builder.getInstanceBuilder().setDisplayName(displayName);
        this.updateFieldMask(2);
        return this;
    }

    public UpdateInstanceRequest setProductionType() {
        this.builder.getInstanceBuilder().setType(Instance.Type.PRODUCTION);
        this.updateFieldMask(4);
        return this;
    }

    public UpdateInstanceRequest setAllLabels(@Nonnull Map<String, String> labels) {
        Preconditions.checkNotNull(labels, "labels can't be null");
        this.builder.getInstanceBuilder().clearLabels();
        this.builder.getInstanceBuilder().putAllLabels(labels);
        this.updateFieldMask(5);
        return this;
    }

    private void updateFieldMask(int fieldNumber) {
        FieldMask newMask = FieldMaskUtil.fromFieldNumbers(Instance.class, fieldNumber);
        this.builder.setUpdateMask(FieldMaskUtil.union(this.builder.getUpdateMask(), newMask, new FieldMask[0]));
    }

    @InternalApi
    public PartialUpdateInstanceRequest toProto(String projectId) {
        Preconditions.checkState(!this.builder.getUpdateMask().getPathsList().isEmpty(), "Update request is empty");
        this.builder.getInstanceBuilder().setName(NameUtil.formatInstanceName(projectId, this.instanceId));
        return this.builder.build();
    }
}

