/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@InternalApi
public class NameUtil {
    private static final Pattern TABLE_PATTERN = Pattern.compile("projects/([^/]+)/instances/([^/]+)/tables/([^/]+)");

    public static String formatInstanceName(@Nonnull String projectId, @Nonnull String instanceId) {
        return "projects/" + projectId + "/instances/" + instanceId;
    }

    public static String formatTableName(@Nonnull String projectId, @Nonnull String instanceId, @Nonnull String tableId) {
        return NameUtil.formatInstanceName(projectId, instanceId) + "/tables/" + tableId;
    }

    public static String extractTableIdFromTableName(@Nonnull String fullTableName) {
        Matcher matcher = TABLE_PATTERN.matcher(fullTableName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid table name: " + fullTableName);
        }
        return matcher.group(3);
    }
}

