/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.auto.value.AutoValue;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowRange;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.AutoValue_RowSetUtil_Split;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Range;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ComparisonChain;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSortedSet;
import com.google.bigtable.repackaged.com.google.common.collect.Lists;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;

@InternalApi
public final class RowSetUtil {
    private static final Comparator<RowRange> RANGE_START_COMPARATOR = new Comparator<RowRange>(){

        @Override
        public int compare(@Nonnull RowRange o1, @Nonnull RowRange o2) {
            return StartPoint.extract(o1).compareTo(StartPoint.extract(o2));
        }
    };

    private RowSetUtil() {
    }

    @Nonnull
    public static Split split(@Nonnull RowSet rowSet, @Nonnull ByteString splitPoint) {
        ImmutableSet splitPoints = ((ImmutableSortedSet.Builder)ImmutableSortedSet.orderedBy(ByteStringComparator.INSTANCE).add((Object)splitPoint)).build();
        List<RowSet> splits = RowSetUtil.split(rowSet, (SortedSet<ByteString>)((Object)splitPoints), true);
        return Split.of(splits.get(0), splits.get(1));
    }

    @Nonnull
    public static List<RowSet> shard(@Nonnull RowSet rowSet, @Nonnull SortedSet<ByteString> splitPoints) {
        return RowSetUtil.split(rowSet, splitPoints, false);
    }

    @Nonnull
    static List<RowSet> split(@Nonnull RowSet rowSet, @Nonnull SortedSet<ByteString> splitPoints, boolean preserveNullSegments) {
        int i;
        if (RowSet.getDefaultInstance().equals(rowSet)) {
            rowSet = RowSet.newBuilder().addRowRanges(RowRange.getDefaultInstance()).build();
        }
        ByteString[] rowKeys = rowSet.getRowKeysList().toArray(new ByteString[rowSet.getRowKeysCount()]);
        RowRange[] rowRanges = rowSet.getRowRangesList().toArray(new RowRange[rowSet.getRowRangesCount()]);
        Arrays.sort(rowKeys, ByteStringComparator.INSTANCE);
        Arrays.sort(rowRanges, RANGE_START_COMPARATOR);
        ArrayList<RowSet> results = Lists.newArrayList();
        int rowKeysStart = 0;
        int rowRangesStart = 0;
        RowSet.Builder segment = RowSet.newBuilder();
        boolean isSegmentEmpty = true;
        for (ByteString splitPoint : splitPoints) {
            RowRange rowRange;
            int startCmp;
            ByteString rowKey;
            int i2;
            Preconditions.checkState(!splitPoint.isEmpty(), "Split point can't be empty");
            for (i2 = rowKeysStart; i2 < rowKeys.length && ByteStringComparator.INSTANCE.compare(rowKey = rowKeys[i2], splitPoint) <= 0; ++i2) {
                segment.addRowKeys(rowKey);
                isSegmentEmpty = false;
                ++rowKeysStart;
            }
            for (i2 = rowRangesStart; i2 < rowRanges.length && (startCmp = StartPoint.extract(rowRange = rowRanges[i2]).compareTo(new StartPoint(splitPoint, true))) <= 0; ++i2) {
                RowRange rightSubRange;
                isSegmentEmpty = false;
                int endCmp = EndPoint.extract(rowRange).compareTo(new EndPoint(splitPoint, true));
                if (endCmp <= 0) {
                    segment.addRowRanges(rowRange);
                    System.arraycopy(rowRanges, rowRangesStart, rowRanges, rowRangesStart + 1, i2 - rowRangesStart);
                    ++rowRangesStart;
                    continue;
                }
                RowRange leftSubRange = rowRange.toBuilder().setEndKeyClosed(splitPoint).build();
                segment.addRowRanges(leftSubRange);
                rowRanges[i2] = rightSubRange = rowRange.toBuilder().setStartKeyOpen(splitPoint).build();
            }
            if (!isSegmentEmpty) {
                results.add(segment.build());
                isSegmentEmpty = true;
                segment = RowSet.newBuilder();
                continue;
            }
            if (!preserveNullSegments) continue;
            results.add(null);
        }
        for (i = rowKeysStart; i < rowKeys.length; ++i) {
            isSegmentEmpty = false;
            segment.addRowKeys(rowKeys[i]);
        }
        for (i = rowRangesStart; i < rowRanges.length; ++i) {
            isSegmentEmpty = false;
            segment.addRowRanges(rowRanges[i]);
        }
        if (!isSegmentEmpty) {
            results.add(segment.build());
        } else if (preserveNullSegments) {
            results.add(null);
        }
        return results;
    }

    public static Range.ByteStringRange getBound(RowSet rowSet) {
        ByteString minKey = null;
        ByteString maxKey = null;
        for (ByteString key : rowSet.getRowKeysList()) {
            if (minKey == null || ByteStringComparator.INSTANCE.compare(minKey, key) > 0) {
                minKey = key;
            }
            if (maxKey != null && ByteStringComparator.INSTANCE.compare(maxKey, key) >= 0) continue;
            maxKey = key;
        }
        StartPoint minStartPoint = null;
        EndPoint maxEndPoint = null;
        if (minKey != null) {
            minStartPoint = new StartPoint(minKey, true);
        }
        if (maxKey != null) {
            maxEndPoint = new EndPoint(maxKey, true);
        }
        for (RowRange rowRange : rowSet.getRowRangesList()) {
            StartPoint currentStartPoint = StartPoint.extract(rowRange);
            if (minStartPoint == null || minStartPoint.compareTo(currentStartPoint) > 0) {
                minStartPoint = currentStartPoint;
            }
            EndPoint currentEndpoint = EndPoint.extract(rowRange);
            if (maxEndPoint != null && maxEndPoint.compareTo(currentEndpoint) >= 0) continue;
            maxEndPoint = currentEndpoint;
        }
        Range.ByteStringRange boundingRange = Range.ByteStringRange.unbounded();
        if (minStartPoint != null) {
            if (minStartPoint.isClosed) {
                boundingRange.startClosed(minStartPoint.value);
            } else {
                boundingRange.startOpen(minStartPoint.value);
            }
        }
        if (maxEndPoint != null) {
            if (maxEndPoint.isClosed) {
                boundingRange.endClosed(maxEndPoint.value);
            } else {
                boundingRange.endOpen(maxEndPoint.value);
            }
        }
        return boundingRange;
    }

    private static final class EndPoint
    implements Comparable<EndPoint> {
        private final ByteString value;
        private final boolean isClosed;

        @Nonnull
        static EndPoint extract(@Nonnull RowRange rowRange) {
            switch (rowRange.getEndKeyCase()) {
                case ENDKEY_NOT_SET: {
                    return new EndPoint(ByteString.EMPTY, true);
                }
                case END_KEY_CLOSED: {
                    return new EndPoint(rowRange.getEndKeyClosed(), true);
                }
                case END_KEY_OPEN: {
                    if (rowRange.getEndKeyOpen().isEmpty()) {
                        return new EndPoint(ByteString.EMPTY, true);
                    }
                    return new EndPoint(rowRange.getEndKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown endKeyCase: " + rowRange.getEndKeyCase());
        }

        EndPoint(@Nonnull ByteString value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        public int compareTo(@Nonnull EndPoint o) {
            return ComparisonChain.start().compareFalseFirst(this.value.isEmpty(), o.value.isEmpty()).compare(this.value, o.value, ByteStringComparator.INSTANCE).compareFalseFirst(this.isClosed, o.isClosed).result();
        }
    }

    private static final class StartPoint
    implements Comparable<StartPoint> {
        private final ByteString value;
        private final boolean isClosed;

        @Nonnull
        static StartPoint extract(@Nonnull RowRange rowRange) {
            switch (rowRange.getStartKeyCase()) {
                case STARTKEY_NOT_SET: {
                    return new StartPoint(ByteString.EMPTY, true);
                }
                case START_KEY_CLOSED: {
                    return new StartPoint(rowRange.getStartKeyClosed(), true);
                }
                case START_KEY_OPEN: {
                    if (rowRange.getStartKeyOpen().isEmpty()) {
                        return new StartPoint(ByteString.EMPTY, true);
                    }
                    return new StartPoint(rowRange.getStartKeyOpen(), false);
                }
            }
            throw new IllegalArgumentException("Unknown startKeyCase: " + rowRange.getStartKeyCase());
        }

        StartPoint(@Nonnull ByteString value, boolean isClosed) {
            this.value = value;
            this.isClosed = isClosed;
        }

        @Override
        public int compareTo(@Nonnull StartPoint o) {
            return ComparisonChain.start().compareTrueFirst(this.value.isEmpty(), o.value.isEmpty()).compare(this.value, o.value, ByteStringComparator.INSTANCE).compareTrueFirst(this.isClosed, o.isClosed).result();
        }
    }

    @InternalApi
    @AutoValue
    public static abstract class Split {
        @Nullable
        public abstract RowSet getLeft();

        @Nullable
        public abstract RowSet getRight();

        public static Split of(RowSet left, RowSet right) {
            return new AutoValue_RowSetUtil_Split(left, right);
        }
    }
}

