/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRule;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Validations;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ReadModifyWriteRow
implements Serializable {
    private static final long serialVersionUID = -8150045424541029193L;
    private final String tableId;
    private transient ReadModifyWriteRowRequest.Builder builder = ReadModifyWriteRowRequest.newBuilder();

    private ReadModifyWriteRow(@Nonnull String tableId, @Nonnull ByteString key) {
        Preconditions.checkNotNull(tableId, "tableId can't be null.");
        Preconditions.checkNotNull(key, "key can't be null.");
        this.tableId = tableId;
        this.builder.setRowKey(key);
    }

    public static ReadModifyWriteRow create(@Nonnull String tableId, @Nonnull String key) {
        Preconditions.checkNotNull(key, "key can't be null.");
        return new ReadModifyWriteRow(tableId, ByteString.copyFromUtf8(key));
    }

    public static ReadModifyWriteRow create(@Nonnull String tableId, @Nonnull ByteString key) {
        return new ReadModifyWriteRow(tableId, key);
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.builder = (ReadModifyWriteRowRequest.Builder)ReadModifyWriteRowRequest.newBuilder().mergeFrom(input);
    }

    private void writeObject(ObjectOutputStream output) throws IOException {
        output.defaultWriteObject();
        this.builder.build().writeTo(output);
    }

    public ReadModifyWriteRow append(@Nonnull String familyName, @Nonnull String qualifier, @Nonnull String value) {
        return this.append(familyName, ByteString.copyFromUtf8(qualifier), ByteString.copyFromUtf8(value));
    }

    public ReadModifyWriteRow append(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull ByteString value) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull(qualifier, "Qualifier can't be null");
        Preconditions.checkNotNull(value, "Value can't be null");
        Preconditions.checkArgument(!value.isEmpty(), "Value can't be empty");
        ReadModifyWriteRule rule = ReadModifyWriteRule.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setAppendValue(value).build();
        this.builder.addRules(rule);
        return this;
    }

    public ReadModifyWriteRow increment(@Nonnull String familyName, @Nonnull String qualifier, long amount) {
        return this.increment(familyName, ByteString.copyFromUtf8(qualifier), amount);
    }

    public ReadModifyWriteRow increment(@Nonnull String familyName, @Nonnull ByteString qualifier, long amount) {
        Validations.validateFamily(familyName);
        Preconditions.checkNotNull(qualifier, "Qualifier can't be null");
        ReadModifyWriteRule rule = ReadModifyWriteRule.newBuilder().setFamilyName(familyName).setColumnQualifier(qualifier).setIncrementAmount(amount).build();
        this.builder.addRules(rule);
        return this;
    }

    @InternalApi
    public ReadModifyWriteRowRequest toProto(RequestContext requestContext) {
        String tableName = NameUtil.formatTableName(requestContext.getProjectId(), requestContext.getInstanceId(), this.tableId);
        return this.builder.setTableName(tableName).setAppProfileId(requestContext.getAppProfileId()).build();
    }

    @BetaApi
    public static ReadModifyWriteRow fromProto(@Nonnull ReadModifyWriteRowRequest request) {
        String tableId = NameUtil.extractTableIdFromTableName(request.getTableName());
        ReadModifyWriteRow row = ReadModifyWriteRow.create(tableId, request.getRowKey());
        row.builder = request.toBuilder();
        return row;
    }
}

