/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.BatchingSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowControlSettings;
import com.google.bigtable.repackaged.com.google.api.gax.batching.FlowController;
import com.google.bigtable.repackaged.com.google.api.gax.core.FixedCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.retrying.RetrySettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StubSettings;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.TransportChannelProvider;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallSettings;
import com.google.bigtable.repackaged.com.google.auth.Credentials;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.Version;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableBatchingCallSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableBulkReadRowsCallSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableChannelPrimer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.HeaderTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.mutaterows.MutateRowsBatchingDescriptor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.readrows.ReadRowsBatchingDescriptor;
import com.google.bigtable.repackaged.com.google.common.base.MoreObjects;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableSet;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class EnhancedBigtableStubSettings
extends StubSettings<EnhancedBigtableStubSettings> {
    private static final Logger logger = Logger.getLogger(EnhancedBigtableStubSettings.class.getName());
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    private static final String SERVER_DEFAULT_APP_PROFILE_ID = "";
    private static final Set<StatusCode.Code> IDEMPOTENT_RETRY_CODES = ImmutableSet.of(StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE);
    private static final RetrySettings IDEMPOTENT_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes(1L)).setInitialRpcTimeout(Duration.ofSeconds(20L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofSeconds(20L)).setTotalTimeout(Duration.ofMinutes(10L)).build();
    private static final Set<StatusCode.Code> READ_ROWS_RETRY_CODES = ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll(IDEMPOTENT_RETRY_CODES)).add((Object)StatusCode.Code.ABORTED)).build();
    private static final RetrySettings READ_ROWS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes(1L)).setMaxAttempts(10).setJittered(true).setInitialRpcTimeout(Duration.ofMinutes(5L)).setRpcTimeoutMultiplier(2.0).setMaxRpcTimeout(Duration.ofMinutes(5L)).setTotalTimeout(Duration.ofHours(12L)).build();
    private static final RetrySettings MUTATE_ROWS_RETRY_SETTINGS = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis(10L)).setRetryDelayMultiplier(2.0).setMaxRetryDelay(Duration.ofMinutes(1L)).setInitialRpcTimeout(Duration.ofMinutes(1L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMinutes(1L)).setTotalTimeout(Duration.ofMinutes(10L)).build();
    private static final ImmutableList<String> JWT_ENABLED_SCOPES = ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add("https://www.googleapis.com/auth/bigtable.data")).add("https://www.googleapis.com/auth/cloud-bigtable.data")).add("https://www.googleapis.com/auth/cloud-platform")).build();
    private static final Map<String, String> DEFAULT_JWT_AUDIENCE_MAPPING = ImmutableMap.of("batch-bigtable.googleapis.com", "https://bigtable.googleapis.com/");
    private final String projectId;
    private final String instanceId;
    private final String appProfileId;
    private final boolean isRefreshingChannel;
    private ImmutableList<String> primedTableIds;
    private HeaderTracer headerTracer;
    private final Map<String, String> jwtAudienceMapping;
    private final ServerStreamingCallSettings<Query, Row> readRowsSettings;
    private final UnaryCallSettings<Query, Row> readRowSettings;
    private final UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings;
    private final UnaryCallSettings<RowMutation, Void> mutateRowSettings;
    private final BigtableBatchingCallSettings bulkMutateRowsSettings;
    private final BigtableBulkReadRowsCallSettings bulkReadRowsSettings;
    private final UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
    private final UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings;

    private EnhancedBigtableStubSettings(Builder builder) {
        super(builder);
        Preconditions.checkState(builder.readRowSettings.getRetryableCodes().equals(builder.readRowsSettings.getRetryableCodes()), "Single ReadRow retry codes must match ReadRows retry codes");
        Preconditions.checkState(builder.bulkReadRowsSettings.getRetryableCodes().equals(builder.readRowsSettings.getRetryableCodes()), "Bulk ReadRow retry codes must match ReadRows retry codes");
        this.projectId = builder.projectId;
        this.instanceId = builder.instanceId;
        this.appProfileId = builder.appProfileId;
        this.isRefreshingChannel = builder.isRefreshingChannel;
        this.primedTableIds = builder.primedTableIds;
        this.headerTracer = builder.headerTracer;
        this.jwtAudienceMapping = builder.jwtAudienceMapping;
        this.readRowsSettings = builder.readRowsSettings.build();
        this.readRowSettings = builder.readRowSettings.build();
        this.sampleRowKeysSettings = builder.sampleRowKeysSettings.build();
        this.mutateRowSettings = builder.mutateRowSettings.build();
        this.bulkMutateRowsSettings = builder.bulkMutateRowsSettings.build();
        this.bulkReadRowsSettings = builder.bulkReadRowsSettings.build();
        this.checkAndMutateRowSettings = builder.checkAndMutateRowSettings.build();
        this.readModifyWriteRowSettings = builder.readModifyWriteRowSettings.build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getAppProfileId() {
        return this.appProfileId;
    }

    @BetaApi(value="This API depends on experimental gRPC APIs")
    public boolean isRefreshingChannel() {
        return this.isRefreshingChannel;
    }

    @BetaApi(value="Channel priming is not currently stable and might change in the future")
    public List<String> getPrimedTableIds() {
        return this.primedTableIds;
    }

    HeaderTracer getHeaderTracer() {
        return this.headerTracer;
    }

    @InternalApi(value="Used for internal testing")
    public Map<String, String> getJwtAudienceMapping() {
        return this.jwtAudienceMapping;
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return BigtableStubSettings.defaultGrpcTransportProviderBuilder().setPoolSize(EnhancedBigtableStubSettings.getDefaultChannelPoolSize()).setMaxInboundMessageSize(0x10000000).setKeepAliveTime(Duration.ofSeconds(30L)).setKeepAliveTimeout(Duration.ofSeconds(10L)).setAttemptDirectPath(true);
    }

    static int getDefaultChannelPoolSize() {
        return 2 * Runtime.getRuntime().availableProcessors();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return EnhancedBigtableStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return BigtableStubSettings.defaultCredentialsProviderBuilder().setJwtEnabledScopes(JWT_ENABLED_SCOPES);
    }

    public ServerStreamingCallSettings<Query, Row> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<String, List<KeyOffset>> sampleRowKeysSettings() {
        return this.sampleRowKeysSettings;
    }

    public UnaryCallSettings<Query, Row> readRowSettings() {
        return this.readRowSettings;
    }

    public UnaryCallSettings<RowMutation, Void> mutateRowSettings() {
        return this.mutateRowSettings;
    }

    public BigtableBatchingCallSettings bulkMutateRowsSettings() {
        return this.bulkMutateRowsSettings;
    }

    public BigtableBulkReadRowsCallSettings bulkReadRowsSettings() {
        return this.bulkReadRowsSettings;
    }

    public UnaryCallSettings<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
        return this.checkAndMutateRowSettings;
    }

    public UnaryCallSettings<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
        return this.readModifyWriteRowSettings;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("projectId", this.projectId).add("instanceId", this.instanceId).add("appProfileId", this.appProfileId).add("isRefreshingChannel", this.isRefreshingChannel).add("primedTableIds", this.primedTableIds).add("headerTracer", this.headerTracer).add("jwtAudienceMapping", this.jwtAudienceMapping).add("readRowsSettings", this.readRowsSettings).add("readRowSettings", this.readRowSettings).add("sampleRowKeysSettings", this.sampleRowKeysSettings).add("mutateRowSettings", this.mutateRowSettings).add("bulkMutateRowsSettings", this.bulkMutateRowsSettings).add("bulkReadRowsSettings", this.bulkReadRowsSettings).add("checkAndMutateRowSettings", this.checkAndMutateRowSettings).add("readModifyWriteRowSettings", this.readModifyWriteRowSettings).add("parent", super.toString()).toString();
    }

    public static class Builder
    extends StubSettings.Builder<EnhancedBigtableStubSettings, Builder> {
        private String projectId;
        private String instanceId;
        private String appProfileId;
        private boolean isRefreshingChannel;
        private ImmutableList<String> primedTableIds;
        private HeaderTracer headerTracer;
        private Map<String, String> jwtAudienceMapping;
        private final ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings;
        private final UnaryCallSettings.Builder<Query, Row> readRowSettings;
        private final UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings;
        private final UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings;
        private final BigtableBatchingCallSettings.Builder bulkMutateRowsSettings;
        private final BigtableBulkReadRowsCallSettings.Builder bulkReadRowsSettings;
        private final UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings;
        private final UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings;

        private Builder() {
            this.appProfileId = EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID;
            this.isRefreshingChannel = false;
            this.primedTableIds = ImmutableList.of();
            this.headerTracer = HeaderTracer.newBuilder().build();
            this.jwtAudienceMapping = DEFAULT_JWT_AUDIENCE_MAPPING;
            this.setCredentialsProvider(EnhancedBigtableStubSettings.defaultCredentialsProviderBuilder().build());
            BigtableStubSettings.Builder baseDefaults = BigtableStubSettings.newBuilder();
            this.setEndpoint(baseDefaults.getEndpoint());
            this.setTransportChannelProvider(EnhancedBigtableStubSettings.defaultTransportChannelProvider());
            this.setStreamWatchdogCheckInterval(baseDefaults.getStreamWatchdogCheckInterval());
            this.setStreamWatchdogProvider(baseDefaults.getStreamWatchdogProvider());
            ImmutableMap<String, String> headers = ImmutableMap.builder().putAll(BigtableStubSettings.defaultApiClientHeaderProviderBuilder().build().getHeaders()).put("user-agent", "bigtable-java/" + Version.VERSION).build();
            this.setInternalHeaderProvider(FixedHeaderProvider.create(headers));
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.readRowsSettings.setRetryableCodes(READ_ROWS_RETRY_CODES).setRetrySettings(READ_ROWS_RETRY_SETTINGS).setIdleTimeout(Duration.ofMinutes(5L));
            this.readRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readRowSettings.setRetryableCodes(this.readRowsSettings.getRetryableCodes()).setRetrySettings(this.readRowsSettings().getRetrySettings().toBuilder().setTotalTimeout(IDEMPOTENT_RETRY_SETTINGS.getTotalTimeout()).build());
            this.sampleRowKeysSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.sampleRowKeysSettings.setRetryableCodes(IDEMPOTENT_RETRY_CODES).setRetrySettings(IDEMPOTENT_RETRY_SETTINGS);
            this.mutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.mutateRowSettings(), this.mutateRowSettings);
            long maxBulkMutateElementPerBatch = 100L;
            long maxBulkMutateOutstandingElementCount = Math.min(20000L, 10L * maxBulkMutateElementPerBatch * (long)EnhancedBigtableStubSettings.getDefaultChannelPoolSize());
            this.bulkMutateRowsSettings = ((BigtableBatchingCallSettings.Builder)BigtableBatchingCallSettings.newBuilder(new MutateRowsBatchingDescriptor()).setRetryableCodes(IDEMPOTENT_RETRY_CODES)).setRetrySettings(MUTATE_ROWS_RETRY_SETTINGS).setBatchingSettings(BatchingSettings.newBuilder().setIsEnabled(true).setElementCountThreshold(maxBulkMutateElementPerBatch).setRequestByteThreshold(0x1400000L).setDelayThreshold(Duration.ofSeconds(1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingRequestBytes(0x6400000L).setMaxOutstandingElementCount(maxBulkMutateOutstandingElementCount).build()).build());
            long maxBulkReadElementPerBatch = 100L;
            long maxBulkReadRequestSizePerBatch = 409600L;
            long maxBulkReadOutstandingElementCount = 10L * maxBulkReadElementPerBatch * (long)EnhancedBigtableStubSettings.getDefaultChannelPoolSize();
            this.bulkReadRowsSettings = ((BigtableBulkReadRowsCallSettings.Builder)BigtableBulkReadRowsCallSettings.newBuilder(new ReadRowsBatchingDescriptor()).setRetryableCodes((Set)this.readRowsSettings.getRetryableCodes())).setRetrySettings(IDEMPOTENT_RETRY_SETTINGS).setBatchingSettings(BatchingSettings.newBuilder().setElementCountThreshold(maxBulkReadElementPerBatch).setRequestByteThreshold(maxBulkReadRequestSizePerBatch).setDelayThreshold(Duration.ofSeconds(1L)).setFlowControlSettings(FlowControlSettings.newBuilder().setLimitExceededBehavior(FlowController.LimitExceededBehavior.Block).setMaxOutstandingElementCount(maxBulkReadOutstandingElementCount).build()).build());
            this.checkAndMutateRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.checkAndMutateRowSettings(), this.checkAndMutateRowSettings);
            this.readModifyWriteRowSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            Builder.copyRetrySettings(baseDefaults.readModifyWriteRowSettings(), this.readModifyWriteRowSettings);
        }

        private Builder(EnhancedBigtableStubSettings settings) {
            super(settings);
            this.projectId = settings.projectId;
            this.instanceId = settings.instanceId;
            this.appProfileId = settings.appProfileId;
            this.isRefreshingChannel = settings.isRefreshingChannel;
            this.primedTableIds = settings.primedTableIds;
            this.headerTracer = settings.headerTracer;
            this.jwtAudienceMapping = settings.jwtAudienceMapping;
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.readRowSettings = settings.readRowSettings.toBuilder();
            this.sampleRowKeysSettings = settings.sampleRowKeysSettings.toBuilder();
            this.mutateRowSettings = settings.mutateRowSettings.toBuilder();
            this.bulkMutateRowsSettings = settings.bulkMutateRowsSettings.toBuilder();
            this.bulkReadRowsSettings = settings.bulkReadRowsSettings.toBuilder();
            this.checkAndMutateRowSettings = settings.checkAndMutateRowSettings.toBuilder();
            this.readModifyWriteRowSettings = settings.readModifyWriteRowSettings.toBuilder();
        }

        private static void copyRetrySettings(UnaryCallSettings.Builder<?, ?> source, UnaryCallSettings.Builder<?, ?> dest) {
            dest.setRetryableCodes(source.getRetryableCodes());
            dest.setRetrySettings(source.getRetrySettings());
        }

        public Builder setProjectId(@Nonnull String projectId) {
            Preconditions.checkNotNull(projectId);
            this.projectId = projectId;
            return this;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public Builder setInstanceId(@Nonnull String instanceId) {
            Preconditions.checkNotNull(instanceId);
            this.instanceId = instanceId;
            return this;
        }

        public String getInstanceId() {
            return this.instanceId;
        }

        public Builder setAppProfileId(@Nonnull String appProfileId) {
            Preconditions.checkNotNull(appProfileId, "AppProfileId can't be null");
            this.appProfileId = appProfileId;
            return this;
        }

        public Builder setDefaultAppProfileId() {
            this.setAppProfileId(EnhancedBigtableStubSettings.SERVER_DEFAULT_APP_PROFILE_ID);
            return this;
        }

        public String getAppProfileId() {
            return this.appProfileId;
        }

        @BetaApi(value="This API depends on experimental gRPC APIs")
        public Builder setRefreshingChannel(boolean isRefreshingChannel) {
            this.isRefreshingChannel = isRefreshingChannel;
            return this;
        }

        @BetaApi(value="Channel priming is not currently stable and might change in the future")
        public Builder setPrimedTableIds(String ... tableIds) {
            this.primedTableIds = ImmutableList.copyOf(tableIds);
            return this;
        }

        @BetaApi(value="This API depends on experimental gRPC APIs")
        public boolean isRefreshingChannel() {
            return this.isRefreshingChannel;
        }

        @BetaApi(value="Channel priming is not currently stable and might change in the future")
        public List<String> getPrimedTableIds() {
            return this.primedTableIds;
        }

        Builder setHeaderTracer(HeaderTracer headerTracer) {
            this.headerTracer = headerTracer;
            return this;
        }

        HeaderTracer getHeaderTracer() {
            return this.headerTracer;
        }

        @InternalApi(value="Used for internal testing")
        public Builder setJwtAudienceMapping(Map<String, String> jwtAudienceMapping) {
            this.jwtAudienceMapping = Preconditions.checkNotNull(jwtAudienceMapping);
            return this;
        }

        @InternalApi(value="Used for internal testing")
        public Map<String, String> getJwtAudienceMapping() {
            return this.jwtAudienceMapping;
        }

        public ServerStreamingCallSettings.Builder<Query, Row> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<Query, Row> readRowSettings() {
            return this.readRowSettings;
        }

        public UnaryCallSettings.Builder<String, List<KeyOffset>> sampleRowKeysSettings() {
            return this.sampleRowKeysSettings;
        }

        public UnaryCallSettings.Builder<RowMutation, Void> mutateRowSettings() {
            return this.mutateRowSettings;
        }

        public BigtableBatchingCallSettings.Builder bulkMutateRowsSettings() {
            return this.bulkMutateRowsSettings;
        }

        public BigtableBulkReadRowsCallSettings.Builder bulkReadRowsSettings() {
            return this.bulkReadRowsSettings;
        }

        public UnaryCallSettings.Builder<ConditionalRowMutation, Boolean> checkAndMutateRowSettings() {
            return this.checkAndMutateRowSettings;
        }

        public UnaryCallSettings.Builder<ReadModifyWriteRow, Row> readModifyWriteRowSettings() {
            return this.readModifyWriteRowSettings;
        }

        public EnhancedBigtableStubSettings build() {
            Preconditions.checkState(this.projectId != null, "Project id must be set");
            Preconditions.checkState(this.instanceId != null, "Instance id must be set");
            if (this.isRefreshingChannel) {
                Preconditions.checkArgument(this.getTransportChannelProvider() instanceof InstantiatingGrpcChannelProvider, "refreshingChannel only works with InstantiatingGrpcChannelProviders");
                InstantiatingGrpcChannelProvider.Builder channelProviderBuilder = ((InstantiatingGrpcChannelProvider)this.getTransportChannelProvider()).toBuilder();
                Credentials credentials = null;
                if (this.getCredentialsProvider() != null) {
                    try {
                        credentials = this.getCredentialsProvider().getCredentials();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.setCredentialsProvider(FixedCredentialsProvider.create(credentials));
                channelProviderBuilder.setChannelPrimer(BigtableChannelPrimer.create(credentials, this.projectId, this.instanceId, this.appProfileId, this.primedTableIds));
                this.setTransportChannelProvider(channelProviderBuilder.build());
            }
            return new EnhancedBigtableStubSettings(this);
        }
    }
}

