/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResource;
import com.google.bigtable.repackaged.com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallSettings;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ClientContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.CheckAndMutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadModifyWriteRowResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableStub;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.BigtableStubSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.GrpcBigtableCallableFactory;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableMap;
import com.google.bigtable.repackaged.com.google.longrunning.stub.GrpcOperationsStub;
import com.google.bigtable.repackaged.io.grpc.MethodDescriptor;
import com.google.bigtable.repackaged.io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@InternalApi
public class GrpcBigtableStub
extends BigtableStub {
    private static final MethodDescriptor<ReadRowsRequest, ReadRowsResponse> readRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/ReadRows").setRequestMarshaller(ProtoUtils.marshaller(ReadRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ReadRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/SampleRowKeys").setRequestMarshaller(ProtoUtils.marshaller(SampleRowKeysRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(SampleRowKeysResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateRowRequest, MutateRowResponse> mutateRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/MutateRow").setRequestMarshaller(ProtoUtils.marshaller(MutateRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(MutateRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<MutateRowsRequest, MutateRowsResponse> mutateRowsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.SERVER_STREAMING).setFullMethodName("google.bigtable.v2.Bigtable/MutateRows").setRequestMarshaller(ProtoUtils.marshaller(MutateRowsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(MutateRowsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/CheckAndMutateRow").setRequestMarshaller(ProtoUtils.marshaller(CheckAndMutateRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(CheckAndMutateRowResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.bigtable.v2.Bigtable/ReadModifyWriteRow").setRequestMarshaller(ProtoUtils.marshaller(ReadModifyWriteRowRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller(ReadModifyWriteRowResponse.getDefaultInstance())).build();
    private final ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable;
    private final ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable;
    private final UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable;
    private final ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable;
    private final UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable;
    private final UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBigtableStub create(BigtableStubSettings settings) throws IOException {
        return new GrpcBigtableStub(settings, ClientContext.create(settings));
    }

    public static final GrpcBigtableStub create(ClientContext clientContext) throws IOException {
        return new GrpcBigtableStub(BigtableStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBigtableStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBigtableStub(BigtableStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBigtableStub(BigtableStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBigtableCallableFactory());
    }

    protected GrpcBigtableStub(BigtableStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create(clientContext, callableFactory);
        GrpcCallSettings<ReadRowsRequest, ReadRowsResponse> readRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readRowsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("table_name", String.valueOf(request.getTableName()));
            return params.build();
        }).build();
        GrpcCallSettings<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(sampleRowKeysMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("table_name", String.valueOf(request.getTableName()));
            return params.build();
        }).build();
        GrpcCallSettings<MutateRowRequest, MutateRowResponse> mutateRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateRowMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("table_name", String.valueOf(request.getTableName()));
            return params.build();
        }).build();
        GrpcCallSettings<MutateRowsRequest, MutateRowsResponse> mutateRowsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(mutateRowsMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("table_name", String.valueOf(request.getTableName()));
            return params.build();
        }).build();
        GrpcCallSettings<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(checkAndMutateRowMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("table_name", String.valueOf(request.getTableName()));
            return params.build();
        }).build();
        GrpcCallSettings<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(readModifyWriteRowMethodDescriptor).setParamsExtractor(request -> {
            ImmutableMap.Builder<String, String> params = ImmutableMap.builder();
            params.put("table_name", String.valueOf(request.getTableName()));
            return params.build();
        }).build();
        this.readRowsCallable = callableFactory.createServerStreamingCallable(readRowsTransportSettings, settings.readRowsSettings(), clientContext);
        this.sampleRowKeysCallable = callableFactory.createServerStreamingCallable(sampleRowKeysTransportSettings, settings.sampleRowKeysSettings(), clientContext);
        this.mutateRowCallable = callableFactory.createUnaryCallable(mutateRowTransportSettings, settings.mutateRowSettings(), clientContext);
        this.mutateRowsCallable = callableFactory.createServerStreamingCallable(mutateRowsTransportSettings, settings.mutateRowsSettings(), clientContext);
        this.checkAndMutateRowCallable = callableFactory.createUnaryCallable(checkAndMutateRowTransportSettings, settings.checkAndMutateRowSettings(), clientContext);
        this.readModifyWriteRowCallable = callableFactory.createUnaryCallable(readModifyWriteRowTransportSettings, settings.readModifyWriteRowSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.readRowsCallable;
    }

    @Override
    public ServerStreamingCallable<SampleRowKeysRequest, SampleRowKeysResponse> sampleRowKeysCallable() {
        return this.sampleRowKeysCallable;
    }

    @Override
    public UnaryCallable<MutateRowRequest, MutateRowResponse> mutateRowCallable() {
        return this.mutateRowCallable;
    }

    @Override
    public ServerStreamingCallable<MutateRowsRequest, MutateRowsResponse> mutateRowsCallable() {
        return this.mutateRowsCallable;
    }

    @Override
    public UnaryCallable<CheckAndMutateRowRequest, CheckAndMutateRowResponse> checkAndMutateRowCallable() {
        return this.checkAndMutateRowCallable;
    }

    @Override
    public UnaryCallable<ReadModifyWriteRowRequest, ReadModifyWriteRowResponse> readModifyWriteRowCallable() {
        return this.readModifyWriteRowCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    @Override
    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    @Override
    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    @Override
    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

