/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.bigtable.repackaged.com.google.api.gax.tracing.BaseApiTracer;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.org.threeten.bp.Duration;
import java.util.ArrayList;
import java.util.List;

class CompositeTracer
extends BaseApiTracer {
    private final List<ApiTracer> children;

    CompositeTracer(List<ApiTracer> children) {
        this.children = ImmutableList.copyOf(children);
    }

    @Override
    public ApiTracer.Scope inScope() {
        final ArrayList<ApiTracer.Scope> childScopes = new ArrayList<ApiTracer.Scope>(this.children.size());
        for (ApiTracer child : this.children) {
            childScopes.add(child.inScope());
        }
        return new ApiTracer.Scope(){

            @Override
            public void close() {
                for (ApiTracer.Scope childScope : childScopes) {
                    childScope.close();
                }
            }
        };
    }

    @Override
    public void operationSucceeded() {
        for (ApiTracer child : this.children) {
            child.operationSucceeded();
        }
    }

    @Override
    public void operationCancelled() {
        for (ApiTracer child : this.children) {
            child.operationCancelled();
        }
    }

    @Override
    public void operationFailed(Throwable error) {
        for (ApiTracer child : this.children) {
            child.operationFailed(error);
        }
    }

    @Override
    public void connectionSelected(String id) {
        for (ApiTracer child : this.children) {
            child.connectionSelected(id);
        }
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        for (ApiTracer child : this.children) {
            child.attemptStarted(attemptNumber);
        }
    }

    @Override
    public void attemptSucceeded() {
        for (ApiTracer child : this.children) {
            child.attemptSucceeded();
        }
    }

    @Override
    public void attemptCancelled() {
        for (ApiTracer child : this.children) {
            child.attemptCancelled();
        }
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        for (ApiTracer child : this.children) {
            child.attemptFailed(error, delay);
        }
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        for (ApiTracer child : this.children) {
            child.attemptFailedRetriesExhausted(error);
        }
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        for (ApiTracer child : this.children) {
            child.attemptPermanentFailure(error);
        }
    }

    @Override
    public void lroStartFailed(Throwable error) {
        for (ApiTracer child : this.children) {
            child.lroStartFailed(error);
        }
    }

    @Override
    public void lroStartSucceeded() {
        for (ApiTracer child : this.children) {
            child.lroStartSucceeded();
        }
    }

    @Override
    public void responseReceived() {
        for (ApiTracer child : this.children) {
            child.responseReceived();
        }
    }

    @Override
    public void requestSent() {
        for (ApiTracer child : this.children) {
            child.requestSent();
        }
    }

    @Override
    public void batchRequestSent(long elementCount, long requestSize) {
        for (ApiTracer child : this.children) {
            child.batchRequestSent(elementCount, requestSize);
        }
    }
}

