/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.StreamController;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.HeaderTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;

@InternalApi
public class HeaderTracerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> innerCallable;
    private final HeaderTracer headerTracer;
    private final String spanName;

    public HeaderTracerStreamingCallable(@Nonnull ServerStreamingCallable<RequestT, ResponseT> callable, @Nonnull HeaderTracer headerTracer, @Nonnull String spanName) {
        this.innerCallable = Preconditions.checkNotNull(callable, "Inner callable must be set");
        this.headerTracer = Preconditions.checkNotNull(headerTracer, "HeaderTracer must be set");
        this.spanName = Preconditions.checkNotNull(spanName, "Span name must be set");
    }

    @Override
    public void call(RequestT request, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
        if (RpcViews.isGfeMetricsRegistered()) {
            HeaderTracerResponseObserver<ResponseT> innerObserver = new HeaderTracerResponseObserver<ResponseT>(responseObserver, this.headerTracer, responseMetadata, this.spanName);
            this.innerCallable.call(request, innerObserver, responseMetadata.addHandlers(context));
        } else {
            this.innerCallable.call(request, responseObserver, context);
        }
    }

    private class HeaderTracerResponseObserver<ResponseT>
    implements ResponseObserver<ResponseT> {
        private ResponseObserver<ResponseT> outerObserver;
        private HeaderTracer headerTracer;
        private GrpcResponseMetadata responseMetadata;
        private String spanName;

        HeaderTracerResponseObserver(ResponseObserver<ResponseT> observer, HeaderTracer headerTracer, GrpcResponseMetadata metadata, String spanName) {
            this.outerObserver = observer;
            this.headerTracer = headerTracer;
            this.responseMetadata = metadata;
            this.spanName = spanName;
        }

        @Override
        public void onStart(StreamController controller) {
            this.outerObserver.onStart(controller);
        }

        @Override
        public void onResponse(ResponseT response) {
            this.outerObserver.onResponse(response);
        }

        @Override
        public void onError(Throwable t) {
            Metadata metadata = this.responseMetadata.getMetadata();
            if (metadata != null) {
                this.headerTracer.recordGfeMetadata(metadata, this.spanName);
            } else {
                this.headerTracer.recordGfeMissingHeader(this.spanName);
            }
            this.outerObserver.onError(t);
        }

        @Override
        public void onComplete() {
            Metadata metadata = this.responseMetadata.getMetadata();
            if (metadata != null) {
                this.headerTracer.recordGfeMetadata(metadata, this.spanName);
            } else {
                this.headerTracer.recordGfeMissingHeader(this.spanName);
            }
            this.outerObserver.onComplete();
        }
    }
}

