/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcResponseMetadata;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.HeaderTracer;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.metrics.RpcViews;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import com.google.bigtable.repackaged.javax.annotation.Nonnull;

@InternalApi
public class HeaderTracerUnaryCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> innerCallable;
    private final HeaderTracer headerTracer;
    private final String spanName;

    public HeaderTracerUnaryCallable(@Nonnull UnaryCallable<RequestT, ResponseT> innerCallable, @Nonnull HeaderTracer headerTracer, @Nonnull String spanName) {
        this.innerCallable = Preconditions.checkNotNull(innerCallable, "Inner callable must be set");
        this.headerTracer = Preconditions.checkNotNull(headerTracer, "HeaderTracer must be set");
        this.spanName = Preconditions.checkNotNull(spanName, "Span name must be set");
    }

    @Override
    public ApiFuture futureCall(RequestT request, ApiCallContext context) {
        if (RpcViews.isGfeMetricsRegistered()) {
            final GrpcResponseMetadata responseMetadata = new GrpcResponseMetadata();
            ApiFuture<ResponseT> future = this.innerCallable.futureCall(request, responseMetadata.addHandlers(context));
            future.addListener(new Runnable(){

                @Override
                public void run() {
                    Metadata metadata = responseMetadata.getMetadata();
                    if (metadata != null) {
                        HeaderTracerUnaryCallable.this.headerTracer.recordGfeMetadata(metadata, HeaderTracerUnaryCallable.this.spanName);
                    } else {
                        HeaderTracerUnaryCallable.this.headerTracer.recordGfeMissingHeader(HeaderTracerUnaryCallable.this.spanName);
                    }
                }
            }, MoreExecutors.directExecutor());
            return future;
        }
        return this.innerCallable.futureCall(request, context);
    }
}

