/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.client.util.BackOff;
import com.google.bigtable.repackaged.com.google.api.client.util.ExponentialBackOff;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.NanoClock;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Backup;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.BigtableTableAdminGrpc;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CheckConsistencyRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CheckConsistencyResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateBackupRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.CreateTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteBackupRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DeleteTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.DropRowRangeRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GenerateConsistencyTokenRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GenerateConsistencyTokenResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetBackupRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListBackupsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListBackupsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListTablesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ListTablesResponse;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.ModifyColumnFamiliesRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.RestoreTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.Table;
import com.google.bigtable.repackaged.com.google.bigtable.admin.v2.UpdateBackupRequest;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.BigtableOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.RetryOptions;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.DeadlineGeneratorFactory;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.BigtableAsyncUtilities;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async.RetryingUnaryOperation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.OperationUtil;
import com.google.bigtable.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.bigtable.repackaged.com.google.common.base.Predicates;
import com.google.bigtable.repackaged.com.google.common.primitives.Ints;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.bigtable.repackaged.com.google.iam.v1.GetIamPolicyRequest;
import com.google.bigtable.repackaged.com.google.iam.v1.Policy;
import com.google.bigtable.repackaged.com.google.iam.v1.SetIamPolicyRequest;
import com.google.bigtable.repackaged.com.google.iam.v1.TestIamPermissionsRequest;
import com.google.bigtable.repackaged.com.google.iam.v1.TestIamPermissionsResponse;
import com.google.bigtable.repackaged.com.google.longrunning.GetOperationRequest;
import com.google.bigtable.repackaged.com.google.longrunning.Operation;
import com.google.bigtable.repackaged.com.google.longrunning.OperationsGrpc;
import com.google.bigtable.repackaged.com.google.protobuf.Empty;
import com.google.bigtable.repackaged.io.grpc.Channel;
import com.google.bigtable.repackaged.io.grpc.Metadata;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@InternalApi(value="For internal usage only")
public class BigtableTableAdminGrpcClient
implements BigtableTableAdminClient {
    private final DeadlineGeneratorFactory deadlineGeneratorFactory = DeadlineGeneratorFactory.DEFAULT;
    private final OperationUtil operationUtil;
    private final BigtableAsyncRpc<ListTablesRequest, ListTablesResponse> listTablesRpc;
    private final RetryOptions retryOptions;
    private final ScheduledExecutorService retryExecutorService;
    private final BigtableAsyncRpc<GetTableRequest, Table> getTableRpc;
    private final BigtableAsyncRpc<CreateTableRequest, Table> createTableRpc;
    private final BigtableAsyncRpc<ModifyColumnFamiliesRequest, Table> modifyColumnFamilyRpc;
    private final BigtableAsyncRpc<DeleteTableRequest, Empty> deleteTableRpc;
    private final BigtableAsyncRpc<DropRowRangeRequest, Empty> dropRowRangeRpc;
    private final BigtableAsyncRpc<GenerateConsistencyTokenRequest, GenerateConsistencyTokenResponse> generateConsistencyTokenRpc;
    private final BigtableAsyncRpc<CheckConsistencyRequest, CheckConsistencyResponse> checkConsistencyRpc;
    private final BigtableAsyncRpc<GetIamPolicyRequest, Policy> getIamPolicyRpc;
    private final BigtableAsyncRpc<SetIamPolicyRequest, Policy> setIamPolicyRpc;
    private final BigtableAsyncRpc<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsRpc;
    private final BigtableAsyncRpc<SnapshotTableRequest, Operation> snapshotTableRpc;
    private final BigtableAsyncRpc<GetSnapshotRequest, Snapshot> getSnapshotRpc;
    private final BigtableAsyncRpc<ListSnapshotsRequest, ListSnapshotsResponse> listSnapshotsRpc;
    private final BigtableAsyncRpc<DeleteSnapshotRequest, Empty> deleteSnapshotRpc;
    private final BigtableAsyncRpc<CreateTableFromSnapshotRequest, Operation> createTableFromSnapshotRpc;
    private final BigtableAsyncRpc<GetBackupRequest, Backup> getBackupRpc;
    private final BigtableAsyncRpc<ListBackupsRequest, ListBackupsResponse> listBackupRpc;
    private final BigtableAsyncRpc<CreateBackupRequest, Operation> createBackupRpc;
    private final BigtableAsyncRpc<UpdateBackupRequest, Backup> updateBackupRpc;
    private final BigtableAsyncRpc<DeleteBackupRequest, Empty> deleteBackupRpc;
    private final BigtableAsyncRpc<RestoreTableRequest, Operation> restoreTableRpc;

    public BigtableTableAdminGrpcClient(Channel channel, ScheduledExecutorService retryExecutorService, BigtableOptions bigtableOptions) {
        BigtableAsyncUtilities.Default asyncUtilities = new BigtableAsyncUtilities.Default(channel);
        this.operationUtil = new OperationUtil(OperationsGrpc.newBlockingStub(channel));
        this.listTablesRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getListTablesMethod(), Predicates.alwaysTrue());
        this.getTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getGetTableMethod(), Predicates.alwaysTrue());
        this.listBackupRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getListBackupsMethod(), Predicates.alwaysTrue());
        this.getBackupRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getGetBackupMethod(), Predicates.alwaysTrue());
        this.createTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getCreateTableMethod(), Predicates.alwaysFalse());
        this.modifyColumnFamilyRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getModifyColumnFamiliesMethod(), Predicates.alwaysFalse());
        this.deleteTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getDeleteTableMethod(), Predicates.alwaysFalse());
        this.dropRowRangeRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getDropRowRangeMethod(), Predicates.alwaysFalse());
        this.generateConsistencyTokenRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getGenerateConsistencyTokenMethod(), Predicates.alwaysFalse());
        this.checkConsistencyRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getCheckConsistencyMethod(), Predicates.alwaysFalse());
        this.getIamPolicyRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getGetIamPolicyMethod(), Predicates.alwaysFalse());
        this.setIamPolicyRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getSetIamPolicyMethod(), Predicates.alwaysFalse());
        this.testIamPermissionsRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getTestIamPermissionsMethod(), Predicates.alwaysFalse());
        this.snapshotTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getSnapshotTableMethod(), Predicates.alwaysFalse());
        this.getSnapshotRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getGetSnapshotMethod(), Predicates.alwaysTrue());
        this.listSnapshotsRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getListSnapshotsMethod(), Predicates.alwaysTrue());
        this.deleteSnapshotRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getDeleteSnapshotMethod(), Predicates.alwaysFalse());
        this.createTableFromSnapshotRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getCreateTableFromSnapshotMethod(), Predicates.alwaysFalse());
        this.createBackupRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getCreateBackupMethod(), Predicates.alwaysFalse());
        this.updateBackupRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getUpdateBackupMethod(), Predicates.alwaysFalse());
        this.deleteBackupRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getDeleteBackupMethod(), Predicates.alwaysFalse());
        this.restoreTableRpc = asyncUtilities.createAsyncRpc(BigtableTableAdminGrpc.getRestoreTableMethod(), Predicates.alwaysFalse());
        this.retryOptions = bigtableOptions.getRetryOptions();
        this.retryExecutorService = retryExecutorService;
    }

    @Override
    public ListTablesResponse listTables(ListTablesRequest request) {
        return (ListTablesResponse)this.createUnaryListener(request, this.listTablesRpc, request.getParent()).getBlockingResult();
    }

    @Override
    public ListenableFuture<ListTablesResponse> listTablesAsync(ListTablesRequest request) {
        return this.createUnaryListener(request, this.listTablesRpc, request.getParent()).getAsyncResult();
    }

    @Override
    public Table getTable(GetTableRequest request) {
        return (Table)this.createUnaryListener(request, this.getTableRpc, request.getName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<Table> getTableAsync(GetTableRequest request) {
        return this.createUnaryListener(request, this.getTableRpc, request.getName()).getAsyncResult();
    }

    @Override
    public Table createTable(CreateTableRequest request) {
        return (Table)this.createUnaryListener(request, this.createTableRpc, request.getParent()).getBlockingResult();
    }

    @Override
    public ListenableFuture<Table> createTableAsync(CreateTableRequest request) {
        return this.createUnaryListener(request, this.createTableRpc, request.getParent()).getAsyncResult();
    }

    @Override
    public Table modifyColumnFamily(ModifyColumnFamiliesRequest request) {
        return (Table)this.createUnaryListener(request, this.modifyColumnFamilyRpc, request.getName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<Table> modifyColumnFamilyAsync(ModifyColumnFamiliesRequest request) {
        return this.createUnaryListener(request, this.modifyColumnFamilyRpc, request.getName()).getAsyncResult();
    }

    @Override
    public void deleteTable(DeleteTableRequest request) {
        this.createUnaryListener(request, this.deleteTableRpc, request.getName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<Empty> deleteTableAsync(DeleteTableRequest request) {
        return this.createUnaryListener(request, this.deleteTableRpc, request.getName()).getAsyncResult();
    }

    @Override
    public void dropRowRange(DropRowRangeRequest request) {
        this.createUnaryListener(request, this.dropRowRangeRpc, request.getName()).getBlockingResult();
    }

    @Override
    public ListenableFuture<Empty> dropRowRangeAsync(DropRowRangeRequest request) {
        return this.createUnaryListener(request, this.dropRowRangeRpc, request.getName()).getAsyncResult();
    }

    @Override
    public void waitForReplication(BigtableTableName tableName, long timeout) throws InterruptedException, TimeoutException {
        ExponentialBackOff backOff = new ExponentialBackOff.Builder().setInitialIntervalMillis(10000).setMaxIntervalMillis(10000).setMaxElapsedTimeMillis(Ints.checkedCast(timeout * 1000L)).build();
        this.waitForReplication(tableName, backOff);
    }

    @Override
    public Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.createUnaryListener(request, this.getIamPolicyRpc, request.getResource()).getBlockingResult();
    }

    @Override
    public Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.createUnaryListener(request, this.setIamPolicyRpc, request.getResource()).getBlockingResult();
    }

    @Override
    public TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.createUnaryListener(request, this.testIamPermissionsRpc, request.getResource()).getBlockingResult();
    }

    @Override
    public ListenableFuture<Operation> createBackupAsync(CreateBackupRequest request) {
        return this.createUnaryListener(request, this.createBackupRpc, request.getParent()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Backup> getBackupAsync(GetBackupRequest request) {
        return this.createUnaryListener(request, this.getBackupRpc, request.getName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Backup> updateBackupAsync(UpdateBackupRequest request) {
        return this.createUnaryListener(request, this.updateBackupRpc, request.getBackup().getName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<ListBackupsResponse> listBackupsAsync(ListBackupsRequest request) {
        return this.createUnaryListener(request, this.listBackupRpc, request.getParent()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Empty> deleteBackupAsync(DeleteBackupRequest request) {
        return this.createUnaryListener(request, this.deleteBackupRpc, request.getName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Operation> restoreTableAsync(RestoreTableRequest request) {
        return this.createUnaryListener(request, this.restoreTableRpc, request.getParent()).getAsyncResult();
    }

    @Override
    public Operation getOperation(GetOperationRequest request) {
        return this.operationUtil.getOperation(request);
    }

    @Override
    public Operation waitForOperation(Operation operation) throws IOException, TimeoutException {
        return this.operationUtil.waitForOperation(operation, 10L, TimeUnit.MINUTES);
    }

    @Override
    public Operation waitForOperation(Operation operation, long timeout, TimeUnit timeUnit) throws TimeoutException, IOException {
        return this.operationUtil.waitForOperation(operation, timeout, timeUnit);
    }

    @VisibleForTesting
    void waitForReplication(BigtableTableName tableName, BackOff backOff) throws InterruptedException, TimeoutException {
        String token = this.generateConsistencyToken(tableName);
        while (!this.checkConsistency(tableName, token)) {
            long backOffMillis;
            try {
                backOffMillis = backOff.nextBackOffMillis();
            }
            catch (IOException e) {
                throw new RuntimeException("Problem getting backoff: " + e);
            }
            if (backOffMillis == -1L) {
                throw new TimeoutException("Table " + tableName.toString() + " is not consistent after timeout.");
            }
            Thread.sleep(backOffMillis);
        }
    }

    private String generateConsistencyToken(BigtableTableName tableName) {
        GenerateConsistencyTokenRequest request = GenerateConsistencyTokenRequest.newBuilder().setName(tableName.toString()).build();
        return ((GenerateConsistencyTokenResponse)this.createUnaryListener(request, this.generateConsistencyTokenRpc, request.getName()).getBlockingResult()).getConsistencyToken();
    }

    private boolean checkConsistency(BigtableTableName tableName, String token) {
        CheckConsistencyRequest request = CheckConsistencyRequest.newBuilder().setName(tableName.toString()).setConsistencyToken(token).build();
        return ((CheckConsistencyResponse)this.createUnaryListener(request, this.checkConsistencyRpc, request.getName()).getBlockingResult()).getConsistent();
    }

    private <ReqT, RespT> RetryingUnaryOperation<ReqT, RespT> createUnaryListener(ReqT request, BigtableAsyncRpc<ReqT, RespT> rpc, String resource) {
        Metadata metadata = this.createMetadata(resource);
        return new RetryingUnaryOperation<ReqT, RespT>(this.retryOptions, request, rpc, this.deadlineGeneratorFactory.getRequestDeadlineGenerator(request, rpc.isRetryable(request)), this.retryExecutorService, metadata, NanoClock.getDefaultClock());
    }

    private Metadata createMetadata(String resource) {
        Metadata metadata = new Metadata();
        if (resource != null) {
            metadata.put(GoogleCloudResourcePrefixInterceptor.GRPC_RESOURCE_PREFIX_KEY, resource);
        }
        return metadata;
    }

    @Override
    public ListenableFuture<Operation> snapshotTableAsync(SnapshotTableRequest request) {
        return this.createUnaryListener(request, this.snapshotTableRpc, request.getName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Snapshot> getSnapshotAsync(GetSnapshotRequest request) {
        return this.createUnaryListener(request, this.getSnapshotRpc, request.getName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<ListSnapshotsResponse> listSnapshotsAsync(ListSnapshotsRequest request) {
        return this.createUnaryListener(request, this.listSnapshotsRpc, request.getParent()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Empty> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return this.createUnaryListener(request, this.deleteSnapshotRpc, request.getName()).getAsyncResult();
    }

    @Override
    public ListenableFuture<Operation> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest request) {
        return this.createUnaryListener(request, this.createTableFromSnapshotRpc, request.getParent()).getAsyncResult();
    }
}

