/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc;

import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowSet;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.CallOptionsConfig;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.DeadlineGeneratorFactory;
import com.google.bigtable.repackaged.com.google.common.base.Optional;
import com.google.bigtable.repackaged.io.grpc.Context;
import com.google.bigtable.repackaged.io.grpc.Deadline;
import java.util.concurrent.TimeUnit;

@InternalApi(value="For internal usage only")
public class ConfiguredDeadlineGeneratorFactory
implements DeadlineGeneratorFactory {
    private final CallOptionsConfig config;

    public ConfiguredDeadlineGeneratorFactory(CallOptionsConfig config) {
        this.config = config;
    }

    @Override
    public <RequestT> DeadlineGenerator getRequestDeadlineGenerator(RequestT request, boolean retriable) {
        if (ConfiguredDeadlineGeneratorFactory.isStreamingRead(request)) {
            return new DeadlineGeneratorImpl(this.config.isUseTimeout(), this.config.getReadStreamRpcTimeoutMs(), this.config.getReadStreamRpcAttemptTimeoutMs(), retriable, Optional.absent());
        }
        if (request instanceof MutateRowsRequest) {
            return new DeadlineGeneratorImpl(this.config.isUseTimeout(), this.config.getMutateRpcTimeoutMs(), this.config.getMutateRpcAttemptTimeoutMs(), retriable, Optional.of(TimeUnit.MINUTES.toMillis(6L)));
        }
        return new DeadlineGeneratorImpl(this.config.isUseTimeout(), this.config.getShortRpcTimeoutMs(), this.config.getShortRpcAttemptTimeoutMs(), retriable, Optional.of(TimeUnit.MINUTES.toMillis(6L)));
    }

    private static <RequestT> boolean isStreamingRead(RequestT request) {
        return request instanceof ReadRowsRequest && !ConfiguredDeadlineGeneratorFactory.isGet((ReadRowsRequest)request);
    }

    private static boolean isGet(ReadRowsRequest request) {
        RowSet rowSet = request.getRows();
        return rowSet != null && rowSet.getRowRangesCount() == 0 && rowSet.getRowKeysCount() == 1;
    }

    private static class DeadlineGeneratorImpl
    implements DeadlineGenerator {
        private final boolean useTimeout;
        private final int requestTimeoutMs;
        private final Optional<Integer> requestAttemptTimeoutMs;
        private final Optional<Long> nonTimeoutFallbackDeadlineMs;
        private final Optional<Deadline> operationDeadline;

        DeadlineGeneratorImpl(boolean useTimeout, int requestTimeoutMs, Optional<Integer> requestAttemptTimeoutMs, boolean retriable, Optional<Long> nonTimeoutFallbackDeadlineMs) {
            this.useTimeout = useTimeout;
            this.requestTimeoutMs = requestTimeoutMs;
            this.requestAttemptTimeoutMs = retriable ? requestAttemptTimeoutMs : Optional.absent();
            this.nonTimeoutFallbackDeadlineMs = nonTimeoutFallbackDeadlineMs;
            this.operationDeadline = this.createOperationDeadline();
        }

        private Optional<Deadline> createOperationDeadline() {
            Optional<Deadline> deadline = Optional.fromNullable(Context.current().getDeadline());
            if (this.useTimeout) {
                deadline = deadline.or(Optional.of(Deadline.after(this.requestTimeoutMs, TimeUnit.MILLISECONDS)));
            }
            return deadline;
        }

        @Override
        public Optional<Long> getOperationTimeoutMs() {
            return this.operationDeadline.isPresent() ? Optional.of(this.operationDeadline.get().timeRemaining(TimeUnit.MILLISECONDS)) : Optional.absent();
        }

        @Override
        public Optional<Deadline> getRpcAttemptDeadline() {
            if (this.useTimeout && this.requestAttemptTimeoutMs.isPresent()) {
                Deadline attemptDeadline = Deadline.after(this.requestAttemptTimeoutMs.get().intValue(), TimeUnit.MILLISECONDS);
                if (this.operationDeadline.isPresent()) {
                    return Optional.of(attemptDeadline.minimum(this.operationDeadline.get()));
                }
                return Optional.of(attemptDeadline);
            }
            if (this.operationDeadline.isPresent()) {
                return this.operationDeadline;
            }
            if (this.nonTimeoutFallbackDeadlineMs.isPresent()) {
                return Optional.of(Deadline.after(this.nonTimeoutFallbackDeadlineMs.get(), TimeUnit.MILLISECONDS));
            }
            return Optional.absent();
        }
    }
}

