/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.async;

import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.bigtable.repackaged.com.google.api.core.SettableApiFuture;
import com.google.bigtable.repackaged.com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.repackaged.com.google.bigtable.v2.RowFilter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.config.Logger;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.core.IBigtableDataClient;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.util.ByteStringComparator;
import com.google.bigtable.repackaged.com.google.common.base.Preconditions;
import com.google.bigtable.repackaged.com.google.common.collect.HashMultimap;
import com.google.bigtable.repackaged.com.google.common.collect.ImmutableList;
import com.google.bigtable.repackaged.com.google.common.collect.Iterables;
import com.google.bigtable.repackaged.com.google.common.collect.Multimap;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;

@InternalExtensionOnly
public class BulkRead {
    protected static final Logger LOG = new Logger(BulkRead.class);
    private static final Comparator<Map.Entry<ByteString, SettableApiFuture<FlatRow>>> ENTRY_SORTER = new Comparator<Map.Entry<ByteString, SettableApiFuture<FlatRow>>>(){

        @Override
        public int compare(Map.Entry<ByteString, SettableApiFuture<FlatRow>> o1, Map.Entry<ByteString, SettableApiFuture<FlatRow>> o2) {
            return ByteStringComparator.INSTANCE.compare(o1.getKey(), o2.getKey());
        }
    };
    private final IBigtableDataClient client;
    private final int batchSizes;
    private final ExecutorService threadPool;
    private final String tableId;
    private final RequestContext requestContext;
    private final Map<RowFilter, Batch> batches;

    @InternalApi(value="For internal usage only")
    public BulkRead(IBigtableDataClient client, BigtableTableName tableName, int batchSizes, ExecutorService threadPool) {
        this.client = client;
        this.tableId = tableName.getTableId();
        this.requestContext = RequestContext.create(tableName.getProjectId(), tableName.getInstanceId(), "");
        this.batchSizes = batchSizes;
        this.threadPool = threadPool;
        this.batches = new HashMap<RowFilter, Batch>();
    }

    public synchronized ApiFuture<FlatRow> add(Query query) {
        Preconditions.checkNotNull(query);
        ReadRowsRequest request = query.toProto(this.requestContext);
        Preconditions.checkArgument(request.getRows().getRowKeysCount() == 1);
        ByteString rowKey = request.getRows().getRowKeysList().get(0);
        Preconditions.checkArgument(!rowKey.equals(ByteString.EMPTY));
        RowFilter filter = request.getFilter();
        Batch batch = this.batches.get(filter);
        if (batch == null) {
            batch = new Batch(filter);
            this.batches.put(filter, batch);
        }
        return batch.addKey(rowKey);
    }

    public synchronized void flush() {
        for (Batch batch : this.batches.values()) {
            Collection<Batch> subbatches = batch.split();
            for (Batch miniBatch : subbatches) {
                this.threadPool.submit(miniBatch);
            }
        }
        this.batches.clear();
    }

    @InternalApi(value="For internal usage only")
    public int getBatchSizes() {
        return this.batchSizes;
    }

    private class Batch
    implements Runnable {
        private final RowFilter filter;
        private final Multimap<ByteString, SettableApiFuture<FlatRow>> futures;

        Batch(RowFilter filter) {
            this.filter = filter;
            this.futures = HashMultimap.create();
        }

        Collection<Batch> split() {
            if (this.futures.values().size() <= BulkRead.this.batchSizes) {
                return ImmutableList.of(this);
            }
            ArrayList<Map.Entry<ByteString, SettableApiFuture<FlatRow>>> toSplit = new ArrayList<Map.Entry<ByteString, SettableApiFuture<FlatRow>>>(this.futures.entries());
            Collections.sort(toSplit, ENTRY_SORTER);
            ArrayList<Batch> batches = new ArrayList<Batch>();
            for (List<Map.Entry<ByteString, SettableApiFuture<FlatRow>>> entries : Iterables.partition(toSplit, BulkRead.this.batchSizes)) {
                Batch batch = new Batch(this.filter);
                for (Map.Entry<ByteString, SettableApiFuture<FlatRow>> entry : entries) {
                    batch.futures.put(entry.getKey(), entry.getValue());
                }
                batches.add(batch);
            }
            return batches;
        }

        SettableApiFuture<FlatRow> addKey(ByteString rowKey) {
            SettableApiFuture<FlatRow> future = SettableApiFuture.create();
            this.futures.put(rowKey, future);
            return future;
        }

        @Override
        public void run() {
            try {
                Object row;
                Query query = Query.create(BulkRead.this.tableId).filter(Filters.FILTERS.fromProto(this.filter));
                for (ByteString key : this.futures.keys()) {
                    query.rowKey(key);
                }
                ResultScanner<FlatRow> scanner = BulkRead.this.client.readFlatRows(query);
                while ((row = scanner.next()) != null) {
                    Collection<SettableApiFuture<FlatRow>> collection = this.futures.get(((FlatRow)row).getRowKey());
                    if (collection != null) {
                        for (SettableApiFuture<FlatRow> rowFuture : collection) {
                            rowFuture.set((FlatRow)row);
                        }
                        this.futures.removeAll(((FlatRow)row).getRowKey());
                        continue;
                    }
                    LOG.warn("Found key: %s, but it was not in the original request.", ((FlatRow)row).getRowKey());
                }
                for (Map.Entry entry : this.futures.entries()) {
                    ((SettableApiFuture)entry.getValue()).set(null);
                }
            }
            catch (Throwable e) {
                for (Map.Entry<ByteString, SettableApiFuture<FlatRow>> entry : this.futures.entries()) {
                    entry.getValue().setException(e);
                }
            }
        }
    }
}

